/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.PathTree;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRootsSynchronizer
implements Disposable {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final ModuleType myModuleType;
    @Nullable
    private Set<LocalFileSystem.WatchRequest> myWatchRequest;

    public CidrRootsSynchronizer(@NotNull Project project2, @NotNull ModuleType moduleType) {
        this.myProject = project2;
        this.myModuleType = moduleType;
        Disposer.register((Disposable)project2, (Disposable)this);
        this.synchronizeOnFileMoves();
    }

    public void dispose() {
        this.registerWatchRoots(Collections.emptyList());
    }

    public void updateRoots(@NotNull RootsInfo info) {
        Module module2 = this.getModule();
        if (module2 != null) {
            CidrRootsSynchronizer.registerRoots(ModuleRootManager.getInstance((Module)module2), info);
        }
        this.registerWatchRoots(info.watchRoots);
    }

    @Nullable
    public Module getModule() {
        return CidrRootsSynchronizer.getModule(this.myProject, this.myModuleType);
    }

    @Nullable
    public static Module getModule(@NotNull Project project2, @NotNull ModuleType type) {
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            if (!type.equals((Object)ModuleType.get((Module)module2))) continue;
            return module2;
        }
        return null;
    }

    private void registerWatchRoots(@NotNull List<File> roots) {
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequest);
            this.myWatchRequest = null;
        }
        if (!roots.isEmpty()) {
            Function<File, String> paths = new Function<File, String>(){

                public String fun(File file2) {
                    return file2.getPath();
                }
            };
            this.myWatchRequest = LocalFileSystem.getInstance().addRootsToWatch((Collection)ContainerUtil.map(roots, (Function)paths), true);
        }
    }

    private static void registerRoots(@NotNull ModuleRootManager rootManager, final @NotNull RootsInfo info) {
        RootTree tree = new RootTree();
        tree.addAll(info.contentRoots, RootKind.CONTENT);
        tree.addAll(info.sourceFiles, RootKind.SOURCE);
        tree.addAll(info.explicitLibraryRoots, RootKind.EXPLICIT_LIBRARY);
        tree.addAll(info.explicitSourceFolders, RootKind.EXPLICIT_SOURCE);
        tree.addAll(info.explicitExcludeFolders, RootKind.EXPLICIT_EXCLUDE);
        tree.addAll(info.headerSearchRoots.systemHeaderRoots, RootKind.LIBRARY);
        tree.addAll(info.headerSearchRoots.excludeRoots, RootKind.LIBRARY_EXCLUDE);
        tree.addAll(CidrRootsSynchronizer.removeDuplicatesAndSubdirs(info.headerSearchRoots.userHeaderRoots), RootKind.CONTENT);
        final ModifiableRootModel model = rootManager.getModifiableModel();
        model.clear();
        LibraryTable table = model.getModuleLibraryTable();
        Library library = table.createLibrary(CidrBundle.message("project.view.library.node", new Object[0]));
        final LibraryEx.ModifiableModelEx libraryModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        tree.accept(new RootTree.Visitor(){
            final Stack<State> stack = new Stack();
            State state;

            @Override
            public void enter() {
                this.stack.push(this.state);
                this.state = this.state == null ? new State() : new State(this.state);
            }

            @Override
            public boolean visit(@NotNull Set<RootItem> items) {
                RootItem sourceItem;
                if (items.isEmpty()) {
                    return true;
                }
                RootItem excludeItem = this.find(items, RootKind.EXPLICIT_EXCLUDE);
                if (excludeItem != null) {
                    if (this.state.contentEntry != null) {
                        this.state.contentEntry.addExcludeFolder(excludeItem.getUrl());
                    }
                    if (this.state.isLibraryRoot) {
                        libraryModel.addExcludedRoot(excludeItem.getUrl());
                        this.state.isLibraryRoot = false;
                    }
                    return false;
                }
                RootItem contentItem = this.find(items, RootKind.CONTENT);
                if (contentItem != null && this.state.contentEntry == null) {
                    this.state.contentEntry = model.addContentEntry(contentItem.getUrl());
                    if (this.state.isLibraryRoot) {
                        libraryModel.addExcludedRoot(contentItem.getUrl());
                        this.state.isLibraryRoot = false;
                    }
                }
                if ((sourceItem = this.find(items, RootKind.EXPLICIT_SOURCE)) != null) {
                    this.addSourceFolder(sourceItem);
                    this.state.isExplicitRoot = true;
                    return true;
                }
                RootItem libraryItem = this.find(items, RootKind.EXPLICIT_LIBRARY);
                if (libraryItem != null) {
                    this.addLibraryRoot(libraryItem);
                    this.state.isExplicitRoot = true;
                    return true;
                }
                if (this.state.isExplicitRoot) {
                    return true;
                }
                sourceItem = this.find(items, RootKind.SOURCE);
                if (sourceItem != null) {
                    this.addSourceFolder(sourceItem);
                    return true;
                }
                if (info.registerSystemHeaderRootUnderContentRootAsLibraries || this.state.contentEntry == null) {
                    RootItem libraryExclude = this.find(items, RootKind.LIBRARY_EXCLUDE);
                    if (libraryExclude != null && this.state.isLibraryRoot) {
                        libraryModel.addExcludedRoot(libraryExclude.getUrl());
                        this.state.isLibraryRoot = false;
                    } else if (contentItem == null && (libraryItem = this.find(items, RootKind.LIBRARY)) != null) {
                        this.addLibraryRoot(libraryItem);
                    }
                }
                return true;
            }

            private void addSourceFolder(@NotNull RootItem item) {
                if (this.state.contentEntry == null) {
                    this.state.contentEntry = model.addContentEntry(item.getUrl());
                }
                if (this.state.sourceFolder == null) {
                    this.state.sourceFolder = this.state.contentEntry.addSourceFolder(item.getUrl(), false);
                }
                if (this.state.isLibraryRoot) {
                    libraryModel.addExcludedRoot(item.getUrl());
                    this.state.isLibraryRoot = false;
                }
            }

            private void addLibraryRoot(@NotNull RootItem item) {
                if (!this.state.isLibraryRoot) {
                    String libraryRootUrl = item.getUrl();
                    libraryModel.addRoot(libraryRootUrl, OrderRootType.CLASSES);
                    libraryModel.addRoot(libraryRootUrl, OrderRootType.SOURCES);
                    this.state.isLibraryRoot = true;
                    this.state.sourceFolder = null;
                }
            }

            @Nullable
            private RootItem find(Set<RootItem> items, RootKind kind) {
                for (RootItem each : items) {
                    if (each.kind != kind) continue;
                    return each;
                }
                return null;
            }

            @Override
            public void exit() {
                this.state = this.stack.pop();
            }

            class State {
                @Nullable
                ContentEntry contentEntry;
                @Nullable
                SourceFolder sourceFolder;
                @Nullable
                ExcludeFolder excludeFolder;
                boolean isLibraryRoot;
                boolean isExplicitRoot;

                public State() {
                }

                public State(State other) {
                    this.contentEntry = other.contentEntry;
                    this.sourceFolder = other.sourceFolder;
                    this.excludeFolder = other.excludeFolder;
                    this.isLibraryRoot = other.isLibraryRoot;
                    this.isExplicitRoot = other.isExplicitRoot;
                }
            }
        });
        libraryModel.commit();
        if (model.isChanged()) {
            model.commit();
        } else {
            model.dispose();
        }
    }

    private void synchronizeOnFileMoves() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Module module2 = CidrRootsSynchronizer.this.getModule();
                if (module2 == null) {
                    return;
                }
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
                ModuleFileIndex index = rootManager.getFileIndex();
                FactoryMap<OrderEntry, LibraryEx.ModifiableModelEx> libraryModels = new FactoryMap<OrderEntry, LibraryEx.ModifiableModelEx>(){

                    @Nullable
                    protected LibraryEx.ModifiableModelEx create(OrderEntry key) {
                        return (LibraryEx.ModifiableModelEx)((ModuleLibraryOrderEntryImpl)key).getLibrary().getModifiableModel();
                    }
                };
                THashSet rootsToExclude = new THashSet();
                Collections.addAll(rootsToExclude, rootManager.getContentRoots());
                Collections.addAll(rootsToExclude, rootManager.getSourceRoots());
                Collections.addAll(rootsToExclude, rootManager.getExcludeRoots());
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                    for (VirtualFile eachRoot : this.getSubRoots(((VFileMoveEvent)vFileEvent).getFile(), (Collection<VirtualFile>)rootsToExclude)) {
                        OrderEntry isInLibrary;
                        OrderEntry wasInLibrary = index.getOrderEntryForFile(((VFileMoveEvent)vFileEvent).getOldParent());
                        if (wasInLibrary instanceof ModuleLibraryOrderEntryImpl == (isInLibrary = index.getOrderEntryForFile(eachRoot.getParent())) instanceof ModuleLibraryOrderEntryImpl) continue;
                        if (isInLibrary instanceof ModuleLibraryOrderEntryImpl) {
                            ((LibraryEx.ModifiableModelEx)libraryModels.get(isInLibrary)).addExcludedRoot(eachRoot.getUrl());
                            continue;
                        }
                        ((LibraryEx.ModifiableModelEx)libraryModels.get(wasInLibrary)).removeExcludedRoot(eachRoot.getUrl());
                    }
                }
                for (LibraryEx.ModifiableModelEx modifiableModelEx : libraryModels.values()) {
                    modifiableModelEx.commit();
                }
            }

            private List<VirtualFile> getSubRoots(VirtualFile from, final Collection<VirtualFile> roots) {
                final ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
                VfsUtilCore.processFilesRecursively((VirtualFile)from, (Processor)new Processor<VirtualFile>(){

                    public boolean process(VirtualFile file2) {
                        if (roots.contains(file2)) {
                            result.add(file2);
                        }
                        return true;
                    }
                });
                return result;
            }
        });
    }

    public static void collectHeaderSearchRoots(@NotNull Collection<? extends HeadersSearchRoot> headerRoots, final @NotNull HeaderSearchRoots result) {
        for (final HeadersSearchRoot headersSearchRoot : headerRoots) {
            headersSearchRoot.processChildren(new HeadersSearchRootProcessor(){

                @Override
                public boolean shouldProcessRootsOnly() {
                    return true;
                }

                @Override
                public boolean processFramework(@NotNull VirtualFile frameworkRoot) {
                    result.excludeRoots.add(new File(frameworkRoot.getPath()));
                    return true;
                }

                @Override
                public boolean process(@NotNull VirtualFile file2) {
                    if (file2.isDirectory()) {
                        if (headersSearchRoot.isUserHeaders()) {
                            result.userHeaderRoots.add(new File(file2.getPath()));
                        } else {
                            result.systemHeaderRoots.add(new File(file2.getPath()));
                        }
                    }
                    return true;
                }
            });
        }
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file2) {
        return CidrRootsSynchronizer.isUnder(parents, file2, false);
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file2, boolean strict) {
        if (parents == null || file2 == null) {
            return false;
        }
        for (File parent : parents) {
            if (!FileUtil.isAncestor((File)parent, (File)file2, (boolean)strict)) continue;
            return true;
        }
        return false;
    }

    private static List<File> removeDuplicatesAndSubdirs(Collection<File> files) {
        ArrayList answer = ContainerUtil.newArrayList(files);
        Collections.sort(answer, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return FileUtil.compareFiles((File)o1, (File)o2);
            }
        });
        Iterator it = answer.iterator();
        File prev = null;
        while (it.hasNext()) {
            File next = (File)it.next();
            if (prev != null && FileUtil.isAncestor((File)prev, (File)next, (boolean)false)) {
                it.remove();
                continue;
            }
            prev = next;
        }
        return answer;
    }

    private static class RootTree
    extends PathTree<RootTree, RootItem> {
        private RootTree() {
        }

        @Override
        protected RootTree createNewTree(@Nullable RootTree parent) {
            return new RootTree();
        }

        public void addAll(@NotNull Collection<File> files, @NotNull RootKind kind) {
            for (File each : files) {
                this.addItem(each.getPath(), new RootItem(each, kind));
            }
        }

        public void accept(@NotNull Visitor visitor) {
            visitor.enter();
            if (visitor.visit(this.getItems())) {
                for (RootTree each : this.getChildren()) {
                    each.accept(visitor);
                }
            }
            visitor.exit();
        }

        public static interface Visitor {
            public void enter();

            public boolean visit(@NotNull Set<RootItem> var1);

            public void exit();
        }
    }

    private static class RootItem {
        @NotNull
        final File file;
        @NotNull
        final RootKind kind;

        public RootItem(@NotNull File file2, @NotNull RootKind kind) {
            this.kind = kind;
            this.file = file2;
        }

        @NotNull
        String getUrl() {
            return VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.file.getPath()));
        }
    }

    private static enum RootKind {
        CONTENT,
        SOURCE,
        LIBRARY,
        LIBRARY_EXCLUDE,
        EXPLICIT_SOURCE,
        EXPLICIT_LIBRARY,
        EXPLICIT_EXCLUDE;

    }

    public static class RootsInfo {
        @NotNull
        public final List<File> watchRoots = new ArrayList<File>();
        @NotNull
        public final List<File> contentRoots = new ArrayList<File>();
        @NotNull
        public final List<File> sourceFiles = new ArrayList<File>();
        @NotNull
        public final List<File> explicitSourceFolders = new ArrayList<File>();
        @NotNull
        public final List<File> explicitLibraryRoots = new ArrayList<File>();
        @NotNull
        public final List<File> explicitExcludeFolders = new ArrayList<File>();
        @NotNull
        public final HeaderSearchRoots headerSearchRoots = new HeaderSearchRoots();
        public boolean registerSystemHeaderRootUnderContentRootAsLibraries = true;

        public void fillHeaderSearchRoots(@NotNull Collection<? extends HeadersSearchRoot> headerRoots) {
            CidrRootsSynchronizer.collectHeaderSearchRoots(headerRoots, this.headerSearchRoots);
        }
    }

    public static class HeaderSearchRoots {
        @NotNull
        public final List<File> systemHeaderRoots = new ArrayList<File>();
        @NotNull
        public final List<File> userHeaderRoots = new ArrayList<File>();
        @NotNull
        public final List<File> excludeRoots = new ArrayList<File>();
    }
}

