/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.jetbrains.cidr.project.CidrRootConfigurationListener;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="CidrRootsConfiguration")
@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0002\b\u000b\b\u0007\u0018\u0000 32\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0003345B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u000f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001d\u0010\u0013\u001a\u00020\u000b2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u0018\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0002J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\n\u0010$\u001a\u0004\u0018\u00010\u0003H\u0016JB\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001b2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110)2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0+H\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0003H\u0016J\u0010\u0010.\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001c\u0010/\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u00100\u001a\u0004\u0018\u00010\u0011H\u0002J&\u00101\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u001d\u00102\u001a\u00020\u000b2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/jetbrains/cidr/project/CidrRootConfiguration;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myState", "Lcom/jetbrains/cidr/project/CidrRootConfiguration$State;", "addExcludeRoot", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "addLibraryRoot", "addRoot", "rootType", "Lcom/jetbrains/cidr/project/CidrRootConfiguration$RootType;", "addSourceRoot", "beforeValidityChanged", "pointers", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "([Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;)V", "createPointer", "Lorg/jetbrains/annotations/NotNull;", "path", "", "fireEvents", "getExcludeRoots", "", "Ljava/io/File;", "getLibraryRoots", "getRoots", "state", "getSourceRoots", "getState", "loadRoots", "parent", "name", "roots", "", "added", "", "loadState", "element", "removeRoot", "replaceRoot", "replaceWith", "saveRoots", "validityChanged", "Companion", "RootType", "State", "cidr-common"})
public final class CidrRootConfiguration
extends AbstractProjectComponent
implements PersistentStateComponent<Element>,
VirtualFilePointerListener {
    private volatile State myState;
    @JvmField
    @NotNull
    public static final Key<Boolean> MODULE_SUPPORTS_ROOTS_CONFIGURATION;
    public static final Companion Companion;

    @NotNull
    public final Collection<File> getSourceRoots() {
        return this.getRoots(this.myState, RootType.SOURCE);
    }

    @NotNull
    public final Collection<File> getLibraryRoots() {
        return this.getRoots(this.myState, RootType.LIBRARY);
    }

    @NotNull
    public final Collection<File> getExcludeRoots() {
        return this.getRoots(this.myState, RootType.EXCLUDED);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<File> getRoots(State state, RootType rootType) {
        Collection destination$iv$iv;
        void $receiver$iv$iv$iv;
        Object $receiver$iv$iv;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object $receiver$iv = (Map)state.getRoots();
        Map map = $receiver$iv;
        Map map2 = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv;
        for (Map.Entry entry : $receiver$iv$iv$iv.entrySet()) {
            Map.Entry it = entry;
            if (!Intrinsics.areEqual((Object)((Object)((RootType)((Object)it.getValue()))), (Object)((Object)rootType))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        $receiver$iv = destination$iv$iv.keySet();
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            VirtualFilePointer virtualFilePointer = (VirtualFilePointer)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file2 = new File(VfsUtil.urlToPath((String)virtualFilePointer.getUrl()));
            collection.add(file2);
        }
        return (List)destination$iv$iv;
    }

    public final void addSourceRoot(@Nullable VirtualFile file2) {
        this.addRoot(file2, RootType.SOURCE);
    }

    public final void addLibraryRoot(@Nullable VirtualFile file2) {
        this.addRoot(file2, RootType.LIBRARY);
    }

    public final void addExcludeRoot(@Nullable VirtualFile file2) {
        this.addRoot(file2, RootType.EXCLUDED);
    }

    private final void addRoot(VirtualFile file2, RootType rootType) {
        this.replaceRoot(file2, rootType);
    }

    public final void removeRoot(@Nullable VirtualFile file2) {
        this.replaceRoot(file2, null);
    }

    private final void replaceRoot(VirtualFile file2, RootType replaceWith) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (file2 == null) {
            return;
        }
        THashMap<VirtualFilePointer, RootType> roots = this.myState.getRoots();
        boolean changed = false;
        boolean shouldCreate = true;
        Iterator iterator = roots.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFilePointer eachPointer = (VirtualFilePointer)iterator.next();
            if (!file2.equals((Object)eachPointer.getFile())) continue;
            if (Intrinsics.areEqual((Object)((Object)((RootType)((Object)roots.get((Object)eachPointer)))), (Object)((Object)replaceWith)) ^ true) {
                iterator.remove();
                changed = true;
                continue;
            }
            shouldCreate = false;
        }
        if (shouldCreate && replaceWith != null) {
            VirtualFilePointer pointer = this.createPointer(file2);
            roots.put((Object)pointer, (Object)replaceWith);
            changed = true;
        }
        if (changed) {
            this.fireEvents();
        }
    }

    private final void fireEvents() {
        ((CidrRootConfigurationListener)this.myProject.getMessageBus().syncPublisher(CidrRootConfigurationListener.TOPIC)).configurationChanged();
    }

    @Nullable
    public Element getState() {
        Element roots = new Element("roots");
        ApplicationManager.getApplication().runReadAction(new Runnable(this, roots){
            final /* synthetic */ CidrRootConfiguration this$0;
            final /* synthetic */ Element $roots;

            public final void run() {
                State state = CidrRootConfiguration.access$getMyState$p(this.this$0);
                CidrRootConfiguration.access$saveRoots(this.this$0, this.$roots, "sourceRoots", CidrRootConfiguration.access$getRoots(this.this$0, state, RootType.SOURCE));
                CidrRootConfiguration.access$saveRoots(this.this$0, this.$roots, "libraryRoots", CidrRootConfiguration.access$getRoots(this.this$0, state, RootType.LIBRARY));
                CidrRootConfiguration.access$saveRoots(this.this$0, this.$roots, "excludeRoots", CidrRootConfiguration.access$getRoots(this.this$0, state, RootType.EXCLUDED));
            }
            {
                this.this$0 = cidrRootConfiguration;
                this.$roots = element;
            }
        });
        return roots;
    }

    public void loadState(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        State newState = new State();
        THashSet added = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        this.loadRoots(element, "sourceRoots", (Map)newState.getRoots(), RootType.SOURCE, (Set)added);
        this.loadRoots(element, "libraryRoots", (Map)newState.getRoots(), RootType.LIBRARY, (Set)added);
        this.loadRoots(element, "excludeRoots", (Map)newState.getRoots(), RootType.EXCLUDED, (Set)added);
        State oldState = this.myState;
        boolean hasChanges = !oldState.getRoots().equals(newState.getRoots());
        this.myState = newState;
        if (hasChanges && ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                final /* synthetic */ CidrRootConfiguration this$0;

                public final void run() {
                    CidrRootConfiguration.access$fireEvents(this.this$0);
                }
                {
                    this.this$0 = cidrRootConfiguration;
                }
            });
        }
    }

    private final void saveRoots(Element parent, String name, Collection<? extends File> roots) {
        Element list = new Element(name);
        for (File each : CollectionsKt.sorted((Iterable)roots)) {
            Element eachElement = new Element("file");
            eachElement.setAttribute("path", FileUtil.toSystemIndependentName((String)each.getPath()));
            list.addContent(eachElement);
        }
        parent.addContent(list);
    }

    private final void loadRoots(Element parent, String name, Map<VirtualFilePointer, RootType> roots, RootType rootType, Set<String> added) {
        Element element = parent.getChild(name);
        if (element == null) {
            return;
        }
        for (Element each : element.getChildren("file")) {
            String path;
            if (each.getAttributeValue("path") == null) {
                continue;
            }
            if (!added.add(path)) continue;
            VirtualFilePointer virtualFilePointer = this.createPointer(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"createPointer(path)");
            roots.put(virtualFilePointer, rootType);
        }
    }

    private final VirtualFilePointer createPointer(String path) {
        return VirtualFilePointerManager.getInstance().create(VfsUtil.pathToUrl((String)path), (Disposable)this.myProject, (VirtualFilePointerListener)this);
    }

    private final VirtualFilePointer createPointer(VirtualFile file2) {
        return VirtualFilePointerManager.getInstance().create(file2, (Disposable)this.myProject, (VirtualFilePointerListener)this);
    }

    public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
        Intrinsics.checkParameterIsNotNull((Object)pointers, (String)"pointers");
    }

    /*
     * WARNING - void declaration
     */
    public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
        Intrinsics.checkParameterIsNotNull((Object)pointers, (String)"pointers");
        boolean updated = false;
        THashMap<VirtualFilePointer, RootType> roots = this.myState.getRoots();
        for (int i = 0; i < pointers.length; ++i) {
            boolean bl;
            VirtualFilePointer eachChanged;
            block3: {
                void $receiver$iv;
                eachChanged = pointers[i];
                if (!eachChanged.isValid() || !roots.contains((Object)eachChanged)) continue;
                Iterable iterable = roots.keySet();
                for (Object element$iv : $receiver$iv) {
                    VirtualFilePointer it = (VirtualFilePointer)element$iv;
                    if (!(Intrinsics.areEqual((Object)it, (Object)eachChanged) ^ true && it.getUrl().equals(eachChanged.getUrl()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) continue;
            roots.remove((Object)eachChanged);
            updated = true;
        }
        if (updated) {
            this.fireEvents();
        }
    }

    public CidrRootConfiguration(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.myState = new State();
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"MODULE_SUPPORTS_ROOTS_CONFIGURATION");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"MODULE_SUPPORTS_ROOTS_CONFIGURATION\")");
        MODULE_SUPPORTS_ROOTS_CONFIGURATION = key;
    }

    @NotNull
    public static final /* synthetic */ State access$getMyState$p(CidrRootConfiguration $this) {
        return $this.myState;
    }

    public static final /* synthetic */ void access$setMyState$p(CidrRootConfiguration $this, @NotNull State state) {
        $this.myState = state;
    }

    public static final /* synthetic */ void access$saveRoots(CidrRootConfiguration $this, @NotNull Element parent, @NotNull String name, @NotNull Collection roots) {
        $this.saveRoots(parent, name, roots);
    }

    @NotNull
    public static final /* synthetic */ Collection access$getRoots(CidrRootConfiguration $this, @NotNull State state, @NotNull RootType rootType) {
        return $this.getRoots(state, rootType);
    }

    public static final /* synthetic */ void access$fireEvents(CidrRootConfiguration $this) {
        $this.fireEvents();
    }

    @JvmStatic
    @NotNull
    public static final CidrRootConfiguration getInstance(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return Companion.getInstance(project2);
    }

    @JvmStatic
    public static final void setEnabledFor(@NotNull Module module2) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Companion.setEnabledFor(module2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/project/CidrRootConfiguration$RootType;", "", "(Ljava/lang/String;I)V", "SOURCE", "LIBRARY", "EXCLUDED", "cidr-common"})
    private static final class RootType
    extends Enum<RootType> {
        public static final /* enum */ RootType SOURCE;
        public static final /* enum */ RootType LIBRARY;
        public static final /* enum */ RootType EXCLUDED;
        private static final /* synthetic */ RootType[] $VALUES;

        static {
            RootType[] rootTypeArray = new RootType[3];
            RootType[] rootTypeArray2 = rootTypeArray;
            rootTypeArray[0] = SOURCE = new RootType();
            rootTypeArray[1] = LIBRARY = new RootType();
            rootTypeArray[2] = EXCLUDED = new RootType();
            $VALUES = rootTypeArray;
        }

        public static RootType[] values() {
            return (RootType[])$VALUES.clone();
        }

        public static RootType valueOf(String string) {
            return Enum.valueOf(RootType.class, string);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/project/CidrRootConfiguration$State;", "", "()V", "roots", "Lgnu/trove/THashMap;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "Lcom/jetbrains/cidr/project/CidrRootConfiguration$RootType;", "getRoots", "()Lgnu/trove/THashMap;", "cidr-common"})
    private static final class State {
        @NotNull
        private final THashMap<VirtualFilePointer, RootType> roots = new THashMap();

        @NotNull
        public final THashMap<VirtualFilePointer, RootType> getRoots() {
            return this.roots;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/project/CidrRootConfiguration$Companion;", "", "()V", "MODULE_SUPPORTS_ROOTS_CONFIGURATION", "Lcom/intellij/openapi/util/Key;", "", "getInstance", "Lcom/jetbrains/cidr/project/CidrRootConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "setEnabledFor", "", "module", "Lcom/intellij/openapi/module/Module;", "cidr-common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CidrRootConfiguration getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Object object = project2.getComponent(CidrRootConfiguration.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (CidrRootConfiguration)((Object)object);
        }

        @JvmStatic
        public final void setEnabledFor(@NotNull Module module2) {
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            module2.putUserData(MODULE_SUPPORTS_ROOTS_CONFIGURATION, (Object)true);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

