/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.symbols;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.psi.ModuleMapModuleDeclaration;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleDeclarationSymbol;
import java.util.HashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleMapSymbolBuilder {
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static ModuleMapFileSymbol build(@Nullable ModuleMapFile psiFile, @NotNull String path) {
        if (psiFile == null) {
            return null;
        }
        HashMap modules = ContainerUtil.newHashMap();
        for (ModuleMapModuleDeclaration declaration : psiFile.getModuleDeclarations()) {
            String moduleName = declaration.getModuleId().getText();
            ModuleMapModuleDeclarationSymbol module2 = new ModuleMapModuleDeclarationSymbol(moduleName, declaration.getUmbrellaHeader(), declaration.getUmbrellaDir(), declaration.getHeaders());
            modules.put(moduleName, module2);
        }
        return new ModuleMapFileSymbol(path, modules);
    }
}

