/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.modulemap.psi.ModuleMapBasicHeaderDeclaration;
import com.jetbrains.cidr.modulemap.psi.ModuleMapHeaderDeclaration;
import com.jetbrains.cidr.modulemap.psi.ModuleMapModuleDeclaration;
import com.jetbrains.cidr.modulemap.psi.ModuleMapModuleMembers;
import com.jetbrains.cidr.modulemap.psi.ModuleMapUmbrellaDirDeclaration;
import com.jetbrains.cidr.modulemap.psi.ModuleMapUmbrellaHeaderDeclaration;
import com.jetbrains.cidr.modulemap.psi.impl.ModuleMapPsiElementImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleMapModuleDeclarationImpl
extends ModuleMapPsiElementImpl
implements ModuleMapModuleDeclaration {
    public ModuleMapModuleDeclarationImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public String getUmbrellaHeader() {
        ModuleMapModuleMembers members = this.getModuleMembers();
        if (members != null) {
            for (ModuleMapHeaderDeclaration declaration : members.getHeaderDeclarationList()) {
                if (!(declaration instanceof ModuleMapUmbrellaHeaderDeclaration)) continue;
                return StringUtil.unquoteString((String)declaration.getHeaderName().getText());
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getUmbrellaDir() {
        Iterator<ModuleMapUmbrellaDirDeclaration> iterator;
        ModuleMapModuleMembers members = this.getModuleMembers();
        if (members != null && (iterator = members.getUmbrellaDirDeclarationList().iterator()).hasNext()) {
            ModuleMapUmbrellaDirDeclaration declaration = iterator.next();
            return StringUtil.unquoteString((String)declaration.getName());
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getHeaders() {
        ModuleMapModuleMembers members = this.getModuleMembers();
        if (members != null) {
            ArrayList result = ContainerUtil.newArrayList();
            for (ModuleMapHeaderDeclaration declaration : members.getHeaderDeclarationList()) {
                if (!(declaration instanceof ModuleMapBasicHeaderDeclaration)) continue;
                String header = StringUtil.unquoteString((String)declaration.getHeaderName().getText());
                result.add(header);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

