/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.modulemap.ModuleMapFileType;
import com.jetbrains.cidr.modulemap.ModuleMapLanguage;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.psi.ModuleMapModuleDeclaration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleMapFileImpl
extends PsiFileBase
implements ModuleMapFile {
    public ModuleMapFileImpl(@NotNull FileViewProvider viewProvider) {
        super(viewProvider, ModuleMapLanguage.INSTANCE);
    }

    public static ModuleMapFile createFromText(@NotNull CharSequence text, @NotNull PsiManager manager) {
        LightVirtualFile virtualFile = new LightVirtualFile("module.modulemap", (FileType)ModuleMapFileType.INSTANCE, text);
        ModuleMapFileViewProvider viewProvider = new ModuleMapFileViewProvider(manager, (VirtualFile)virtualFile, false);
        return (ModuleMapFile)viewProvider.getPsi(ModuleMapLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        return ModuleMapFileType.INSTANCE;
    }

    @Override
    @NotNull
    public List<ModuleMapModuleDeclaration> getModuleDeclarations() {
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, ModuleMapModuleDeclaration.class);
    }

    @Override
    @Nullable
    public ModuleMapModuleDeclaration findModule(final @NotNull String name) {
        return (ModuleMapModuleDeclaration)ContainerUtil.find(this.getModuleDeclarations(), (Condition)new Condition<ModuleMapModuleDeclaration>(){

            public boolean value(ModuleMapModuleDeclaration declaration) {
                return name.equals(declaration.getModuleId().getText());
            }
        });
    }

    private static class ModuleMapFileViewProvider
    extends SingleRootFileViewProvider {
        public ModuleMapFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
            super(manager, virtualFile, eventSystemEnabled, ModuleMapLanguage.INSTANCE, (FileType)ModuleMapFileType.INSTANCE);
        }
    }
}

