/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RealFramework
extends AppleFramework {
    @Nullable
    private final PsiFileSystemItem myParent;
    @NotNull
    private final VirtualFile myBaseFile;

    public RealFramework(@NotNull Project project2, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        super(project2, baseFile.getNameWithoutExtension());
        this.myParent = parentSdkOrFramework;
        this.myBaseFile = baseFile;
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParent() {
        return this.myManager.findDirectory(this.myBaseFile);
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParentSdkOrFrameworkItem() {
        return this.myParent;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myBaseFile;
    }

    @Override
    @Nullable
    public VirtualFile getMainFile() {
        return RealFramework.getFrameworkMainFile(this.myProject, this.myBaseFile);
    }

    @Override
    @NotNull
    public List<VirtualFile> getPublicHeadersToInclude() {
        return RealFramework.getFrameworkPublicHeadersToInclude(this.myProject, this.myBaseFile);
    }

    @Override
    public boolean containsHeader(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        for (String each : HEADERS_DIR_NAMES) {
            VirtualFile headers = this.myBaseFile.findChild(each);
            if (headers == null || !VfsUtilCore.isAncestor((VirtualFile)headers, (VirtualFile)file2, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        if (this.myBaseFile.isValid()) {
            if (processor2 instanceof HeadersSearchRootProcessor && !((HeadersSearchRootProcessor)processor2).processFramework(this.myBaseFile)) {
                return false;
            }
            for (String eachDir : HEADERS_DIR_NAMES) {
                if (this.processUnder(processor2, this.myBaseFile.findChild(eachDir))) continue;
                return false;
            }
            if (!RealFramework.processFrameworksUnder(this, this.myBaseFile.findChild("Frameworks"), processor2, (Set<String>)new THashSet())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealFramework framework = (RealFramework)((Object)o);
        if (!this.myBaseFile.equals(framework.myBaseFile)) {
            return false;
        }
        return !(this.myParent != null ? !this.myParent.equals(framework.myParent) : framework.myParent != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myParent != null ? this.myParent.hashCode() : 0);
        result = 31 * result + this.myBaseFile.hashCode();
        return result;
    }

    public String toString() {
        return "AppleFramework: [" + this.getName() + ": " + this.myBaseFile.getPath() + "]";
    }
}

