/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IncludedFilesProcessor {
    IncludedFilesProcessor() {
    }

    public static boolean processFile(@NotNull Project project2, @NotNull VirtualFile file2, @Nullable Condition<VirtualFile> condition, @NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
        ProgressManager.checkCanceled();
        if (IncludedFilesProcessor.shouldSkip(file2)) {
            return true;
        }
        if (condition != null && !condition.value((Object)file2)) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            return ((HeadersSearchRootProcessor)processor2).process(file2);
        }
        if (processor2 instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor2).acceptItem(file2.getName(), file2.isDirectory())) {
            return true;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Object element = null;
        if (file2.isValid()) {
            element = file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
        }
        return element == null || processor2.execute(element);
    }

    public static boolean shouldSkip(@NotNull VirtualFile file2) {
        return AppleFramework.FRAMEWORK_CONDITION.value((Object)file2);
    }

    public static boolean processFiles(final @NotNull Project project2, @NotNull Iterable<VirtualFile> files, final @Nullable Condition<VirtualFile> condition, boolean recursive, final @NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
        for (VirtualFile each : IncludedFilesProcessor.iterateFilesFirst(files)) {
            if (recursive && each.isDirectory()) {
                class CancelException
                extends RuntimeException {
                    CancelException() {
                    }
                }
                try {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)each, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                        @NotNull
                        public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                            if (IncludedFilesProcessor.shouldSkip(file2)) {
                                return SKIP_CHILDREN;
                            }
                            if (!IncludedFilesProcessor.processFile(project2, file2, (Condition<VirtualFile>)condition, (PsiElementProcessor<PsiFileSystemItem>)processor2)) {
                                throw new CancelException();
                            }
                            return CONTINUE;
                        }

                        @Nullable
                        public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                            return IncludedFilesProcessor.iterateFilesFirst(Arrays.asList(file2.getChildren()));
                        }
                    });
                    continue;
                }
                catch (CancelException ignore) {
                    return false;
                }
            }
            if (IncludedFilesProcessor.processFile(project2, each, condition, processor2)) continue;
            return false;
        }
        return true;
    }

    private static Iterable<VirtualFile> iterateFilesFirst(final @NotNull Iterable<VirtualFile> files) {
        return new Iterable<VirtualFile>(){

            @Override
            public Iterator<VirtualFile> iterator() {
                return new Iterator<VirtualFile>(){
                    Iterator<VirtualFile> iterator = null;
                    List<VirtualFile> dirs = null;
                    boolean processingDirs = false;
                    VirtualFile prefetched = null;

                    @Override
                    public boolean hasNext() {
                        this.prefetchNext();
                        return this.prefetched != null;
                    }

                    @Override
                    public VirtualFile next() {
                        if (this.prefetched == null) {
                            this.prefetchNext();
                        }
                        if (this.prefetched == null) {
                            throw new NoSuchElementException("No more items");
                        }
                        VirtualFile result = this.prefetched;
                        this.prefetched = null;
                        return result;
                    }

                    private void prefetchNext() {
                        if (this.prefetched != null) {
                            return;
                        }
                        if (this.iterator == null) {
                            this.iterator = files.iterator();
                        }
                        while (this.iterator.hasNext()) {
                            VirtualFile next = this.iterator.next();
                            boolean isDir = next.isDirectory();
                            if (isDir == this.processingDirs) {
                                this.prefetched = next;
                                return;
                            }
                            if (this.processingDirs) continue;
                            if (isDir && this.dirs == null) {
                                this.dirs = new ArrayList<VirtualFile>();
                            }
                            if (!isDir) continue;
                            this.dirs.add(next);
                        }
                        if (this.prefetched == null && !this.processingDirs && this.dirs != null) {
                            this.processingDirs = true;
                            this.iterator = this.dirs.iterator();
                            this.prefetchNext();
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

