/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class HeadersSearchPath {
    @NotNull
    private final File myFile;
    private final boolean isRecursive;
    private final boolean isUserHeaders;
    private final boolean isFrameworksSearchPath;

    public HeadersSearchPath(@NotNull File file2, boolean recursive, boolean userHeader) {
        this(file2, recursive, userHeader, false);
    }

    public HeadersSearchPath(@NotNull File file2, boolean recursive, boolean userHeader, boolean frameworksSearchPath) {
        this.myFile = file2;
        this.isRecursive = recursive;
        this.isUserHeaders = userHeader;
        this.isFrameworksSearchPath = frameworksSearchPath;
    }

    @NotNull
    public File getFile() {
        return this.myFile;
    }

    @NotNull
    public String getPath() {
        return this.myFile.getPath();
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public boolean isUserHeaders() {
        return this.isUserHeaders;
    }

    public boolean isFrameworksSearchPath() {
        return this.isFrameworksSearchPath;
    }

    public String toString() {
        return "HeadersSearchPath{" + this.myFile + ", " + (this.isUserHeaders ? "user" : "system") + ", " + (this.isRecursive ? "recursive" : "non-recursive") + (this.isFrameworksSearchPath ? ", frameworks" : "") + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadersSearchPath that = (HeadersSearchPath)o;
        if (this.isRecursive != that.isRecursive) {
            return false;
        }
        if (this.isUserHeaders != that.isUserHeaders) {
            return false;
        }
        if (this.isFrameworksSearchPath != that.isFrameworksSearchPath) {
            return false;
        }
        return FileUtil.filesEqual((File)this.myFile, (File)that.myFile);
    }

    public int hashCode() {
        int result = FileUtil.fileHashCode((File)this.myFile);
        result = 31 * result + (this.isRecursive ? 1 : 0);
        result = 31 * result + (this.isUserHeaders ? 1 : 0);
        result = 31 * result + (this.isFrameworksSearchPath ? 1 : 0);
        return result;
    }
}

