/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleDeclarationSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapSymbolBuilder;
import icons.CidrLangIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AppleFramework
extends HeadersSearchRoot {
    public static boolean SORTED_ITERATION = ApplicationManager.getApplication().isUnitTestMode();
    public static final String HEADERS_DIR_NAME = "Headers";
    public static final String MODULES_DIR_NAME = "Modules";
    public static final String PRIVATE_HEADERS_DIR_NAME = "PrivateHeaders";
    public static final String[] HEADERS_DIR_NAMES = new String[]{"Headers", "PrivateHeaders"};
    @NotNull
    private final String myName;
    static final Condition<VirtualFile> FRAMEWORK_CONDITION = new Condition<VirtualFile>(){

        public boolean value(VirtualFile file2) {
            return file2.isDirectory() && file2.getName().endsWith(".framework");
        }
    };
    private static final Comparator<VirtualFile> FILE_NAME_COMPARATOR = new Comparator<VirtualFile>(){

        @Override
        public int compare(VirtualFile f1, VirtualFile f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };

    protected AppleFramework(@NotNull Project project2, @NotNull String name) {
        super(project2);
        this.myName = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public abstract PsiFileSystemItem getParentSdkOrFrameworkItem();

    public boolean isLibrary() {
        return false;
    }

    @Nullable
    public abstract VirtualFile getMainFile();

    @Nullable
    public static VirtualFile getFrameworkMainFile(@NotNull Project project2, @Nullable VirtualFile frameworkPath) {
        if (frameworkPath == null) {
            return null;
        }
        String frameworkName = frameworkPath.getNameWithoutExtension();
        ModuleMapFileSymbol map = AppleFramework.findModuleMap(project2, frameworkPath);
        VirtualFile umbrellaFile = map != null ? AppleFramework.getUmbrellaFile(map.findModule(frameworkName), frameworkPath) : null;
        return umbrellaFile == null ? frameworkPath.findFileByRelativePath("Headers/" + frameworkName + ".h") : umbrellaFile;
    }

    @NotNull
    public abstract List<VirtualFile> getPublicHeadersToInclude();

    @NotNull
    public static List<VirtualFile> getFrameworkPublicHeadersToInclude(@NotNull Project project2, @Nullable VirtualFile frameworkPath) {
        List<VirtualFile> result;
        ModuleMapModuleDeclarationSymbol module2;
        if (frameworkPath == null) {
            return Collections.emptyList();
        }
        String frameworkName = frameworkPath.getNameWithoutExtension();
        ModuleMapFileSymbol moduleMap = AppleFramework.findModuleMap(project2, frameworkPath);
        if (moduleMap != null && (module2 = moduleMap.findModule(frameworkName)) != null && (result = AppleFramework.getPublicHeadersToInclude(module2, frameworkPath)) != null) {
            return result;
        }
        return ContainerUtil.createMaybeSingletonList((Object)AppleFramework.getFrameworkMainFile(project2, frameworkPath));
    }

    @Nullable
    private static List<VirtualFile> getPublicHeadersToInclude(@NotNull ModuleMapModuleDeclarationSymbol module2, final @NotNull VirtualFile frameworkPath) {
        ArrayList result = ContainerUtil.newArrayList();
        VirtualFile umbrellaFile = AppleFramework.getUmbrellaFile(module2, frameworkPath);
        if (umbrellaFile != null) {
            ContainerUtil.addAll((Collection)result, (Object[])new VirtualFile[]{umbrellaFile});
        } else {
            VirtualFile umbrellaDir;
            String umbrellaDirName = module2.getUmbrellaDir();
            if (umbrellaDirName != null && (umbrellaDir = frameworkPath.findFileByRelativePath(umbrellaDirName)) != null) {
                ContainerUtil.addAll((Collection)result, (Object[])umbrellaDir.getChildren());
            }
        }
        List<String> headers = module2.getHeaders();
        ContainerUtil.addAll((Collection)result, (Iterable)ContainerUtil.mapNotNull(headers, (Function)new Function<String, VirtualFile>(){

            public VirtualFile fun(String headerName) {
                return frameworkPath.findFileByRelativePath("Headers/" + headerName);
            }
        }));
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    @Nullable
    private static ModuleMapFileSymbol findModuleMap(@NotNull Project project2, @NotNull VirtualFile frameworkPath) {
        File modulesDir;
        File moduleMapFile = new File(frameworkPath.getPath(), "module.map");
        if (!moduleMapFile.exists() && (modulesDir = new File(frameworkPath.getPath(), MODULES_DIR_NAME)).exists() && modulesDir.isDirectory()) {
            moduleMapFile = new File(modulesDir, "module.modulemap");
        }
        if (moduleMapFile.exists()) {
            try {
                ModuleMapFile file2 = ModuleMapFileImpl.createFromText(FileUtil.loadFile((File)moduleMapFile), PsiManager.getInstance((Project)project2));
                return ModuleMapSymbolBuilder.build(file2, moduleMapFile.getAbsolutePath());
            }
            catch (IOException e) {
                OCLog.LOG.info("IOException reading module map at path " + moduleMapFile.getPath(), (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile getUmbrellaFile(@Nullable ModuleMapModuleDeclarationSymbol module2, @NotNull VirtualFile frameworkPath) {
        VirtualFile umbrellaFile;
        String umbrellaHeader;
        if (module2 != null && (umbrellaHeader = module2.getUmbrellaHeader()) != null && (umbrellaFile = frameworkPath.findFileByRelativePath("Headers/" + umbrellaHeader)) != null) {
            return umbrellaFile;
        }
        return null;
    }

    public abstract boolean containsHeader(@Nullable VirtualFile var1);

    public boolean process(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed2) {
        if (!processed2.add(this.getName())) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            return this.processChildren(processor2);
        }
        return AppleFramework.processFileSystemItem(processor2, this);
    }

    public static boolean processFrameworksUnder(@NotNull PsiFileSystemItem parentSdkOrFramework, @Nullable VirtualFile root, @NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed2) {
        if (root != null && root.isDirectory()) {
            List frameworks = ContainerUtil.filter((Object[])root.getChildren(), FRAMEWORK_CONDITION);
            if (SORTED_ITERATION) {
                Collections.sort(frameworks, FILE_NAME_COMPARATOR);
            }
            for (VirtualFile frameworkPath : frameworks) {
                RealFramework framework = new RealFramework(parentSdkOrFramework.getProject(), frameworkPath, parentSdkOrFramework);
                if (framework.process(processor2, processed2)) continue;
                return false;
            }
        }
        return true;
    }

    public Icon getIcon(int flags) {
        return CidrLangIcons.Framework;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AppleFramework framework = (AppleFramework)((Object)o);
        return this.myName.equals(framework.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }
}

