/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCompilerSettings {
    @Nullable
    public abstract OCCompilerKind getCompiler(@NotNull OCLanguageKind var1);

    @Nullable
    public abstract File getCompilerExecutable(@NotNull OCLanguageKind var1);

    @NotNull
    public abstract File getCompilerWorkingDir();

    @NotNull
    public abstract CidrToolEnvironment getEnvironment();

    @NotNull
    public abstract CidrCompilerSwitches getCompilerSwitches(@NotNull OCLanguageKind var1, @Nullable VirtualFile var2);

    @NotNull
    public String getCompilerKey(@NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile) {
        return (String)this.getCompilerKeyAndSwitches((OCLanguageKind)languageKind, (VirtualFile)sourceFile).first;
    }

    @NotNull
    public Pair<String, CidrCompilerSwitches> getCompilerKeyAndSwitches(@NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile) {
        CidrCompilerSwitches switches = this.getCompilerSwitches(languageKind, sourceFile);
        File compilerExec = this.getCompilerExecutable(languageKind);
        String key = (compilerExec == null ? "no compiler" : compilerExec.getPath()) + "-" + this.getCompilerWorkingDir() + "-" + languageKind.getDisplayName() + "-" + switches.getCommandLineString();
        return Pair.pair((Object)key, (Object)switches);
    }
}

