/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCCompilerProperty;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInitialInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompilerHelper {
    private static final Key<Map<OCCompilerProperty.PropertyKey, Object>> ENABLED_PROPERTIES = Key.create((String)"ENABLED_PROPERTIES");

    private OCCompilerHelper() {
    }

    @Contract(value="null,null,_->null")
    @Nullable
    public static <T> T getPropertyForFile(@Nullable PsiFile file2, @Nullable OCImmutableInclusionContext fileContext, @NotNull OCCompilerProperty.PropertyKey key) {
        T value;
        Project project2;
        if (file2 == null && fileContext == null) {
            return null;
        }
        if (fileContext != null && fileContext.getConfiguration() == null && file2 != null) {
            fileContext = null;
        }
        if (fileContext == null) {
            if (!(file2 instanceof OCFile)) {
                return null;
            }
            fileContext = OCInclusionContextUtil.headerContext(file2);
        }
        if ((project2 = fileContext.getProject()) != null && (value = OCCompilerHelper.getHint(project2, key)) != null) {
            return value;
        }
        return OCInitialInclusionContext.getPropertyFromInitialContext(key, fileContext);
    }

    @Deprecated
    @Nullable
    public static OCCompilerKind getCompiler(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        OCImmutableInclusionContext inclusionContext = OCInclusionContextUtil.headerContext(file2);
        OCResolveConfiguration configuration = inclusionContext.getConfiguration();
        return configuration != null ? configuration.getCompilerSettings().getCompiler(inclusionContext.getLanguageKind()) : null;
    }

    @Contract(value="null,_->false")
    public static boolean isFeatureEnabled(@Nullable PsiFile file2, @NotNull OCCompilerProperty.PropertyKey feature) {
        return OCCompilerHelper.getPropertyForFile(file2, null, feature) == Boolean.TRUE;
    }

    @Contract(value="null,_->false")
    public static boolean isFeatureEnabled(@Nullable OCImmutableInclusionContext context, @NotNull OCCompilerProperty.PropertyKey feature) {
        return OCCompilerHelper.getPropertyForFile(null, context, feature) == Boolean.TRUE;
    }

    @Contract(value="null,_->false")
    public static boolean isWarningEnabled(@Nullable PsiFile file2, @NotNull OCCompilerProperty.PropertyKey warning) {
        return OCCompilerHelper.getPropertyForFile(file2, null, warning) == Boolean.TRUE;
    }

    public static void enableARC(@NotNull Project project2, boolean value) {
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.OBJC_ARC, value);
    }

    public static boolean isArcDisabled(@NotNull PsiFile file2) {
        return OCCompilerHelper.getPropertyForFile(file2, null, OCCompilerProperty.PropertyKey.OBJC_ARC) == Boolean.FALSE;
    }

    public static boolean isArcEnabled(@NotNull PsiFile file2) {
        return OCCompilerHelper.getPropertyForFile(file2, null, OCCompilerProperty.PropertyKey.OBJC_ARC) == Boolean.TRUE;
    }

    public static boolean supportsIvarsInImplementation() {
        return true;
    }

    public static boolean supportsIvarsInCategories() {
        return true;
    }

    public static boolean supportsLaterMethodDeclaration() {
        return true;
    }

    public static boolean supportsAutosynthesis(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsAutosynthesis(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerHelper.isFeatureEnabled(context, OCCompilerProperty.PropertyKey.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsNullability(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.NULLABILITY);
    }

    public static boolean supportsNullability(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerHelper.isFeatureEnabled(context, OCCompilerProperty.PropertyKey.NULLABILITY);
    }

    public static boolean supportsMicrosoftAttributes(@Nullable PsiFile file2) {
        return OCCompilerHelper.getCompiler(file2) == OCCompilerKind.CLANG;
    }

    public static boolean supportsUnderlyingType(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.UNDERLYING_TYPE);
    }

    public static void enableUnderlyingType(@NotNull Project project2, boolean value) {
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.UNDERLYING_TYPE, value);
    }

    public static void enableAutosynthesis(@NotNull Project project2, boolean value) {
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES, value);
    }

    public static boolean supportsExplicitAtomic(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_PROPERTY_EXPLICIT_ATOMIC);
    }

    public static void enableExplicitAtomic(@NotNull Project project2, boolean value) {
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.OBJC_PROPERTY_EXPLICIT_ATOMIC, value);
    }

    public static boolean supportsInstancetype(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_INSTANCETYPE);
    }

    public static void enableInstancetype(@NotNull Project project2, boolean value) {
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.OBJC_INSTANCETYPE, value);
    }

    public static boolean supportsSubscripting(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_SUBSCRIPTING);
    }

    public static void enableSubscripting(@NotNull Project project2, boolean value) {
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.OBJC_SUBSCRIPTING, value);
    }

    public static boolean supportsObjectLiterals(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_ARRAY_LITERALS) && OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.OBJC_DICTIONARY_LITERALS);
    }

    public static void enableObjectLiterals(@NotNull Project project2, boolean value) {
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.OBJC_ARRAY_LITERALS, value);
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.OBJC_DICTIONARY_LITERALS, value);
    }

    public static boolean supportsCxxAutoType(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_AUTO_TYPE);
    }

    public static void enableCxxAutoType(@NotNull Project project2, boolean value) {
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.CXX_AUTO_TYPE, value);
    }

    public static boolean supportsOverrideControl(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_OVERRIDE_CONTROL);
    }

    public static boolean supportsInitializerLists(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_GENERALIZED_INITIALIZERS);
    }

    public static boolean supportsNullptr(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_NULLPTR);
    }

    public static boolean supportsInClassInitialization(@Nullable PsiFile file2) {
        return OCCompilerHelper.isFeatureEnabled(file2, OCCompilerProperty.PropertyKey.CXX_NONSTATIC_MEMBER_INIT);
    }

    public static boolean doesEmptyReturnFromNonVoidProduceError(@Nullable PsiFile file2) {
        return OCCompilerHelper.isWarningEnabled(file2, OCCompilerProperty.PropertyKey.ERROR_RETURN_TYPE);
    }

    public static void enableNullability(@NotNull Project project2, boolean value) {
        OCCompilerHelper.enableContextProperty(project2, OCCompilerProperty.PropertyKey.NULLABILITY, value);
    }

    @Nullable
    public static <T> T getHint(@NotNull Project project2, @NotNull OCCompilerProperty.PropertyKey feature) {
        Map features = (Map)ENABLED_PROPERTIES.get((UserDataHolder)project2);
        return features == null ? null : (T)features.get((Object)feature);
    }

    public static void enableContextProperty(@NotNull Project project2, OCCompilerProperty.PropertyKey feature, boolean value) {
        ConcurrentHashMap<OCCompilerProperty.PropertyKey, Boolean> enabledFeatures = (ConcurrentHashMap<OCCompilerProperty.PropertyKey, Boolean>)ENABLED_PROPERTIES.get((UserDataHolder)project2);
        if (enabledFeatures == null) {
            enabledFeatures = new ConcurrentHashMap<OCCompilerProperty.PropertyKey, Boolean>();
            project2.putUserData(ENABLED_PROPERTIES, enabledFeatures);
        }
        enabledFeatures.put(feature, value);
    }

    public static void resetStoredProperties(@NotNull Project project2) {
        project2.putUserData(ENABLED_PROPERTIES, null);
    }
}

