/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCCompilerFeatures {
    public static final String ATTRIBUTE_UNUSED = "unused";
    public static final String ATTRIBUTE_USED = "used";
    public static final String ATTRIBUTE_IBOUTLET = "iboutlet";
    public static final String ATTRIBUTE_IBOUTLET_COLLECTION = "iboutletcollection";
    public static final String ATTRIBUTE_IBACTION = "ibaction";
    public static final String ATTRIBUTE_RETURNS_RETAINED = "ns_returns_retained";
    public static final String ATTRIBUTE_OVERLOADABLE = "overloadable";
    public static final String ATTRIBUTE_DEPRECATED = "deprecated";
    public static final String ATTRIBUTE_UNAVAILABLE = "unavailable";
    public static final String ATTRIBUTE_TRANSPARENT_UNION = "transparent_union";
    private static final String[] KNOWN_ATTRIBUTES_FEATURES = new String[]{"attribute_analyzer_noreturn", "attribute_availability", "attribute_availability_with_message", "attribute_cf_consumed", "attribute_cf_returns_not_retained", "attribute_cf_returns_retained", "attribute_deprecated_with_message", "attribute_ext_vector_type", "attribute_ns_consumed", "attribute_ns_consumes_self", "attribute_ns_returns_not_retained", "attribute_ns_returns_retained", "attribute_objc_ivar_unused", "attribute_objc_method_family", "attribute_overloadable", "attribute_unavailable_with_message", "attribute_unused_on_fields", "enumerator_attributes"};
    public static final String[] TYPE_TRAITS_CLANG_ONLY = new String[]{"is_convertible_to", "is_literal", "is_sealed", "is_trivially_assignable", "is_trivially_constructible", "is_trivially_copyable"};
    public static final String[] TYPE_TRAITS_GCC_CLANG = new String[]{"has_nothrow_assign", "has_nothrow_constructor", "has_nothrow_copy", "has_trivial_assign", "has_trivial_constructor", "has_trivial_copy", "has_trivial_destructor", "has_virtual_destructor", "is_abstract", "is_base_of", "is_class", "is_empty", "is_enum", "is_final", "is_pod", "is_polymorphic", "is_standard_layout", "is_trivial", "is_union", "underlying_type"};
    public static final String[] TYPE_TRAITS_ALL = ArrayUtil.mergeArrays((String[])TYPE_TRAITS_GCC_CLANG, (String[])TYPE_TRAITS_CLANG_ONLY);
    public static final Map<String, String> FAKE_BUILT_INS = OCCompilerFeatures.fakeBuiltIns();
    private static final String[] KNOWN_CPP98_FEATURES = ArrayUtil.mergeArrays((String[])TYPE_TRAITS_GCC_CLANG, (String[])new String[]{"cxx_rtti", "cxx_exceptions"});
    private static final String[] KNOWN_CPP11_FEATURES = new String[]{"cxx_access_control_sfinae", "cxx_alias_templates", "cxx_alignas", "cxx_atomic", "cxx_attributes", "cxx_auto_type", "cxx_constexpr", "cxx_decltype", "cxx_decltype_incomplete_return_types", "cxx_default_function_template_args", "cxx_defaulted_functions", "cxx_delegating_constructors", "cxx_deleted_functions", "cxx_explicit_conversions", "cxx_generalized_initializers", "cxx_implicit_moves", "cxx_inheriting_constructors", "cxx_inline_namespaces", "cxx_lambdas", "cxx_local_type_template_args", "cxx_noexcept", "cxx_nonstatic_member_init", "cxx_nullptr", "cxx_override_control", "cxx_range_for", "cxx_raw_string_literals", "cxx_reference_qualified_functions", "cxx_rvalue_references", "cxx_static_assert", "cxx_strong_enums", "cxx_thread_local", "cxx_trailing_return", "cxx_unicode_literals", "cxx_unrestricted_unions", "cxx_user_literals", "cxx_variadic_templates"};
    private static final String[] KNOWN_CPP14_FEATURES = new String[]{"cxx_aggregate_nsdmi", "cxx_binary_literals", "cxx_contextual_conversions", "cxx_decltype_auto", "cxx_generic_lambda", "cxx_init_captures", "cxx_relaxed_constexpr", "cxx_return_type_deduction", "cxx_runtime_array", "cxx_variable_templates"};
    private static final String[] KNOWN_C11_FEATURES = new String[]{"c_alignas", "c_atomic", "c_generic_selections", "c_static_assert", "c_thread_local"};
    private static final String[] KNOWN_CLANG_ONLY_FEATURES = ArrayUtil.mergeArrays((String[])TYPE_TRAITS_CLANG_ONLY, (String[])new String[]{"address_sanitizer", "blocks", "c_thread_safety_attributes", "dataflow_sanitizer", "enumerator_attributes", "memory_sanitizer", "modules", "thread_sanitizer", "tls", "nullability"});
    private static final String[] KNOWN_OBJ_C_FEATURES = new String[]{"objc_arr", "objc_arc", "objc_arc_weak", "objc_default_synthesize_properties", "objc_fixed_enum", "objc_instancetype", "objc_modules", "objc_nonfragile_abi", "objc_property_explicit_atomic", "objc_protocol_qualifier_mangling", "objc_weak_class", "ownership_holds", "ownership_returns", "ownership_takes", "objc_bool", "objc_subscripting", "objc_array_literals", "objc_dictionary_literals", "objc_boxed_expressions", "arc_cf_code_audited", "objc_generics", "objc_generics_variance"};
    static final String[] KNOWN_CLANG_OBJC_ATTRIBUTES = new String[]{"objc_boxable", "objc_method_family", "objc_requires_super", "objc_runtime_name", "objc_arc_weak_reference_unavailable", "objc_bridge", "objc_designated_initializer", "objc_precise_lifetime", "objc_protocol_requires_explicit_implementation", "objc_requires_property_definitions", "objc_returns_inner_pointer", "objc_root_class"};
    static final String[] KNOWN_CLANG_APPLE_ATTRIBUTES = new String[]{"ibaction", "iboutlet", "iboutletcollection", "ns_consumed", "ns_consumed_self", "ns_returns_not_retained", "ns_returns_retained", "swift_error", "swift_name", "swift_private"};
    static final String[] KNOWN_CLANG_GPU_REGISTER_ATTRIBUTES = new String[]{"amdgpu_num_sgpr", "amdgpu_num_vgpr"};
    static final String[] KNOWN_CLANG_FUNCTION_ATTRIBUTES = new String[]{"interrupt", "acquire_capability", "acquire_shared_capability", "assume_aligned", "availability", "noreturn", "carries_dependency", "enable_if", "flatten", "format", "internal_linkage", "noduplicate", "no_sanitize", "no_sanitize_address", "no_address_safety_analysis", "no_sanitize_thread", "no_sanitize_memory", "no_split_stack", "optnone", "overloadable", "release_capability", "release_shared_capability", "target", "try_acquire_capability", "try_acquire_shared_capability"};
    static final String[] KNOWN_CLANG_VARIABLE_ATTRIBUTES = new String[]{"section", "tls_model"};
    static final String[] KNOWN_CLANG_TYPE_ATTRIBUTES = new String[]{"align_value", "flag_enum"};
    static final String[] KNOWN_CLANG_CALLING_CONVENTIONS_ATTRIBUTES = new String[]{"fastcall", "ms_abi", "pcs", "regparm", "stdcall", "thiscall", "vectorcall"};
    static final String[] KNOWN_CLANG_CONSUMED_ANNOTATION_CHECKING_ATTRIBUTES = new String[]{"callable_when", "consumable", "param_typestate", "return_typestate", "set_typestate", "test_typestate"};
    static final String[] KNOWN_CLANG_TYPE_SAFETY_CHECKING_ATTRIBUTES = new String[]{"argument_with_type_tag", "pointer_with_type_tag", "type_tag_for_datatype"};
    static final String[] KNOWN_CLANG_TYPE_NULLABILITY_ATTRIBUTES = new String[]{"nonnull", "returns_nonnull"};
    static final String[] KNOWN_GCC_COMMON_ATTRIBUTES = new String[]{"aligned", "deprecated", "unused", "used", "hot", "cold", "section", "weak", "packed"};
    static final String[] KNOWN_GCC_WINDOWS_ATTRIBUTES = new String[]{"dllexport", "dllimport", "selectany", "shared"};
    static final String[] KNOWN_GCC_X86_ATTRIBUTES = new String[]{"ms_struct", "gcc_struct", "cdecl", "fastcall", "thiscall", "ms_abi", "sysv_abi", "callee_pop_aggregate_return", "ms_hook_prologue", "regparm", "sseregparm", "force_align_arg_pointer", "stdcall", "target"};
    static final String[] KNOWN_GCC_FUNCTION_ATTRIBUTES = new String[]{"alias", "alloc_align", "alloc_size", "always_inline", "artificial", "assume_aligned", "bnd_instrument", "bnd_legacy", "const", "constructor", "destructor", "error", "warning", "externally_visible", "flatten", "format", "format_arg", "gnu_inline", "ifunc", "interrupt", "interrupt_handler", "leaf", "malloc", "no_icf", "no_instrument_function", "no_reorder", "no_sanitize_address", "no_address_safety_analysis", "no_sanitize_thread", "no_sanitize_undefined", "no_split_stack", "noclone", "noinline", "noreturn", "nothrow", "noplt", "optimize", "pure", "returns_nonnull", "returns_twice", "sentinel", "stack_protect", "target_clones", "target", "visibility", "warn_unused_result", "weakref", "lower", "upper", "either", "reentrant", "critical", "wakeup"};
    static final String[] KNOWN_GCC_VARIABLE_ATTRIBUTES = new String[]{"cleanup", "common", "nocommon", "mode", "tls_model", "vector_size"};
    static final String[] KNOWN_GCC_TYPE_ATTRIBUTES = new String[]{"aligned", "bnd_variable_size", "designated_init", "may_alias", "scalar_storage_order", "transparent_union", "visibility"};
    static final String[] KNOWN_OTHER_ATTRIBUTES = new String[]{"ext_vector_type", "type_visibility", "unavailable"};
    public static final Set<String> UNSUPPORTED_CLANG_FEATURES = OCCompilerFeatures.unsupportedClangFeatures();
    static final Set<String> ourAttributesSet;
    private static final Map<String, OCLanguageStandard> ourFeaturesMap;

    public static Set<String> unsupportedClangFeatures() {
        Set fs = ContainerUtil.set((Object[])new String[]{"cxx_access_control_sfinae", "cxx_constexpr", "cxx_user_literals"});
        Collections.addAll(fs, TYPE_TRAITS_ALL);
        for (String f : FAKE_BUILT_INS.keySet()) {
            fs.remove(f);
        }
        fs.remove("underlying_type");
        return Collections.unmodifiableSet(fs);
    }

    private static Map<String, String> fakeBuiltIns() {
        HashMap<String, String> fs = new HashMap<String, String>();
        fs.put("is_base_of", "#define __is_base_of(_Bp, _Dp) is_class<_Bp>::value && is_class<_Dp>::value && is_convertible<_Dp, _Bp>::value");
        return Collections.unmodifiableMap(fs);
    }

    private static void fillFeaturesMap(Map<String, OCLanguageStandard> map, String[] features, OCLanguageStandard standard) {
        for (String feature : features) {
            map.put(feature, standard);
        }
    }

    @NotNull
    public static OCLanguageStandard getFeatureStandard(String feature) {
        OCLanguageStandard standard = ourFeaturesMap.get(feature);
        return standard != null ? standard : OCLanguageStandard.UNKNOWN;
    }

    @NotNull
    public static Collection<String> getAllFeatures() {
        return ourFeaturesMap.keySet();
    }

    static void fillAttributesSet(Set<String> set, String[] attributes) {
        Collections.addAll(set, attributes);
    }

    @NotNull
    public static Collection<String> getAllAttributes() {
        return ourAttributesSet;
    }

    static {
        HashMap<String, OCLanguageStandard> map = new HashMap<String, OCLanguageStandard>();
        OCCompilerFeatures.fillFeaturesMap(map, KNOWN_C11_FEATURES, OCLanguageStandard.C11);
        OCCompilerFeatures.fillFeaturesMap(map, KNOWN_CPP98_FEATURES, OCLanguageStandard.CPP98);
        OCCompilerFeatures.fillFeaturesMap(map, KNOWN_CPP11_FEATURES, OCLanguageStandard.CPP11);
        OCCompilerFeatures.fillFeaturesMap(map, KNOWN_CPP14_FEATURES, OCLanguageStandard.CPP14);
        OCCompilerFeatures.fillFeaturesMap(map, KNOWN_CLANG_ONLY_FEATURES, OCLanguageStandard.UNKNOWN);
        OCCompilerFeatures.fillFeaturesMap(map, KNOWN_OBJ_C_FEATURES, OCLanguageStandard.UNKNOWN);
        OCCompilerFeatures.fillFeaturesMap(map, KNOWN_ATTRIBUTES_FEATURES, OCLanguageStandard.UNKNOWN);
        ourFeaturesMap = Collections.unmodifiableMap(map);
        HashSet set = ContainerUtil.newHashSet();
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_OBJC_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_APPLE_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_GPU_REGISTER_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_FUNCTION_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_VARIABLE_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_TYPE_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_CALLING_CONVENTIONS_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_CONSUMED_ANNOTATION_CHECKING_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_TYPE_SAFETY_CHECKING_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_CLANG_TYPE_NULLABILITY_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_GCC_COMMON_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_GCC_WINDOWS_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_GCC_X86_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_GCC_FUNCTION_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_GCC_VARIABLE_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_GCC_TYPE_ATTRIBUTES);
        OCCompilerFeatures.fillAttributesSet(set, KNOWN_OTHER_ATTRIBUTES);
        ourAttributesSet = Collections.unmodifiableSet(set);
    }
}

