/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWorkspaceUtil {
    @NotNull
    public static String getConfigurationDisplayName(@Nullable String targetName, @NotNull String configName, boolean shorten) {
        return targetName != null ? targetName + " [" + (shorten ? StringUtil.first((String)configName, (int)1, (boolean)false) : configName) + "]" : configName;
    }

    public static int compareConfigurations(@NotNull OCResolveConfiguration a, @NotNull OCResolveConfiguration b) {
        return a.getDisplayName(false).compareToIgnoreCase(b.getDisplayName(false));
    }

    @NotNull
    public static OCLanguageKind getMaximumLanguageKind(@NotNull Collection<OCLanguageKind> all, @NotNull Project project2) {
        CLanguageKind result = null;
        for (OCLanguageKind each : all) {
            if (result != null && (!(each instanceof CLanguageKind) || ((CLanguageKind)each).ordinal() <= result.ordinal())) continue;
            result = (CLanguageKind)each;
        }
        return result == null ? CLanguageKind.maxLanguage(project2) : result;
    }
}

