/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCMostlySingularMultiUniqueMap<K, V>
extends MostlySingularMultiMap<K, V> {
    private final TObjectHashingStrategy<? super V> myValueEqualityStrategy;
    protected final Set<V> myAllValues;

    public OCMostlySingularMultiUniqueMap() {
        this(TObjectHashingStrategy.CANONICAL);
    }

    public OCMostlySingularMultiUniqueMap(TObjectHashingStrategy<? super V> valueEqualityStrategy) {
        this.myValueEqualityStrategy = valueEqualityStrategy;
        this.myAllValues = this.createSet();
    }

    @NotNull
    protected Set<V> createSet() {
        return new THashSet(this.myValueEqualityStrategy);
    }

    public void add(@NotNull K key, @NotNull V value) {
        if (this.myAllValues.add(value)) {
            super.add(key, value);
        }
    }

    public boolean processAllValues(@NotNull Processor<? super V> p) {
        return ContainerUtil.process(this.myAllValues, p);
    }

    public boolean remove(@NotNull K key, @NotNull V value) {
        this.myAllValues.remove(value);
        return super.remove(key, value);
    }

    public boolean removeAllValues(@NotNull K key) {
        this.processForKey(key, new Processor<V>(){

            public boolean process(V v) {
                OCMostlySingularMultiUniqueMap.this.myAllValues.remove(v);
                return true;
            }
        });
        return super.removeAllValues(key);
    }

    public void compact() {
        ((THashMap)this.myAllValues).compact();
        super.compact();
    }

    public void clear() {
        this.myAllValues.clear();
        super.clear();
    }
}

