/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public class OCElementsRange
implements Comparable<OCElementsRange> {
    public static final TokenSet NON_IMPORTANT_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, OCElementTypes.DIRECTIVES, OCTokenTypes.DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LBRACE, OCTokenTypes.RBRACE, OCTokenTypes.ELSE_KEYWORD})});
    protected PsiElement myFirstElement;
    protected PsiElement myLastElement;
    protected boolean myContainsCompositeElement;

    public OCElementsRange(PsiElement firstElement, PsiElement lastElement) {
        this.myFirstElement = firstElement;
        this.myLastElement = lastElement;
    }

    public OCElementsRange(OCElementsRange range) {
        this.myFirstElement = range.myFirstElement;
        this.myLastElement = range.myLastElement;
        this.myContainsCompositeElement = range.myContainsCompositeElement;
    }

    public PsiElement getFirstElement() {
        return this.myFirstElement;
    }

    public void setFirstElement(PsiElement myFirstElement) {
        this.myFirstElement = myFirstElement;
    }

    public PsiElement getLastElement() {
        return this.myLastElement;
    }

    public void setLastElement(PsiElement myLastElement) {
        this.myLastElement = myLastElement;
    }

    public TextRange getTextRange() {
        int startOffset = OCElementUtil.getRangeWithMacros(this.myFirstElement).getStartOffset();
        int endOffset = OCElementUtil.getRangeWithMacros(this.myLastElement).getEndOffset();
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    public int getStartOffset() {
        TextRange range = this.myFirstElement instanceof OCMacroForeignLeafElement ? ((OCMacroForeignLeafElement)this.myFirstElement).getRealTextRange() : this.myFirstElement.getTextRange();
        return range.getStartOffset();
    }

    public int getEndOffset() {
        TextRange range = this.myLastElement instanceof OCMacroForeignLeafElement ? ((OCMacroForeignLeafElement)this.myLastElement).getRealTextRange() : this.myLastElement.getTextRange();
        return range.getEndOffset();
    }

    public String getText() {
        TextRange range = this.getTextRange();
        return this.myFirstElement.getContainingFile().getText().substring(range.getStartOffset(), range.getEndOffset());
    }

    public PsiFile getFile() {
        return this.myFirstElement.getContainingFile();
    }

    public boolean isValid() {
        return !(this.myFirstElement instanceof OCMacroForeignLeafElement) && !(this.myLastElement instanceof OCMacroForeignLeafElement);
    }

    public boolean containsCompositeElement() {
        return this.myContainsCompositeElement;
    }

    public void setContainsCompositeElement(boolean containsCompositeElement) {
        this.myContainsCompositeElement = containsCompositeElement;
    }

    public void merge(OCElementsRange range) {
        if (this.getEndOffset() < range.getEndOffset()) {
            this.myLastElement = range.myLastElement;
        }
        this.myContainsCompositeElement |= range.myContainsCompositeElement;
    }

    @Nullable
    public OCElementsRange trim(TokenSet elementsToRemove) {
        PsiElement firstChild = PsiTreeUtil.firstChild((PsiElement)this.myFirstElement);
        PsiElement lastChild = PsiTreeUtil.lastChild((PsiElement)this.myLastElement);
        boolean wasTrimmed = false;
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)firstChild, (PsiElement)lastChild);
        while (firstChild != lastChild && firstChild != null && OCElementsRange.isTrimmedElement(elementsToRemove, firstChild, commonParent)) {
            firstChild = PsiTreeUtil.nextLeaf((PsiElement)firstChild);
            wasTrimmed = true;
        }
        while (firstChild != lastChild && lastChild != null && OCElementsRange.isTrimmedElement(elementsToRemove, lastChild, commonParent)) {
            lastChild = PsiTreeUtil.prevLeaf((PsiElement)lastChild);
            wasTrimmed = true;
        }
        if (firstChild == lastChild && OCElementsRange.isTrimmedElement(elementsToRemove, firstChild, commonParent)) {
            return null;
        }
        if (wasTrimmed) {
            return new OCElementsRange(firstChild, lastChild);
        }
        return this;
    }

    public static List<OCElementsRange> mergeRanges(List<OCElementsRange> ranges) {
        OCElementsRange trimmed;
        Collections.sort(ranges);
        ArrayList<OCElementsRange> resultRanges = new ArrayList<OCElementsRange>();
        OCElementsRange curRange = null;
        TokenSet trimSet = NON_IMPORTANT_TOKENS;
        for (OCElementsRange range : ranges) {
            OCElementsRange trimmed2;
            if (range == null) continue;
            if (curRange != null && curRange.getEndOffset() + 1 >= range.getStartOffset()) {
                curRange.merge(range);
                continue;
            }
            if (curRange != null && curRange.isValid() && curRange.containsCompositeElement() && (trimmed2 = curRange.trim(trimSet)) != null) {
                resultRanges.add(trimmed2);
            }
            curRange = new OCElementsRange(range);
        }
        if (curRange != null && curRange.isValid() && curRange.containsCompositeElement() && (trimmed = curRange.trim(trimSet)) != null) {
            resultRanges.add(trimmed);
        }
        return resultRanges;
    }

    private static boolean isTrimmedElement(TokenSet elementsToRemove, PsiElement element, PsiElement commonParent) {
        while (element != commonParent) {
            if (elementsToRemove.contains(OCElementUtil.getElementType(element))) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    public boolean isEmpty() {
        PsiElement curElement = this.myFirstElement;
        while (curElement != null && curElement.getTextRange().getStartOffset() < this.myLastElement.getTextRange().getEndOffset()) {
            IElementType elementType = OCElementUtil.getElementType(curElement);
            if (elementType != OCTokenTypes.LBRACE && elementType != OCTokenTypes.RBRACE && !OCElementUtil.isElementEmpty(curElement)) {
                return false;
            }
            curElement = PsiTreeUtil.nextLeaf((PsiElement)curElement, (boolean)true);
        }
        return true;
    }

    @Override
    public int compareTo(OCElementsRange o) {
        return this.getStartOffset() - o.getStartOffset();
    }

    public Iterable<PsiElement> getElements() {
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new Iterator<PsiElement>(){
                    PsiElement nextElem;
                    {
                        this.nextElem = OCElementsRange.this.myFirstElement;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextElem != null;
                    }

                    @Override
                    public PsiElement next() {
                        ASTNode next;
                        PsiElement curElem = this.nextElem;
                        if (this.nextElem == null) {
                            throw new NoSuchElementException();
                        }
                        this.nextElem = this.nextElem != OCElementsRange.this.myLastElement ? ((next = this.nextElem.getNode().getTreeNext()) != null ? next.getPsi() : null) : null;
                        return curElem;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }
}

