/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.util.OCElementFactory");

    private OCElementFactory() {
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        return OCElementFactory.declarationStatement(null, name, type, initializer, context);
    }

    @NotNull
    public static OCDeclaration declaration(String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        return OCElementFactory.declarationStatement(null, name, type, initializer, context).getDeclaration();
    }

    @NotNull
    public static OCDeclaration declaration(@Nullable String modifier, String name, OCType type, PsiElement context) {
        return OCElementFactory.declarationStatement(modifier, name, type, null, context).getDeclaration();
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@Nullable String modifier, String name, OCType type, @Nullable OCExpression initializer, PsiElement context) {
        String declText = OCElementFactory.declarationText(modifier != null ? Collections.singletonList(modifier) : Collections.emptyList(), name, type, initializer != null ? "0" : null, context, null, false);
        OCDeclarationStatement statement2 = (OCDeclarationStatement)OCElementFactory.statementFromText(declText, context, true);
        if (initializer != null) {
            OCChangeUtil.replaceHandlingMacros(statement2.getDeclaration().getDeclarators().get(0).getInitializer(), initializer);
        }
        return statement2;
    }

    @NotNull
    public static OCDeclaration declarationFromText(String text, PsiElement context) {
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context);
    }

    @NotNull
    public static OCDeclaration declarationFromText(String text, PsiElement context, boolean reformat) {
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context, reformat);
    }

    @NotNull
    public static String declarationText(String name, OCType type, @NotNull PsiElement context) {
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context, null, false);
    }

    @NotNull
    public static String declarationText(String name, OCType type, String typeNameHint, @NotNull PsiElement context) {
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context, typeNameHint, false);
    }

    @NotNull
    public static OCDeclaration declarationByNameAndType(String name, OCType type, PsiElement context) {
        return OCElementFactory.declarationStatement(name, type, null, context).getDeclaration();
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationFromText(String text, @NotNull PsiElement context) {
        return ((OCFunctionDefinition)OCElementFactory.topLevelDeclarationFromText("void f(" + text + "){}", context)).getParameterList().getParameterDeclarations().get(0);
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationByNameAndType(String name, OCType type, PsiElement context) {
        return OCElementFactory.paramDeclarationFromText(OCElementFactory.declarationText(name, type, context), context);
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context) {
        return OCElementFactory.propertyDeclaration(name, type, context, null, false);
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly) {
        return OCElementFactory.propertyDeclaration(name, type, context, semantics, readonly, null);
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly, @Nullable String additionalAttributes) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        return OCElementFactory.propertyDeclaration(name, type, context, semantics, settings == null || settings.PROPERTY_NONATOMIC, readonly, additionalAttributes);
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean nonatomic, boolean readonly, @Nullable String additionalAttributes) {
        ArrayList<String> attributes = new ArrayList<String>();
        if (nonatomic) {
            attributes.add("nonatomic");
        }
        if (readonly) {
            attributes.add("readonly");
        }
        if (semantics == null && type.isPointerToObjectCompatible()) {
            semantics = OCPropertySymbolImpl.getDefaultSemanticsForType(type, context);
        }
        if (semantics == OCPropertySymbol.PropertySemantics.ASSIGN) {
            attributes.add("assign");
        } else if (semantics == OCPropertySymbol.PropertySemantics.WEAK) {
            attributes.add("weak");
        } else if (type.isPointerToObjectCompatible() && !readonly) {
            if (semantics == OCPropertySymbol.PropertySemantics.STRONG) {
                attributes.add("strong");
            } else if (semantics == OCPropertySymbol.PropertySemantics.RETAIN) {
                attributes.add("retain");
            } else if (semantics == OCPropertySymbol.PropertySemantics.COPY) {
                attributes.add("copy");
            }
        }
        StringBuilder attributesText = new StringBuilder();
        if (!attributes.isEmpty()) {
            attributesText.append('(');
            attributesText.append(StringUtil.join(attributes, (String)","));
            attributesText.append(')');
        }
        if (!StringUtil.isEmpty((String)additionalAttributes)) {
            if (attributesText.length() > 0) {
                attributesText.append(' ');
            }
            attributesText.append(additionalAttributes);
            attributesText.append(' ');
        }
        String text = "@interface c @property " + attributesText + OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context, null, true) + "; @end";
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0);
    }

    @NotNull
    public static OCDeclaration enumConst(String name, PsiElement context) {
        return ((OCEnum)OCElementFactory.typeElementFromText("enum { " + name + "}", context).getFirstChild()).getFields().get(0);
    }

    @NotNull
    public static OCExpression booleanConstant(boolean value, PsiElement context) {
        String constant = OCIntType.getAppropriateBool((OCElement)context.getContainingFile()).getValue(value);
        return OCElementFactory.expressionFromText(constant, context, false);
    }

    @NotNull
    public static OCSendMessageExpression sendMessageExpression(List<String> paramStubs, PsiElement context) {
        StringBuilder text = new StringBuilder("[ 0 ");
        for (String paramStub : paramStubs) {
            text.append(paramStub).append(' ');
        }
        text.append("]");
        return (OCSendMessageExpression)OCElementFactory.expressionFromText(text.toString(), context);
    }

    @NotNull
    public static OCCallExpression callExpression(@Nullable String functionName, List<String> paramStubs, PsiElement context) {
        if (functionName == null || functionName.isEmpty()) {
            functionName = "__empty";
        }
        StringBuilder text = new StringBuilder(functionName);
        text.append('(');
        boolean isFirst = true;
        for (String paramStub : paramStubs) {
            if (!isFirst) {
                text.append(',');
            }
            text.append(paramStub);
            isFirst = false;
        }
        text.append(')');
        return (OCCallExpression)OCElementFactory.expressionFromText(text.toString(), context);
    }

    @NotNull
    public static OCInterface interfaceByName(String name, PsiElement context) {
        return (OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface " + name + " @end", context, true);
    }

    @NotNull
    public static OCMethod methodFromText(String text, PsiElement context, boolean reformat) {
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface i " + text + " @end", context, reformat)).getMethods().get(0);
    }

    @NotNull
    public static OCDefineDirective macroDeclarationFromText(String name, String defaultValue, PsiFile file2) {
        return (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText("#define " + name + " " + defaultValue, (PsiElement)file2);
    }

    @NotNull
    public static OCMethod methodFromSignature(@NotNull String signature, @NotNull PsiElement context, boolean needBody, boolean reformat) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        String semicolon = settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE ? ";" : "";
        return OCElementFactory.methodFromText(signature + (needBody ? semicolon + "{\n}" : ";"), context, reformat);
    }

    @NotNull
    public static OCUnaryExpression unaryExpression(PsiElement operand, OCElementType operator) {
        OCUnaryExpression expression = (OCUnaryExpression)OCElementFactory.expressionFromText(operator.getName() + " a", operand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getOperand(), operand);
        return expression;
    }

    @NotNull
    public static OCBinaryExpression binaryExpression(PsiElement leftOperand, PsiElement rightOperand, OCElementType operator) {
        OCBinaryExpression expression = (OCBinaryExpression)OCElementFactory.expressionFromText("a " + operator.getName() + " b", leftOperand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getLeft(), leftOperand);
        OCChangeUtil.replaceHandlingMacros(expression.getRight(), rightOperand);
        return expression;
    }

    @NotNull
    public static PsiElement binaryOperatorFromText(String operator, PsiElement context) {
        return ((OCBinaryExpression)OCElementFactory.expressionFromText("a" + operator + "b", context)).getOperationSignNode().getPsi();
    }

    @NotNull
    public static ASTNode typeModifierFromText(String modifier, PsiElement context) {
        return OCElementFactory.typeElementFromText(modifier + " int", context).getNode().getFirstChildNode();
    }

    @NotNull
    public static PsiElement ivarScopeSpecifier(OCVisibility scope, PsiElement context) {
        OCInstanceVariablesList clazz = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c { @" + (Object)((Object)scope) + "} #end", context)).getInstanceVariablesList();
        for (PsiElement kid = clazz.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (OCVisibility.getVisibilityFromElement(kid) != scope) continue;
            return kid;
        }
        return null;
    }

    @NotNull
    public static OCInstanceVariablesList instanceVariableList(PsiElement context) {
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c {} @end", context)).getInstanceVariablesList();
    }

    @NotNull
    public static OCDeclaration constructorFromText(String text, PsiElement context) {
        return OCElementFactory.constructorFromText(text, context, false);
    }

    @NotNull
    public static OCDeclaration constructorFromText(String text, PsiElement context, boolean reformat) {
        String name = text.substring(0, text.indexOf(40));
        OCTypeElement type = OCElementFactory.typeElementFromTextOrNull("struct " + name + " { " + text + ";}", context, reformat);
        OCStruct struct = (OCStruct)type.getFirstChild();
        return (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)struct, OCFunctionDeclaration.class);
    }

    @NotNull
    public static OCConstructorInitializationList constructorInitializationList(OCElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : y(1) {}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCChangeUtil.delete(list.getInitializers().get(0));
        return list;
    }

    @NotNull
    public static OCConstructorFieldInitializer constructorFieldInitializerFromText(String text, PsiElement context) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : " + text + "{}", context);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        return list.getInitializers().get(0);
    }

    @NotNull
    public static OCPropertyAttributesList propertyAttributeList(OCPropertySymbol.PropertyAttribute attribute, @Nullable String value, PsiElement context) {
        String text = "@interface c @property (" + attribute.getTokenName() + (value != null ? "=" + value : "") + ") int x; @end";
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context, true)).getProperties().get(0).getPropertyAttributesList();
    }

    @NotNull
    public static OCSynthesizePropertiesList synthesizeList(String myKeyword, String property, @Nullable String ivar, PsiElement context) {
        String text = "@implementation i " + myKeyword + " " + property + (ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        return (OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class);
    }

    @NotNull
    public static OCSynthesizeProperty synthesize(String property, @Nullable String ivar, PsiElement context) {
        String text = "@implementation i @synthesize " + property + (ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node = OCElementFactory.topLevelDeclarationFromText(text, context, true).getNode();
        return ((OCSynthesizePropertiesList)node.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class)).getProperties().get(0);
    }

    @NotNull
    private static String declaratorText(String name, OCType type, PsiElement context, boolean eraseARCAttributes) {
        if (type.getAliasName() == null) {
            if (type instanceof OCArrayType) {
                OCArrayType arrayType = (OCArrayType)type;
                int length = arrayType.getLength();
                if (name.startsWith("*")) {
                    name = "(" + name + ")";
                }
                return OCElementFactory.declaratorText(name + " [" + (arrayType.hasLength() ? Integer.valueOf(length) : "") + "]", arrayType.getRefType(), context, eraseARCAttributes);
            }
            if (type instanceof OCPointerType) {
                OCPointerType pointerType = (OCPointerType)type;
                if (!(pointerType.getRefType() instanceof OCIdType)) {
                    name = (type instanceof OCBlockPointerType ? "^" : "*") + (pointerType.isConst() ? " const " : "") + (pointerType.isVolatile() ? " volatile " : "") + name;
                }
                return (!eraseARCAttributes && pointerType.getARCAttribute() != null ? pointerType.getARCAttribute().getTokenName() + " " : "") + OCElementFactory.declaratorText(name, pointerType.getRefType(), context, eraseARCAttributes);
            }
            if (type instanceof OCFunctionType) {
                OCFunctionType funType = (OCFunctionType)type;
                StringBuilder b = new StringBuilder();
                b.append(funType.getReturnType().getBestNameInContext(context));
                b.append(" (").append(name).append(")");
                b.append(OCTypeNameVisitor.getFunctionSignature(context, funType, "", false, null));
                return b.toString();
            }
        }
        return type.getBestNameInContext(context) + " " + name;
    }

    @NotNull
    public static String declarationText(@NotNull List<String> modifiers, String name, OCType type, @Nullable String initializerText, @NotNull PsiElement context, @Nullable String typeNameHint, boolean eraseARCAttributes) {
        if (type instanceof OCFunctionType && type.getAliasName() == null) {
            type = OCPointerType.to(type);
        }
        if (type == null) {
            return "";
        }
        boolean isUnnamed = "<unnamed>".equals(name);
        StringBuilder b = new StringBuilder();
        for (String modifier : modifiers) {
            b.append(modifier).append(' ');
        }
        if (type instanceof OCPointerType && type.getAliasName() == null) {
            b.append(OCElementFactory.declaratorText(name, type, context, eraseARCAttributes));
        } else {
            if (type instanceof OCUnknownType) {
                PsiFile file2 = context.getContainingFile();
                if (file2 instanceof OCFile) {
                    b.append(((OCFile)file2).getKind().isObjC() ? "id" : "int");
                } else {
                    b.append("id");
                }
            } else {
                b.append(type.getBestNameInContext(context));
            }
            if (!isUnnamed) {
                b.append(' ').append(name);
            }
        }
        String declarationText = b.toString();
        if (typeNameHint != null && OCCodeInsightUtil.isSimpleDeclaration(b.toString(), name) && modifiers.isEmpty() && type.equalsAfterResolving(typeNameHint, new OCResolveContext(context))) {
            declarationText = isUnnamed ? typeNameHint : typeNameHint + " " + name;
        }
        if (initializerText != null) {
            return declarationText + '=' + initializerText;
        }
        return declarationText;
    }

    @NotNull
    public static PsiElement createIdentifier(@NotNull String name, @NotNull PsiElement context) {
        OCCodeFragment fragment = OCElementFactory.codeFragment("int " + name, context.getProject(), context, false, false);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)fragment, OCElement.class);
        List<OCDeclarator> declarators = declaration != null ? declaration.getDeclarators() : null;
        LOG.assertTrue(declarators != null && !declarators.isEmpty(), (Object)("Bad identifier name " + name));
        return declarators.get(0).getNameIdentifier();
    }

    @NotNull
    public static OCMacroForeignLeafElement createMacroForeignIdentifier(@NotNull String name, @NotNull OCMacroForeignLeafElement sample) {
        OCCodeFragment fragment = OCElementFactory.codeFragment("#define M(x) x\nint M(" + name + ")", sample.getProject(), null, false, false);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)fragment, OCDeclaration.class);
        List<OCDeclarator> declarators = declaration != null ? declaration.getDeclarators() : null;
        LOG.assertTrue(declarators != null && !declarators.isEmpty(), (Object)("Bad identifier name " + name));
        OCMacroForeignLeafElement identifier = (OCMacroForeignLeafElement)declarators.get(0).getNameIdentifier();
        identifier.copyFromElement(sample);
        return identifier;
    }

    @NotNull
    public static OCCppNamespaceQualifier createNamespaceQualifier(String name, PsiElement context) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct " + name + "::XXXX {}", context, true).getTypeElement().getFirstChild();
        return struct.getNamespaceQualifier();
    }

    @NotNull
    public static ASTNode createColon2x(PsiElement context) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct A::B{}", context).getTypeElement().getFirstChild();
        return struct.getNode().findChildByType((IElementType)OCTokenTypes.COLON2X);
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.topLevelDeclarationFromText(text, context, false);
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NotNull String text, @NotNull PsiElement context, boolean reformat) {
        OCCodeFragment element = OCElementFactory.codeFragment(text, context.getProject(), context, false, reformat);
        PsiElement child = element.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof OCMacroCall) {
            child = child.getNextSibling();
        }
        return child;
    }

    @NotNull
    public static OCTypeElement typeElementFromText(@NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.typeElementFromTextOrNull(text, context, true);
    }

    @Nullable
    public static OCTypeElement typeElementFromTextOrNull(@NotNull String text, @NotNull PsiElement context, boolean formatToCodestyle) {
        return (OCTypeElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.typeCodeFragment(text, context.getProject(), context, false, formatToCodestyle), OCTypeElement.class);
    }

    @Nullable
    public static OCReferenceElement referenceElementFromText(@NotNull String name, @NotNull PsiElement context, boolean formatToCodestyle) {
        return (OCReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionFromText(name, context, formatToCodestyle), OCReferenceElement.class);
    }

    @Nullable
    public static OCExpression expressionFromText(@NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.expressionFromText(text, context, true);
    }

    @Nullable
    public static OCExpression expressionFromText(@NotNull String text, @NotNull PsiElement context, boolean reformat) {
        return (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(text, context.getProject(), context, false, reformat), OCExpression.class);
    }

    public static OCStatement statementFromText(@NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.statementFromText(text, context, false);
    }

    public static OCStatement statementFromText(@NotNull String text, @NotNull PsiElement context, boolean reformat) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        text = builder.append("void _______dummy(){").append(text).append(";}").toString();
        StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        OCCodeFragment element = OCElementFactory.codeFragment(text, context.getProject(), context, false, reformat);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCFunctionDefinition.class);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCBlockStatement.class);
        return (OCStatement)PsiTreeUtil.getChildOfType((PsiElement)element, OCStatement.class);
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean reformat) {
        return OCElementFactory.codeFragment(text, project2, context, OCTokenTypes.OC_FILE, physical, reformat);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle, OCLanguageKind kind) {
        return OCElementFactory.codeFragment(text, project2, context, (IFileElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, kind);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragmentCpp(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context, (IFileElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, true, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment expressionOrStatementsCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context, OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NotNull String text, @NotNull PsiElement context) {
        return OCElementFactory.typeCodeFragment(text, context.getProject(), context, true, false);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context, OCElementTypes.TYPE_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    public static OCCodeFragment getTypeCodeFragmentInWriteAction(final String text, final @NotNull Project project2, final @Nullable PsiElement context) {
        return (OCCodeFragment)new WriteCommandAction<OCCodeFragment>(project2, new PsiFile[0]){

            protected void run(@NotNull Result<OCCodeFragment> result) throws Throwable {
                result.setResult((Object)OCElementFactory.typeCodeFragment(text, project2, context, true, true));
            }
        }.execute().getResultObject();
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle) {
        PsiFile file2;
        boolean isCpp = false;
        if (context != null && (file2 = context.getContainingFile()) instanceof OCFile) {
            isCpp = ((OCFile)file2).isCpp();
        }
        return OCElementFactory.codeFragment(text, project2, context, type, physical, isCpp, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean isCpp, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context, type, physical, formatToCodestyle, isCpp ? OCLanguageKind.OBJ_CPP : OCLanguageKind.OBJ_C);
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, final @NotNull Project project2, @Nullable PsiElement context, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle, @NotNull OCLanguageKind kind) {
        text = text.trim();
        final OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(project2, kind, text, physical, (IElementType)type);
        if (context != null && context.isValid()) {
            fragment.setContext(context);
        }
        Application app = ApplicationManager.getApplication();
        if (formatToCodestyle) {
            if (app.isWriteAccessAllowed()) {
                PostprocessReformattingAspect.getInstance(project2).disablePostprocessFormattingInside(new Runnable(){

                    @Override
                    public void run() {
                        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)fragment);
                    }
                });
            } else {
                LOG.error("Write access is required");
            }
        }
        return fragment;
    }

    @NotNull
    public static PsiElement create(@NotNull OCElementType type, @NotNull PsiElement context) {
        OCCodeFragment fragment = OCElementFactory.codeFragment(type.getName(), context.getProject(), context, true, false);
        return PsiTreeUtil.findChildOfType((PsiElement)fragment, LeafPsiElement.class);
    }

    @NotNull
    public static PsiElement spaceFromText(@NotNull PsiElement context) {
        return OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("a b", context)).get(1);
    }

    @NotNull
    public static PsiElement newlineFromText(@NotNull PsiElement context) {
        return OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("a\nb", context)).get(1);
    }

    public static void initIndentFromContext(@NotNull PsiElement oldElement, @NotNull PsiElement newElement) {
        PsiFile context = oldElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)newElement.getNode(), IndentHelper.getInstance().getIndent(context.getProject(), context.getFileType(), oldElement.getNode()));
    }
}

