/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDocUtil {
    private static EnumSet<OCSymbolAttribute> POST_FUNC_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.FINAL, OCSymbolAttribute.OVERRIDE, OCSymbolAttribute.DELETE, OCSymbolAttribute.DEFAULT);
    private static EnumSet<OCSymbolAttribute> SKIP_DECL_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.CONSTEEXPR);
    private static final Function<OCSymbolWithQualifiedName, String> TO_NAME = new Function<OCSymbolWithQualifiedName, String>(){

        public String fun(OCSymbolWithQualifiedName symbol) {
            return StringUtil.escapeXml((String)symbol.getPresentableName());
        }
    };

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param) {
        return OCDocUtil.parameterSignature(type, param, null);
    }

    @NotNull
    public static String parameterSignature(@NotNull String type, @Nullable String param, @Nullable String defValue) {
        StringBuilder sb = new StringBuilder();
        boolean hasName = param != null && !"<unnamed>".equals(param);
        sb.append(type);
        if (hasName) {
            sb.append(OCDocUtil.delimiter(type));
        }
        sb.append(hasName ? param : "");
        if (defValue != null) {
            sb.append(" = ").append(defValue);
        }
        return sb.toString();
    }

    public static String delimiter(String type) {
        return OCDocUtil.delimiter(type, " ");
    }

    public static String delimiter(String type, String del) {
        if (!(type.endsWith("*") || type.endsWith("&") || type.endsWith("&amp;"))) {
            return del;
        }
        return "";
    }

    public static void extractModifiers(@NotNull OCDeclaratorSymbol symbol, @NotNull StringBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr) || SKIP_DECL_ATTRIBUTES.contains((Object)attr)) continue;
            sb.append((Object)attr).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCFunctionSymbol symbol, @NotNull StringBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (POST_FUNC_ATTRIBUTES.contains((Object)attr) || !symbol.hasAttribute(attr)) continue;
            sb.append((Object)attr).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCStructSymbol symbol, @NotNull StringBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr)) continue;
            sb.append((Object)attr).append(" ");
        }
        if (symbol.isTemplateSymbol()) {
            sb.append(OCTokenTypes.TEMPLATE_CPP_KEYWORD.getName()).append(" ");
        }
    }

    public static void extractFuncPostModifiers(@NotNull OCFunctionSymbol symbol, @NotNull StringBuilder sb) {
        if (symbol.isConst()) {
            sb.append(" ").append(OCTokenTypes.CONST_KEYWORD.getName());
        }
        for (OCSymbolAttribute attr : POST_FUNC_ATTRIBUTES) {
            if (!symbol.hasAttribute(attr)) continue;
            if (attr == OCSymbolAttribute.DELETE || attr == OCSymbolAttribute.DEFAULT) {
                sb.append(" =");
            }
            sb.append(" ").append((Object)attr);
        }
    }

    @NotNull
    public static String getParametersSignature(OCFunctionSymbol symbol, boolean useSubstitution) {
        StringBuilder answer = new StringBuilder("(");
        List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCSymbolKind.NAMESPACE);
        OCFile containingFile = symbol.getContainingOCFile();
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : symbol.getParameterSymbols()) {
            String typeText;
            if (!isFirst) {
                answer.append(", ");
            }
            if (useSubstitution) {
                OCType type = param.getType().accept(new OCTypeParameterResolveVisitor(param.getContainingOCFile()));
                typeText = OCDocUtil.getCanonicalName(type, contextNamespace, containingFile);
            } else {
                typeText = param.getType().getCanonicalName();
            }
            answer.append(OCDocUtil.parameterSignature(typeText, param.getName()));
            if (param.hasInitializer()) {
                answer.append(" = ").append(param.getInitializer().getSignature());
            }
            isFirst = false;
        }
        return answer.append(')').toString();
    }

    @NotNull
    public static String getCanonicalName(@NotNull OCType type, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile) {
        OCType terminalType = type.getTerminalType();
        OCType resolvedType = terminalType.resolve(containingFile);
        if (resolvedType instanceof OCStructType) {
            CVQualifiers qualifiers;
            OCStructSymbol struct = ((OCStructType)resolvedType).getSymbol();
            List<OCSymbolWithQualifiedName> symbols = OCDocUtil.getQualifiedSymbolChain(struct, OCSymbolKind.NAMESPACE, OCSymbolKind.STRUCT, OCSymbolKind.ENUM, OCSymbolKind.UNION);
            for (OCSymbolWithQualifiedName ns : contextNamespace) {
                OCSymbolWithQualifiedName element;
                if (symbols.isEmpty() || !(element = symbols.get(0)).equals(ns)) continue;
                symbols.remove(0);
            }
            StringBuilder res = new StringBuilder();
            CVQualifiers cVQualifiers = qualifiers = type instanceof OCCppReferenceType || type instanceof OCPointerType ? type.getTerminalType().getCVQualifiers() : type.getCVQualifiers();
            if (qualifiers.isConst()) {
                res.append(OCTokenTypes.CONST_KEYWORD.getName()).append(" ");
            }
            if (qualifiers.isVolatile()) {
                res.append(OCTokenTypes.VOLATILE_KEYWORD.getName()).append(" ");
            }
            res.append(StringUtil.join(symbols, (Function)new Function<OCSymbolWithQualifiedName, String>(){

                public String fun(OCSymbolWithQualifiedName symbol) {
                    return OCDocUtil.wrapSymbolName(symbol);
                }
            }, (String)"::"));
            List<OCTypeArgument> templateArguments = Collections.emptyList();
            if (terminalType instanceof OCReferenceType) {
                OCQualifiedName name = ((OCReferenceType)terminalType).getReference(containingFile).getQualifiedName();
                if (name instanceof OCQualifiedNameWithArguments) {
                    templateArguments = ((OCQualifiedNameWithArguments)name).getArguments();
                }
            } else {
                templateArguments = struct.getTemplateArguments(new OCResolveContext());
            }
            OCDocUtil.wrapTemplateArgs(templateArguments, contextNamespace, containingFile, res);
            if (type instanceof OCCppReferenceType) {
                res.append(" &amp;");
            }
            if (type instanceof OCPointerType) {
                res.append(" *");
            }
            return res.toString();
        }
        return StringUtil.escapeXml((String)type.getCanonicalName());
    }

    @NotNull
    public static String getNamespace(@NotNull OCSymbolWithQualifiedName symbol) {
        return StringUtil.join(OCDocUtil.getParents(symbol, OCSymbolKind.NAMESPACE), TO_NAME, (String)"::");
    }

    @NotNull
    public static String getCanonicalPrefix(@NotNull OCSymbolWithQualifiedName symbol) {
        List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCSymbolKind.NAMESPACE);
        OCFile containingOCFile = symbol.getContainingOCFile();
        OCSymbolWithQualifiedName parent = OCDocUtil.getParent(symbol, OCSymbolKind.STRUCT, OCSymbolKind.UNION);
        if (parent != null) {
            String prefix = OCDocUtil.getCanonicalName(parent.getType(), contextNamespace, containingOCFile);
            return OCDocUtil.replaceAnonymous(prefix);
        }
        return "";
    }

    @NotNull
    public static String replaceAnonymous(@NotNull String canonicalName) {
        return canonicalName.replace("anonymous ", "<i>(anonymous)</i>");
    }

    @Nullable
    private static OCSymbolWithQualifiedName getParent(@NotNull OCSymbolWithQualifiedName symbol, OCSymbolKind ... filter) {
        OCSymbolWithQualifiedName parent = symbol.getParent();
        if (parent != null) {
            for (OCSymbolKind kind : filter) {
                if (parent.getKind() != kind) continue;
                return parent;
            }
        }
        return null;
    }

    @NotNull
    public static List<OCSymbolWithQualifiedName> getParents(@NotNull OCSymbolWithQualifiedName symbol, OCSymbolKind ... filter) {
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(symbol, filter);
        chain.remove(symbol);
        return chain;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCSymbolWithQualifiedName symbol, final OCSymbolKind ... filter) {
        final ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, new Consumer<OCSymbolWithQualifiedName>(){

            public void consume(OCSymbolWithQualifiedName parent) {
                for (OCSymbolKind kind : filter) {
                    if (parent.getKind() != kind) continue;
                    parents.add(parent);
                }
            }
        });
        return parents;
    }

    @NotNull
    private static String wrapSymbolName(@NotNull OCSymbol symbol) {
        if (!(symbol instanceof OCStructSymbol)) {
            return StringUtil.escapeXml((String)symbol.getPresentableName());
        }
        StringBuilder sb = new StringBuilder();
        OCDocUtil.wrapStruct((OCStructSymbol)symbol, sb);
        return sb.toString();
    }

    private static void wrapStruct(@NotNull OCStructSymbol symbol, @NotNull StringBuilder sb) {
        String name = symbol.getName();
        boolean hasName = !"<unnamed>".equals(name);
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            sb.append("<a href=\"").append(link).append("\">").append(StringUtil.escapeXml((String)name)).append("</a>");
        } else {
            sb.append(StringUtil.escapeXml((String)symbol.getPresentableName()));
        }
    }

    public static void wrapTemplateArgs(@NotNull List<OCTypeArgument> templateArguments, final @NotNull List<OCSymbolWithQualifiedName> contextNamespace, final @Nullable OCFile containingFile, @NotNull StringBuilder answer) {
        String templateArgumentsStr = StringUtil.join(templateArguments, (Function)new Function<OCTypeArgument, String>(){

            public String fun(OCTypeArgument templateArgument) {
                if (templateArgument instanceof OCType) {
                    return OCDocUtil.getCanonicalName((OCType)templateArgument, contextNamespace, containingFile);
                }
                if (templateArgument instanceof OCExpressionTypeArgument) {
                    return ((OCExpressionTypeArgument)templateArgument).getSymbol().getName();
                }
                return "";
            }
        }, (String)", ");
        if (!templateArgumentsStr.isEmpty()) {
            answer.append(StringUtil.escapeXml((String)"<")).append(templateArgumentsStr).append(StringUtil.escapeXml((String)">"));
        }
    }

    public static void wrapTemplateParams(@NotNull List<OCTypeParameterSymbol> templateParams, final @NotNull List<OCSymbolWithQualifiedName> contextNamespace, final @Nullable OCFile containingFile, @NotNull StringBuilder answer) {
        String templateParamsStr = StringUtil.join(templateParams, (Function)new Function<OCTypeParameterSymbol, String>(){

            public String fun(OCTypeParameterSymbol param) {
                StringBuilder sb = new StringBuilder();
                if (param instanceof OCTypeParameterValueSymbol) {
                    String type = ((OCTypeParameterValueSymbol)param).getType().getName();
                    sb.append(type).append(OCDocUtil.delimiter(type));
                }
                if (param.isVariadic()) {
                    sb.append("...");
                }
                sb.append(param.getName());
                Object value = param.getDefaultValue();
                if (value != null) {
                    sb.append(" = ");
                    if (value instanceof OCType) {
                        sb.append(OCDocUtil.getCanonicalName((OCType)value, contextNamespace, containingFile));
                    } else if (value instanceof OCExpressionTypeArgument) {
                        sb.append(((OCExpressionTypeArgument)value).getSymbol().getName());
                    }
                }
                return sb.toString();
            }
        }, (String)", ");
        answer.append(StringUtil.escapeXml((String)"template<")).append(templateParamsStr).append(StringUtil.escapeXml((String)">"));
    }

    @Nullable
    private static String buildLinkSymbol(@NotNull OCSymbol symbol) {
        StringBuilder sb = new StringBuilder("psi_element://");
        VirtualFile file2 = symbol.getContainingFile();
        if (file2 != null) {
            sb.append(file2.getPath()).append('#').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }
}

