/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.ui.OCSymbolTextFieldCompletionProvider;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTextFieldWithSymbolAutoCompletion
extends TextFieldWithAutoCompletion<OCSymbol> {
    private final ProgressIndicator myMainCollectionProgress;

    public OCTextFieldWithSymbolAutoCompletion(@NotNull Project project2, @NotNull TextFieldWithAutoCompletionListProvider<OCSymbol> provider) {
        this(project2, provider, null);
    }

    public OCTextFieldWithSymbolAutoCompletion(@NotNull Project project2, @NotNull TextFieldWithAutoCompletionListProvider<OCSymbol> provider, @Nullable ProgressIndicator mainCollectionProgress) {
        super(project2, provider, false, null);
        this.myMainCollectionProgress = mainCollectionProgress;
    }

    public static OCTextFieldWithSymbolAutoCompletion create(@NotNull Project project2, boolean topLevelOnly, @Nullable Condition<OCSymbol> condition) {
        return OCTextFieldWithSymbolAutoCompletion.create(project2, topLevelOnly, null, condition, null);
    }

    public static OCTextFieldWithSymbolAutoCompletion create(final @NotNull Project project2, final boolean topLevelOnly, @Nullable Function<OCSymbol, String> nameMapper, final @Nullable Condition<OCSymbol> condition, final @Nullable ProcessListener myProcessListener) {
        final CountDownLatch collectionFinished = new CountDownLatch(1);
        final OCSymbolTextFieldCompletionProvider provider = new OCSymbolTextFieldCompletionProvider(nameMapper){
            private static final int THRESHOLD_LENGTH = 2;
            private int startedEventsCount;

            @NotNull
            private Collection<OCSymbol> collectItemsForPrefix(final @Nullable String prefix, CompletionParameters parameters) {
                ProgressIndicator prefixIndicator;
                final Ref prefixResult = Ref.create();
                if (prefix != null && prefix.length() > 2) {
                    prefixIndicator = OCTextFieldWithSymbolAutoCompletion.createIndicator();
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            Collection result = (Collection)ProgressManager.getInstance().runProcess((Computable)new Computable<Collection<OCSymbol>>(){

                                public Collection<OCSymbol> compute() {
                                    final PrefixMatcher matcher = this.createPrefixMatcher(prefix);
                                    return this.collectSymbols(project2, topLevelOnly, new Condition<OCSymbol>(){

                                        public boolean value(OCSymbol symbol) {
                                            return matcher.prefixMatches(symbol.getName()) && (condition == null || condition.value((Object)symbol));
                                        }
                                    });
                                }
                            }, prefixIndicator);
                            prefixResult.set((Object)result);
                        }
                    });
                } else {
                    prefixIndicator = null;
                }
                while (true) {
                    ProgressManager.checkCanceled();
                    if (!prefixResult.isNull()) {
                        return (Collection)prefixResult.get();
                    }
                    try {
                        if (!collectionFinished.await(100L, TimeUnit.MILLISECONDS)) continue;
                        if (prefixIndicator != null) {
                            prefixIndicator.cancel();
                        }
                        return super.getItems(prefix, false, parameters);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            public Collection<OCSymbol> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                Collection<OCSymbol> collection;
                block5: {
                    Collection<OCSymbol> cachedItems = super.getItems(prefix, cached, parameters);
                    if (!cachedItems.isEmpty() || cached) {
                        return cachedItems;
                    }
                    if (myProcessListener != null) {
                        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (startedEventsCount++ == 0) {
                                    myProcessListener.onStarted();
                                }
                            }
                        });
                    }
                    try {
                        collection = this.collectItemsForPrefix(prefix, parameters);
                        if (myProcessListener == null) break block5;
                    }
                    catch (Throwable throwable) {
                        if (myProcessListener != null) {
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                                final /* synthetic */ 1 this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                @Override
                                public void run() {
                                    if (this.this$0.startedEventsCount-- > 0) {
                                        this.this$0.myProcessListener.onFinished();
                                    }
                                }
                            });
                        }
                        throw throwable;
                    }
                    UIUtil.invokeLaterIfNeeded((Runnable)new /* invalid duplicate definition of identical inner class */);
                }
                return collection;
            }
        };
        final ProgressIndicator progress = OCTextFieldWithSymbolAutoCompletion.createIndicator();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    @Override
                    public void run() {
                        Collection<Object> finalItems;
                        Collection<Object> items = ContainerUtil.emptyList();
                        try {
                            finalItems = items = provider.collectSymbols(project2, topLevelOnly, (Condition<OCSymbol>)condition);
                        }
                        catch (Throwable throwable) {
                            List finalItems2 = items;
                            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(this, finalItems2){
                                final /* synthetic */ Collection val$finalItems;
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$finalItems = collection;
                                }

                                @Override
                                public void run() {
                                    this.this$1.provider.setItems(this.val$finalItems);
                                }
                            });
                            collectionFinished.countDown();
                            throw throwable;
                        }
                        UIUtil.invokeAndWaitIfNeeded((Runnable)new /* invalid duplicate definition of identical inner class */);
                        collectionFinished.countDown();
                    }
                }, progress);
            }
        });
        return new OCTextFieldWithSymbolAutoCompletion(project2, provider, progress);
    }

    private static ProgressIndicator createIndicator() {
        ProgressIndicator mainIndicator = ProgressManager.getInstance().getProgressIndicator();
        return mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new ProgressIndicatorBase();
    }

    public void cancelRunningTasks() {
        if (this.myMainCollectionProgress != null) {
            this.myMainCollectionProgress.cancel();
        }
    }

    public static interface ProcessListener {
        public void onStarted();

        public void onFinished();
    }
}

