/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTextFieldCompletionProvider
extends TextFieldWithAutoCompletionListProvider<OCSymbol> {
    private final Function<OCSymbol, String> myLookupStringMapper;

    public OCSymbolTextFieldCompletionProvider(@Nullable Function<OCSymbol, String> nameMapper) {
        super(null);
        this.myLookupStringMapper = OCSymbolTextFieldCompletionProvider.wrapMapper(nameMapper);
    }

    @Override
    @NotNull
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        boolean caseSensitive = CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 3 && CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 2;
        return new CamelHumpMatcher(prefix, caseSensitive);
    }

    @Override
    protected Icon getIcon(@NotNull OCSymbol item) {
        return item.getIcon();
    }

    @Override
    @NotNull
    protected String getLookupString(@NotNull OCSymbol item) {
        return (String)this.myLookupStringMapper.fun((Object)item);
    }

    @Override
    protected String getTailText(@NotNull OCSymbol item) {
        return null;
    }

    @Override
    protected String getTypeText(@NotNull OCSymbol item) {
        VirtualFile file2;
        if (item instanceof OCSymbolWithQualifiedName) {
            OCQualifiedName name;
            OCSymbolWithQualifiedName owner = ((OCSymbolWithQualifiedName)item).getResolvedOwner();
            if (item instanceof OCFunctionSymbol && owner != null) {
                owner = owner.getResolvedOwner();
            }
            if (owner != null && (name = owner.getResolvedQualifiedName()) != null) {
                return name.getCanonicalName(true).substring(2);
            }
        }
        return (file2 = item.getContainingFile()) != null ? file2.getName() : "";
    }

    @Override
    public int compare(OCSymbol item1, OCSymbol item2) {
        return item1.getName().compareTo(item2.getName());
    }

    @NotNull
    public Collection<OCSymbol> collectSymbols(final @NotNull Project project2, boolean topLevelOnly, final @Nullable Condition<OCSymbol> condition) {
        final HashSet set = new HashSet();
        final Collection<OCSymbol> allSymbols = OCSymbolTextFieldCompletionProvider.collectAllSymbols(project2, topLevelOnly);
        return OCSymbolTextFieldCompletionProvider.computeWithWriteActionPriority(new Function<ProgressIndicator, Collection<OCSymbol>>(){

            public Collection<OCSymbol> fun(final ProgressIndicator indicator) {
                CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

                    protected boolean accept(final OCSymbol symbol) {
                        ProgressManager.checkCanceled();
                        Boolean res = null;
                        while (res == null) {
                            try {
                                res = (Boolean)ProgressManager.getInstance().runProcess((Computable)new Computable<Boolean>(){

                                    public Boolean compute() {
                                        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                                            public Boolean compute() {
                                                if (project2.isDisposed()) {
                                                    return false;
                                                }
                                                String mappedSymbolName = (String)OCSymbolTextFieldCompletionProvider.this.myLookupStringMapper.fun((Object)symbol);
                                                if (mappedSymbolName != null && !set.contains(mappedSymbolName) && (condition == null || condition.value((Object)symbol))) {
                                                    set.add(mappedSymbolName);
                                                    return true;
                                                }
                                                return false;
                                            }
                                        });
                                    }
                                }, indicator);
                            }
                            catch (ProcessCanceledException processCanceledException) {}
                        }
                        return res;
                    }
                };
                ContainerUtil.process((Iterable)allSymbols, (Processor)collector);
                return collector.getResults();
            }
        });
    }

    @NotNull
    private static Collection<OCSymbol> collectAllSymbols(final Project project2, final boolean topLevelOnly) {
        return OCSymbolTextFieldCompletionProvider.computeWithWriteActionPriority(new Function<ProgressIndicator, Collection<OCSymbol>>(){

            public Collection<OCSymbol> fun(ProgressIndicator indicator) {
                Collection res = null;
                while (res == null) {
                    try {
                        res = (Collection)ProgressManager.getInstance().runProcess((Computable)new Computable<Collection<OCSymbol>>(){

                            public Collection<OCSymbol> compute() {
                                return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<OCSymbol>>(){

                                    public Collection<OCSymbol> compute() {
                                        if (project2.isDisposed()) {
                                            return Collections.emptyList();
                                        }
                                        CommonProcessors.CollectProcessor allCollector = new CommonProcessors.CollectProcessor();
                                        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)allCollector, null, topLevelOnly);
                                        return allCollector.getResults();
                                    }
                                });
                            }
                        }, indicator);
                    }
                    catch (ProcessCanceledException processCanceledException) {}
                }
                return res;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T computeWithWriteActionPriority(@NotNull Function<ProgressIndicator, T> f) {
        Disposable disposable = Disposer.newDisposable();
        EmptyProgressIndicator localIndicator = new EmptyProgressIndicator();
        ProgressIndicatorUtils.forceWriteActionPriority((ProgressIndicator)localIndicator, disposable);
        try {
            Object object = f.fun((Object)localIndicator);
            return (T)object;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    @NotNull
    private static Function<OCSymbol, String> wrapMapper(final @Nullable Function<OCSymbol, String> nameMapper) {
        return new Function<OCSymbol, String>(){

            public String fun(OCSymbol symbol) {
                String result = null;
                if (nameMapper != null) {
                    result = (String)nameMapper.fun((Object)symbol);
                }
                return result != null ? result : symbol.getPresentableName();
            }
        };
    }
}

