/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.jetbrains.cidr.lang.daemon.OCArgumentsChecker;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCNumber;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeUnificationVisitor
implements OCTypeVisitor<UnificationResult> {
    public static final int MAX_EXPANSION_PACK_SIZE = 25;
    public static final UnificationResult NOT_UNIFIED = new UnificationResult(-1);
    public static final UnificationResult UNIFIED = new UnificationResult(1);
    public static final UnificationResult UNIFIED_CONST_VALUE = new UnificationResult(1, 0, 1);
    public static final UnificationResult UNKNOWN = new UnificationResult(0);
    private boolean myFunctionParametersMode;
    private boolean myCheckFunctionReturnTypes;
    private boolean myVariadicMode;
    private final boolean myMagicTypesEqual;
    private OCTypeArgument myArgument;
    @Nullable
    private OCTypeOwner myArgumentExpr;
    private final Map<OCTypeParameterSymbol, OCTypeArgument> mySubstitutionMap;
    @Nullable
    private Set<OCTypeParameterSymbol> myDependentTypes;
    @NotNull
    private final OCResolveContext myContext;

    public OCTypeUnificationVisitor(boolean functionParametersMode, boolean checkFunctionReturnTypes, boolean variadicMode, boolean magicTypesEqual, @NotNull OCTypeArgument argument, @Nullable OCTypeOwner expression, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @Nullable Set<OCTypeParameterSymbol> dependentTypes, @NotNull OCResolveContext context) {
        this.myFunctionParametersMode = functionParametersMode;
        this.myCheckFunctionReturnTypes = checkFunctionReturnTypes;
        this.myVariadicMode = variadicMode;
        this.myMagicTypesEqual = magicTypesEqual;
        this.myArgument = argument;
        this.myArgumentExpr = expression;
        this.mySubstitutionMap = substitutionMap;
        this.myDependentTypes = dependentTypes;
        this.myContext = context;
    }

    public UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument) {
        if (parameter instanceof OCExpressionTypeArgument) {
            OCResolveContext context = this.myContext.substitute(OCSimpleTypeSubstitution.create(this.mySubstitutionMap));
            OCExpressionSymbol parameterSymbol = ((OCExpressionTypeArgument)parameter).getSymbol();
            Number paramValue = OCExpressionEvaluator.evaluate(parameterSymbol, context);
            Number argValue = null;
            if (paramValue == null) {
                OCSymbol symbol;
                if (parameterSymbol instanceof OCReferenceExpressionSymbol && (symbol = ((OCReferenceExpressionSymbol)parameterSymbol).resolveToSymbol(this.myContext)) instanceof OCTypeParameterValueSymbol) {
                    if (((OCTypeParameterSymbol)((Object)symbol)).isVariadic() && !(argument instanceof OCExpansionPackType)) {
                        OCTypeArgument old = this.mySubstitutionMap.get((OCTypeParameterSymbol)((Object)symbol));
                        argument = old != null ? ((OCExpansionPackType)old).appendTypeArgument(argument) : new OCExpansionPackType(Collections.singletonList(argument));
                    }
                    this.mySubstitutionMap.put((OCTypeParameterSymbol)((Object)symbol), argument);
                    return UNIFIED;
                }
                return UNKNOWN;
            }
            if (argument instanceof OCExpressionTypeArgument) {
                argValue = OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)argument).getSymbol(), context);
            } else if (!(argument instanceof OCMagicType) && !(argument instanceof OCReferenceType)) {
                return NOT_UNIFIED;
            }
            if (argValue != null) {
                return OCTypeUnificationVisitor.isSameValue(paramValue, argValue) ? UNIFIED_CONST_VALUE : NOT_UNIFIED;
            }
        } else if (parameter instanceof OCType) {
            if (argument instanceof OCReferenceType) {
                argument = OCUnknownType.INSTANCE;
            }
            if (parameter instanceof OCPointerType && !(argument instanceof OCPointerType) && ((OCPointerType)parameter).getRefType() instanceof OCFunctionType) {
                parameter = ((OCPointerType)parameter).getRefType();
            }
            if (parameter instanceof OCCppReferenceType && ((OCCppReferenceType)parameter).getRefType() instanceof OCFunctionType) {
                parameter = ((OCCppReferenceType)parameter).getRefType();
            }
            if (argument instanceof OCCppReferenceType && ((OCCppReferenceType)argument).getRefType() instanceof OCFunctionType) {
                argument = ((OCCppReferenceType)argument).getRefType();
            }
            if (this.myFunctionParametersMode) {
                if (argument instanceof OCCppReferenceType) {
                    argument = ((OCCppReferenceType)argument).getRefType();
                }
                if (parameter instanceof OCCppReferenceType) {
                    if (argument instanceof OCType && ((OCCppReferenceType)parameter).isRvalueRef() && !((OCCppReferenceType)parameter).getRefType().isConst() && OCLValueVisitor.isLvalue(this.myArgumentExpr) && !(argument instanceof OCCppReferenceType)) {
                        argument = OCCppReferenceType.to((OCType)argument);
                    }
                    parameter = ((OCCppReferenceType)parameter).getRefType();
                }
            }
            if (argument instanceof OCTypeParameterType && this.myMagicTypesEqual && this.myDependentTypes != null) {
                if (parameter instanceof OCTypeParameterType) {
                    this.myDependentTypes.add(((OCTypeParameterType)argument).getSymbol());
                } else {
                    ((OCType)parameter).accept(new OCBooleanTypeVisitor(){

                        @Override
                        public Boolean visitTypeParameterType(OCTypeParameterType type) {
                            OCTypeUnificationVisitor.this.myDependentTypes.add(type.getSymbol());
                            return true;
                        }
                    });
                }
            }
            OCTypeArgument save = this.myArgument;
            this.myArgument = argument;
            UnificationResult result = !(this.myFunctionParametersMode || !(argument instanceof OCType) || argument instanceof OCExpansionPackType || (((OCType)parameter).isConst() == ((OCType)argument).isConst() || parameter instanceof OCTypeParameterType && !(argument instanceof OCTypeParameterType) && !((OCTypeParameterType)parameter).isConst()) && ((OCType)parameter).isVolatile() == ((OCType)argument).isVolatile() || parameter instanceof OCTypeParameterType && !(argument instanceof OCTypeParameterType) && !((OCTypeParameterType)parameter).isVolatile()) ? this.defaultResult() : ((OCType)parameter).accept(this);
            this.myArgument = save;
            return result;
        }
        return UNKNOWN;
    }

    public static boolean isSameValue(@Nullable Object value1, @Nullable Object value2) {
        if (value1 instanceof Boolean && value2 instanceof Number) {
            return (Boolean)value1 == (OCExpressionEvaluator.singAsInC(value2) != 0);
        }
        if (value1 instanceof Number && value2 instanceof Boolean) {
            return OCExpressionEvaluator.singAsInC(value1) != 0 == (Boolean)value2;
        }
        if (value1 instanceof Number && value2 instanceof Number) {
            return OCNumber.valueOf(value1).compareTo(OCNumber.valueOf(value2)) == 0;
        }
        return Comparing.equal((Object)value1, (Object)value2);
    }

    private boolean isMagicType() {
        return !(this.myArgument instanceof OCType) || this.myArgument instanceof OCMagicType;
    }

    private UnificationResult defaultResult() {
        if (this.isMagicType()) {
            return this.myMagicTypesEqual ? UNKNOWN : NOT_UNIFIED;
        }
        return this.myFunctionParametersMode && !this.myVariadicMode ? UNKNOWN : NOT_UNIFIED;
    }

    @Override
    public UnificationResult visitFunctionType(OCFunctionType type) {
        if (this.myArgument instanceof OCFunctionType) {
            int argumentsCnt;
            OCFunctionType argumentFunction = (OCFunctionType)this.myArgument;
            List<OCType> parameterTypes = type.getParameterTypes();
            List<OCType> argumentTypes = argumentFunction.getParameterTypes();
            int paramsCnt = parameterTypes.size();
            if (paramsCnt == (argumentsCnt = argumentTypes.size()) || type.isVararg() && argumentsCnt + 1 >= paramsCnt) {
                final Ref result = Ref.create((Object)UNIFIED);
                if (this.myCheckFunctionReturnTypes) {
                    UnificationResult cur = this.unify(type.getReturnType(), argumentFunction.getReturnType());
                    if (cur == NOT_UNIFIED) {
                        return cur;
                    }
                    result.set((Object)((UnificationResult)result.get()).add(cur));
                }
                if (!OCArgumentsChecker.processArguments(parameterTypes, argumentTypes, new OCArgumentsChecker.TypeArgumentsProcessor(){

                    @Override
                    public boolean process(OCTypeArgument parameterType, OCTypeArgument argumentType) {
                        UnificationResult cur = OCTypeUnificationVisitor.this.unify(parameterType, argumentType);
                        result.set((Object)((UnificationResult)result.get()).add(cur));
                        return cur != NOT_UNIFIED;
                    }
                })) {
                    return NOT_UNIFIED;
                }
                return (UnificationResult)result.get();
            }
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitMagicType(OCMagicType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitObjectType(OCObjectType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitArrayType(OCArrayType type) {
        if (this.myArgument instanceof OCArrayType) {
            return this.unify(type.getRefType(), ((OCArrayType)this.myArgument).getRefType()).add(UNIFIED);
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitPointerType(OCPointerType type) {
        if (this.myArgument instanceof OCPointerType) {
            UnificationResult result = this.unify(type.getRefType(), ((OCPointerType)this.myArgument).getRefType());
            OCType classQualifier = type.getClassQualifier();
            OCType myClassQualifier = ((OCPointerType)this.myArgument).getClassQualifier();
            if (result == NOT_UNIFIED) {
                return result;
            }
            result = result.add(UNIFIED);
            if (classQualifier == null != (myClassQualifier == null)) {
                return NOT_UNIFIED;
            }
            if (classQualifier != null) {
                result = result.add(this.unify(classQualifier, myClassQualifier));
            }
            return result;
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitBlockPointerType(OCBlockPointerType type) {
        if (this.myArgument instanceof OCBlockPointerType) {
            return this.unify(type.getRefType(), ((OCBlockPointerType)this.myArgument).getRefType()).add(UNIFIED);
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitCppReferenceType(OCCppReferenceType type) {
        if (this.myArgument instanceof OCCppReferenceType) {
            OCCppReferenceType argument = (OCCppReferenceType)this.myArgument;
            if (type.isRvalueRef() == argument.isRvalueRef()) {
                return this.unify(type.getRefType(), argument.getRefType()).add(UNIFIED);
            }
        }
        return this.defaultResult();
    }

    @Override
    public UnificationResult visitIdType(OCIdType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitReferenceType(OCReferenceType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitUnknownType(OCUnknownType type) {
        return NOT_UNIFIED;
    }

    @Override
    public UnificationResult visitAutoType(OCAutoType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitEllipsisReferenceType(OCEllipsisType type) {
        return this.myArgument instanceof OCEllipsisType ? UNIFIED : this.defaultResult();
    }

    @Override
    public UnificationResult visitIntType(OCIntType type) {
        return this.myArgument.equals(type, this.myContext) ? UNIFIED : this.defaultResult();
    }

    @Override
    public UnificationResult visitRealType(OCRealType type) {
        return this.myArgument.equals(type, this.myContext) ? UNIFIED : this.defaultResult();
    }

    @Override
    public UnificationResult visitVoidType(OCVoidType type) {
        return this.myArgument.equals(type, this.myContext) ? UNIFIED : this.defaultResult();
    }

    @Nullable
    private OCType findMatchingAncestor(OCType argumentType, OCStructType paramType) {
        if (argumentType instanceof OCMagicType || argumentType instanceof OCStructType && ((OCStructType)argumentType).getSymbol().resolvedNamesEqual(paramType.getSymbol())) {
            return argumentType;
        }
        if (this.myFunctionParametersMode && argumentType instanceof OCStructType) {
            for (final OCStructSymbol paramSymbol : paramType.getStructs()) {
                for (OCStructSymbol argumentSymbol : ((OCStructType)argumentType).getStructs()) {
                    final Ref result = new Ref();
                    argumentSymbol.processAllBaseClasses(this.myContext, new OCStructSymbol.BaseClassProcessor(){

                        @Override
                        public boolean process(OCSymbol baseSymbol, OCVisibility visibility) {
                            if (baseSymbol instanceof OCStructSymbol && ((OCStructSymbol)baseSymbol).resolvedNamesEqual(paramSymbol)) {
                                result.set((Object)baseSymbol.getType());
                                return false;
                            }
                            if (baseSymbol instanceof OCTypeParameterSymbol) {
                                result.set((Object)new OCMagicType());
                                return false;
                            }
                            return true;
                        }
                    }, false);
                    if (result.isNull()) continue;
                    return (OCType)result.get();
                }
            }
        }
        return null;
    }

    @Override
    public UnificationResult visitStructType(OCStructType type) {
        OCType argumentType;
        OCType oCType = argumentType = this.myArgument instanceof OCStructType ? this.findMatchingAncestor((OCStructType)this.myArgument, type) : null;
        if (argumentType == null) {
            return this.defaultResult();
        }
        final Ref result = Ref.create((Object)UNIFIED);
        if (argumentType instanceof OCStructType) {
            this.myContext.setDontExpandVariadics(true);
            OCStructSymbol paramSymbol = type.getSymbol();
            List<OCTypeArgument> parameterArgs = paramSymbol.getTemplateArguments(this.myContext);
            boolean hasNullArgs = false;
            if (!paramSymbol.isSpecialization()) {
                for (OCTypeParameterSymbol paramParamSymbol : paramSymbol.getTemplateParameters()) {
                    if (paramSymbol.getSubstitution().getSubstitutionFor(paramParamSymbol) != null || paramParamSymbol.isVariadic()) continue;
                    if (this.myDependentTypes != null) {
                        this.myDependentTypes.add(paramParamSymbol);
                    }
                    hasNullArgs = true;
                }
            }
            if (hasNullArgs) {
                List<OCTypeArgument> typeArgs = type.getResolvedArguments(this.myContext.clearSubstitution());
                parameterArgs = typeArgs != null ? typeArgs : parameterArgs;
            }
            this.myContext.setDontExpandVariadics(false);
            List<OCTypeArgument> argumentArgs = ((OCStructType)argumentType).getSymbol().getTemplateArguments(this.myContext);
            if (!OCArgumentsChecker.processArguments(parameterArgs, argumentArgs, new OCArgumentsChecker.TypeArgumentsProcessor(){

                @Override
                public boolean process(OCTypeArgument parameterType, OCTypeArgument argumentType) {
                    if (parameterType == null || argumentType == null) {
                        return true;
                    }
                    boolean save = OCTypeUnificationVisitor.this.myFunctionParametersMode;
                    OCTypeUnificationVisitor.this.myFunctionParametersMode = false;
                    UnificationResult cur = OCTypeUnificationVisitor.this.unify(parameterType, argumentType);
                    OCTypeUnificationVisitor.this.myFunctionParametersMode = save;
                    result.set((Object)((UnificationResult)result.get()).add(cur));
                    return cur != NOT_UNIFIED;
                }
            })) {
                return NOT_UNIFIED;
            }
        }
        return (UnificationResult)result.get();
    }

    @Override
    public UnificationResult visitTypeParameterType(OCTypeParameterType type) {
        OCTypeParameterSymbol parameterSymbol = type.getSymbol();
        UnificationResult result = UNKNOWN;
        if (this.myArgument instanceof OCTypeParameterType && ((OCTypeParameterType)this.myArgument).getSymbol().equals(parameterSymbol)) {
            return UNIFIED;
        }
        if (parameterSymbol instanceof OCTypeParameterValueSymbol ? !(this.myArgument instanceof OCExpressionTypeArgument) && (!(this.myArgument instanceof OCTypeParameterType) || !(((OCTypeParameterType)this.myArgument).getSymbol() instanceof OCTypeParameterValueSymbol)) && !(this.myArgument instanceof OCExpansionPackType) : this.isMagicType() && !(this.myArgument instanceof OCTypeParameterType)) {
            return UNKNOWN;
        }
        OCTypeArgument old = this.mySubstitutionMap.get(parameterSymbol);
        if (this.myArgument instanceof OCType && !(this.myArgument instanceof OCExpansionPackType)) {
            OCType argumentType = (OCType)this.myArgument;
            if (type.isConst()) {
                if (argumentType.isConst()) {
                    argumentType = argumentType.cloneWithoutConstModifier(this.myContext.getProject());
                    this.myArgument = argumentType;
                    result = result.add(UNIFIED);
                } else if (!this.myFunctionParametersMode) {
                    return NOT_UNIFIED;
                }
            }
            if (type.isVolatile()) {
                if (argumentType.isVolatile()) {
                    this.myArgument = argumentType.cloneWithCVQualifiers(new CVQualifiers(argumentType.isConst(), false), this.myContext.getProject());
                    result = result.add(UNIFIED);
                } else if (!this.myFunctionParametersMode) {
                    return NOT_UNIFIED;
                }
            }
        }
        if (parameterSymbol.isVariadic()) {
            if (this.myArgument instanceof OCVariadicType && ((OCVariadicType)this.myArgument).getUnderlyingType() instanceof OCExpansionPackType) {
                return NOT_UNIFIED;
            }
            if (!(this.myArgument instanceof OCExpansionPackType)) {
                if (old != null) {
                    OCExpansionPackType expansionPack = (OCExpansionPackType)old;
                    if (expansionPack.getExpansionsCnt() > 25) {
                        return NOT_UNIFIED;
                    }
                    this.myArgument = expansionPack.appendTypeArgument(this.myArgument);
                } else {
                    this.myArgument = new OCExpansionPackType(Collections.singletonList(this.myArgument));
                }
            }
        } else if (this.myArgument instanceof OCExpansionPackType || this.myArgument instanceof OCVariadicType) {
            if (!((OCType)this.myArgument).isMagicInside(this.myContext)) {
                return NOT_UNIFIED;
            }
        } else if (old != null) {
            boolean equal;
            boolean bl = equal = old instanceof OCType && this.myArgument instanceof OCType ? new OCTypeEqualityVisitor((OCType)old, this.myMagicTypesEqual, false, false, false, false, true, true, this.myContext).equal((OCType)this.myArgument) : old.equals(this.myArgument, this.myContext);
            if (!equal) {
                return NOT_UNIFIED;
            }
        }
        this.mySubstitutionMap.put(parameterSymbol, this.myArgument);
        return result;
    }

    @Override
    public UnificationResult visitVariadicType(OCVariadicType type) {
        return UNKNOWN;
    }

    @Override
    public UnificationResult visitExpansionPackType(OCExpansionPackType type) {
        return UNKNOWN;
    }

    public static class UnificationResult {
        private final int numOfUnified;
        private int numOfNonSpecializedArgs;
        private int numOfConstantValueArgs;

        UnificationResult(int numOfUnified) {
            this.numOfUnified = numOfUnified;
        }

        public UnificationResult(int numOfUnified, int numOfNonSpecializedArgs, int numOfConstantValueArgs) {
            this.numOfUnified = numOfUnified;
            this.numOfNonSpecializedArgs = numOfNonSpecializedArgs;
            this.numOfConstantValueArgs = numOfConstantValueArgs;
        }

        UnificationResult add(UnificationResult result) {
            if (this == NOT_UNIFIED || result == NOT_UNIFIED) {
                return NOT_UNIFIED;
            }
            return new UnificationResult(this.numOfUnified + result.numOfUnified, this.numOfNonSpecializedArgs + result.numOfNonSpecializedArgs, this.numOfConstantValueArgs + result.numOfConstantValueArgs);
        }

        void incNumOfNonSpecializedArgs() {
            ++this.numOfNonSpecializedArgs;
        }

        public boolean isUnified() {
            return this.numOfUnified > 0;
        }

        boolean isBetter(UnificationResult other) {
            if (this.numOfUnified > other.numOfUnified) {
                return true;
            }
            if (this.numOfUnified < other.numOfUnified) {
                return false;
            }
            if (this.numOfNonSpecializedArgs < other.numOfNonSpecializedArgs) {
                return true;
            }
            if (this.numOfNonSpecializedArgs > other.numOfNonSpecializedArgs) {
                return false;
            }
            return this.numOfConstantValueArgs > other.numOfConstantValueArgs;
        }

        public String toString() {
            if (this == UNIFIED) {
                return "UNIFIED";
            }
            if (this == NOT_UNIFIED) {
                return "NOT_UNIFIED";
            }
            if (this == UNKNOWN) {
                return "UNKNOWN";
            }
            return "UnificationResult(" + this.numOfUnified + ")";
        }
    }
}

