/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInternator;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeResolveVisitor
extends OCNonPrimitiveTypeCloneVisitor {
    private static final int MAX_TYPES_TO_RESOLVE_PER_CONTEXT = 10000;
    private final boolean myResolveIgnoreImports;
    private final boolean myIsInOldC;
    private Set<VirtualFile> myUsedFiles = new HashSet<VirtualFile>();
    private OCFile myFile;
    @NotNull
    private final OCResolveContext myContext;
    private int myDepth;
    private int myMaxDepth = 256;
    private static final Key<CachedValue<Map<TypeKey, ResultInfo>>> RESOLVE_CACHE = Key.create((String)"RESOLVE_CACHE_IN_FILE");
    private static final OCInternator<ArrayList<VirtualFile>> USED_FILE_LIST_INTERNATOR = new OCInternator<ArrayList<VirtualFile>>(){

        @Override
        @NotNull
        protected ArrayList<VirtualFile> valueToStore(@NotNull ArrayList<VirtualFile> original) {
            original.trimToSize();
            return original;
        }
    };
    private static final Comparator<VirtualFile> FILE_PATH_COMPARATOR = new Comparator<VirtualFile>(){

        @Override
        public int compare(@NotNull VirtualFile o1, @NotNull VirtualFile o2) {
            return Comparing.compare((Comparable)((Object)o1.getPath()), (Comparable)((Object)o2.getPath()));
        }
    };

    public OCTypeResolveVisitor(@NotNull OCResolveContext context, boolean resolveIgnoreImports) {
        PsiFile psiFile = context.getFile();
        this.myFile = psiFile instanceof OCFile ? (OCFile)psiFile : null;
        this.myResolveIgnoreImports = resolveIgnoreImports;
        this.myContext = context;
        boolean bl = this.myIsInOldC = this.myFile != null && !this.myFile.isCpp();
        if (this.myFile instanceof OCCodeFragment) {
            PsiElement parent = this.myFile.getContext();
            this.myFile = parent != null ? (OCFile)parent.getContainingFile() : null;
        }
    }

    public OCTypeResolveVisitor(@Nullable PsiFile file2, boolean resolveIgnoreImports) {
        this(new OCResolveContext((PsiElement)file2), resolveIgnoreImports);
    }

    public OCTypeResolveVisitor(@NotNull OCResolveContext context) {
        this(context, false);
    }

    @Override
    public OCType visitStructType(OCStructType type) {
        return type;
    }

    @Override
    public OCType visitFunctionType(OCFunctionType type) {
        List<String> oldParamNames = type.getParameterNames(true);
        List<OCType> paramTypes = OCArgumentsList.expandVariadicTypes(type.getParameterTypes(true), this.myContext);
        OCFunctionType functionType = (OCFunctionType)super.visitFunctionType(new OCFunctionType(type.getReturnType(), paramTypes, null, type.isConst(), type.isVolatile()));
        List<OCType> parameterTypes = functionType.getParameterTypes(true);
        ArrayList<String> clonedNames = null;
        if (oldParamNames != null) {
            clonedNames = new ArrayList<String>();
            for (int i = 0; i < parameterTypes.size(); ++i) {
                clonedNames.add(i < oldParamNames.size() ? oldParamNames.get(i) : null);
            }
        }
        return new OCFunctionType(functionType.getReturnType(), parameterTypes, clonedNames, functionType.isConst(), functionType.isVolatile());
    }

    @Override
    public OCType visitAutoType(OCAutoType type) {
        return this.getCachedOrResolve((OCType)type, (TypeKey)this.getTypeKey((OCType)type), (Key)PsiModificationTracker.MODIFICATION_COUNT).resolvedType;
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type) {
        ResultInfo resolved;
        if (type.getReference(this.myFile).getQualifiedName().getName() == null) {
            return OCUnknownType.INSTANCE;
        }
        if (this.myFile == null) {
            return type;
        }
        if (this.myDepth > this.myMaxDepth) {
            return type;
        }
        ++this.myDepth;
        TypeKey typeKey = this.getTypeKey(type);
        if (!this.myResolveIgnoreImports && type.getReference(this.myFile) instanceof OCSymbolReference.GlobalReference) {
            resolved = this.getCachedOrResolve(type, typeKey, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        } else {
            OCType resolvedType = this.doResolve(type, typeKey);
            Set<OCTypeParameterSymbol> dependencies = this.myContext.getTypeDependencies();
            resolved = new ResultInfo(resolvedType, this.myUsedFiles, !dependencies.isEmpty() ? dependencies : null);
        }
        --this.myDepth;
        OCFileSymbols.markImportsNeeded(this.myFile, resolved.usedFiles);
        OCType myGuessedType = type.getGuessedType();
        return myGuessedType != type ? resolved.resolvedType.cloneWithGuessedType(myGuessedType.resolve(this.myFile)) : resolved.resolvedType;
    }

    protected ResultInfo getCachedOrResolve(OCType type, TypeKey typeKey, final Key modificationTracker) {
        ResultInfo resolved;
        Map cacheValue;
        ResultInfo cached;
        CachedValue cache = (CachedValue)this.myFile.getUserData(RESOLVE_CACHE);
        if (cache == null) {
            cache = CachedValuesManager.getManager((Project)this.myFile.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<TypeKey, ResultInfo>>(){

                public CachedValueProvider.Result<Map<TypeKey, ResultInfo>> compute() {
                    return new CachedValueProvider.Result((Object)ContainerUtil.newConcurrentMap(), new Object[]{modificationTracker});
                }
            }, false);
            cache = (CachedValue)((UserDataHolderEx)this.myFile).putUserDataIfAbsent(RESOLVE_CACHE, (Object)cache);
        }
        if ((cached = (ResultInfo)(cacheValue = (Map)cache.getValue()).get(typeKey)) == null) {
            OCType resolvedType;
            Set<OCTypeParameterSymbol> oldDependencies = this.myContext.getTypeDependencies();
            this.myContext.clearTypeDependencies();
            if (type instanceof OCReferenceType) {
                OCReferenceType referenceType = (OCReferenceType)type;
                resolvedType = this.doResolve(referenceType, typeKey);
                if (resolvedType instanceof OCArrayType && referenceType.isFunctionParameterType()) {
                    resolvedType = OCFunctionType.convertArrayParameterType(resolvedType);
                }
            } else {
                resolvedType = this.doResolve((OCAutoType)type, typeKey);
            }
            Set<OCTypeParameterSymbol> dependencies = this.myContext.getTypeDependencies();
            dependencies = !dependencies.isEmpty() ? dependencies : null;
            resolved = new ResultInfo(resolvedType, this.internedUsedFilesCopy(), dependencies);
            this.myContext.addTypeDependencies(oldDependencies);
            if (!(resolvedType instanceof OCUnknownType) && !(resolvedType instanceof OCReferenceType)) {
                cacheValue.put(typeKey, resolved);
            }
        } else {
            resolved = cached;
            ContainerUtil.addAllNotNull(this.myUsedFiles, cached.usedFiles);
            if (cached.typeDependencies != null) {
                this.myContext.addTypeDependencies(cached.typeDependencies);
            }
        }
        return resolved;
    }

    @NotNull
    private TypeKey getTypeKey(OCType type) {
        OCTypeSubstitution substitution = this.myContext.getSubstitution();
        if (!(type instanceof OCAutoType)) {
            substitution = substitution.getMinimalDependentSubstitution(type, this.myContext);
        }
        return new TypeKey(type, substitution, this.myContext.isInSFINAE());
    }

    @NotNull
    private Collection<VirtualFile> internedUsedFilesCopy() {
        if (this.myUsedFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> copy = new ArrayList<VirtualFile>(this.myUsedFiles);
        Collections.sort(copy, FILE_PATH_COMPARATOR);
        return USED_FILE_LIST_INTERNATOR.intern(copy);
    }

    private OCType doResolve(OCReferenceType type, TypeKey typeKey) {
        int typesResolved = this.myContext.getTypeResolveCounter();
        this.myContext.incTypeResolveCounter();
        OCQualifiedName qualifiedName = type.getReference(this.myFile).getQualifiedName();
        if (typesResolved > 10000) {
            return new OCMagicType(type);
        }
        Resolver resolver = new Resolver(type);
        String canonicalName = type.getCanonicalName(this.myFile);
        OCSymbolReference.NameWithToken nameWithToken = OCSymbolReference.removeTypeToken(canonicalName);
        if (nameWithToken.typeToken != null) {
            resolver.setPreferableKind(OCSymbolKind.parse(nameWithToken.typeToken));
        }
        if (this.addProcessingType(typeKey)) {
            OCType answer;
            if (qualifiedName.getQualifier() == null && "id".equals(qualifiedName.getName())) {
                OCIdType idType = new OCIdType(resolver.getProtocols(false, true), resolver.getProtocols(false, false), this.myFile.getProject(), false, false);
                return OCPointerType.to((OCType)idType, type.getARCAttribute());
            }
            if (this.myResolveIgnoreImports || !this.processPossibleSymbols(type, resolver, false) && this.myFile.isInLibraries()) {
                this.processPossibleSymbols(type, resolver, true);
            }
            if ((answer = resolver.getAnswer()) != null) {
                answer = answer.cloneWithAddedCVQualifiers(type.getCVQualifiers(), this.myContext.getProject());
            }
            this.removeProcessingType(typeKey);
            return answer != null ? answer : type;
        }
        return OCUnknownType.INSTANCE;
    }

    protected OCType doResolve(OCAutoType type, TypeKey typeKey) {
        OCType result;
        if (!this.addProcessingType(typeKey)) {
            return OCUnknownType.INSTANCE;
        }
        OCResolveContext context = this.myContext.substituteFirst(type.getSubstitution());
        OCExpressionSymbol symbol = type.getExpressionSymbol();
        OCExpression element = type.getExpressionElement();
        if (element != null && element.isValid()) {
            result = element.getResolvedType(context);
        } else {
            if (element != null) {
                PsiFile file2 = this.myContext.getFile();
                if (file2 != null) {
                    OCLog.LOG.error("Invalid PSI context in auto type", new Attachment[]{new Attachment(file2.getName(), file2.getText())});
                } else {
                    OCLog.LOG.error("Invalid PSI context in auto type");
                }
            }
            result = symbol != null ? symbol.getResolvedType(context) : null;
        }
        this.removeProcessingType(typeKey);
        if (result != null && element != null && element.getParent() instanceof OCForeachStatement) {
            result = OCCodeInsightUtil.getCollectionElementType(element, result);
        }
        OCType incompleteType = type.getIncompleteType();
        if (result != null && incompleteType != null) {
            HashMap<OCTypeParameterSymbol, OCTypeArgument> substitutionMap;
            ArrayList autoSymbols;
            if (!(incompleteType instanceof OCCppReferenceType) && (result = result.cloneWithCVQualifiers(new CVQualifiers(false, false), context.getProject())) instanceof OCCppReferenceType) {
                result = OCCppReferenceType.to(((OCCppReferenceType)result).getRefType().cloneWithCVQualifiers(new CVQualifiers(false, false), context.getProject()), ((OCCppReferenceType)result).isRvalueRef(), false, false);
            }
            if (OCSimpleTypeSubstitution.unify(incompleteType = incompleteType.accept(new OCNonPrimitiveTypeCloneVisitor(autoSymbols = new ArrayList(), symbol){
                final /* synthetic */ List val$autoSymbols;
                final /* synthetic */ OCExpressionSymbol val$symbol;
                {
                    this.val$autoSymbols = list;
                    this.val$symbol = oCExpressionSymbol;
                }

                @Override
                public OCType visitAutoType(OCAutoType type) {
                    String name = "auto" + this.val$autoSymbols.size();
                    OCTypeParameterTypeSymbol autoSymbol = new OCTypeParameterTypeSymbol(this.val$symbol.getProject(), this.val$symbol.getContainingFile(), this.val$symbol.getOffset(), name, null, Collections.emptyList(), null, false);
                    this.val$autoSymbols.add(autoSymbol);
                    return new OCTypeParameterType(autoSymbol, type.isConst(), type.isVolatile());
                }
            }), result, null, substitutionMap = new HashMap<OCTypeParameterSymbol, OCTypeArgument>(), null, true, false, context) != OCTypeUnificationVisitor.NOT_UNIFIED) {
                for (OCTypeParameterSymbol autoSymbol : autoSymbols) {
                    if (substitutionMap.containsKey(autoSymbol)) continue;
                    substitutionMap.put(autoSymbol, OCUnknownType.INSTANCE);
                }
                return new OCSimpleTypeSubstitution(substitutionMap).substitute(incompleteType, context);
            }
            return OCUnknownType.INSTANCE;
        }
        return result != null ? result : OCUnknownType.INSTANCE;
    }

    private boolean processPossibleSymbols(OCReferenceType type, Resolver resolver, boolean ignoreImports) {
        OCResolveContext context = this.myContext.substituteFirst(type.getSubstitution());
        context.setProcessNonImported(ignoreImports);
        List<OCSymbol> symbols = context.resolveToSymbols(type.getReference(this.myFile), false, false, false, true);
        int oldMaxDepth = this.myMaxDepth;
        if (context.wasDependentType()) {
            this.myMaxDepth = 6;
        }
        ContainerUtil.process(symbols, (Processor)resolver);
        this.myMaxDepth = oldMaxDepth;
        this.myContext.addTypeDependencies(context.getTypeDependencies());
        return !symbols.isEmpty();
    }

    private boolean addProcessingType(TypeKey typeKey) {
        return this.myContext.getResolvingTypes().add(typeKey);
    }

    private void removeProcessingType(TypeKey typeKey) {
        this.myContext.getResolvingTypes().remove(typeKey);
    }

    private boolean containsProcessingType(TypeKey typeKey) {
        return this.myContext.getResolvingTypes().contains(typeKey);
    }

    public static class OCObjectTypeReResolver
    extends OCTypeCloneVisitor {
        private PsiFile myFile;

        public OCObjectTypeReResolver(@Nullable PsiFile file2) {
            super(false);
            this.myFile = file2;
        }

        @Override
        public OCType visitObjectType(OCObjectType type) {
            Function<OCProtocolSymbol, String> protocolNameCalculator = new Function<OCProtocolSymbol, String>(){

                public String fun(OCProtocolSymbol symbol) {
                    return symbol.getName();
                }
            };
            return OCReferenceType.fromText(type.getClassName(), ContainerUtil.map(type.getAllProtocols(), (Function)protocolNameCalculator)).resolve(this.myFile, true);
        }
    }

    private class Resolver
    implements Processor<OCSymbol> {
        private OCReferenceType myType;
        private OCType myAnswer;
        private OCInterfaceSymbol myInterface;
        private OCImplementationSymbol myImplementation;
        private List<OCInterfaceSymbol> myCategoryInterfaces = new ArrayList<OCInterfaceSymbol>();
        private List<OCImplementationSymbol> myCategoryImplementations = new ArrayList<OCImplementationSymbol>();
        private OCSymbolKind myPreferableKind;

        private Resolver(OCReferenceType type) {
            this.myType = type;
        }

        void setPreferableKind(OCSymbolKind kind) {
            this.myPreferableKind = kind;
        }

        private int getInterfaceClassRank(OCInterfaceSymbol clazz) {
            if (clazz == null) {
                return 0;
            }
            if (clazz.isPredeclaration()) {
                return 1;
            }
            return 2;
        }

        public boolean process(OCSymbol symbol) {
            OCSymbol definition;
            if (OCTypeResolveVisitor.this.myResolveIgnoreImports && symbol.isPredeclaration() && (definition = symbol.getDefinitionSymbol()) != null) {
                symbol = definition;
            }
            if (symbol instanceof OCClassSymbol) {
                OCClassSymbol aClass = (OCClassSymbol)symbol;
                if (aClass.getCategoryName() == null) {
                    if (aClass instanceof OCInterfaceSymbol && this.getInterfaceClassRank((OCInterfaceSymbol)aClass) > this.getInterfaceClassRank(this.myInterface)) {
                        this.myInterface = (OCInterfaceSymbol)aClass;
                        this.addUsedImport(symbol);
                    } else if (aClass instanceof OCImplementationSymbol) {
                        this.myImplementation = (OCImplementationSymbol)aClass;
                    }
                } else if (aClass instanceof OCInterfaceSymbol) {
                    this.myCategoryInterfaces.add((OCInterfaceSymbol)aClass);
                    if (!aClass.getProtocolNames().isEmpty()) {
                        this.addUsedImport(symbol);
                    }
                } else if (aClass instanceof OCImplementationSymbol) {
                    this.myCategoryImplementations.add((OCImplementationSymbol)aClass);
                }
            } else if (symbol instanceof OCDeclaratorSymbol || symbol instanceof OCCompatibilityAliasSymbol || symbol instanceof OCAliasUsingSymbol) {
                if (symbol.getKind().isTypedefOrAlias() && (this.isNullOrMagic(this.myAnswer) || this.myAnswer instanceof OCStructType)) {
                    OCType type = this.myType.getSubstitution().substitute(symbol.getType(), OCTypeResolveVisitor.this.myContext);
                    if ((type = type.cloneWithAddedCVQualifiers(this.myType.getCVQualifiers(), OCTypeResolveVisitor.this.myContext.getProject())).getName().startsWith("__builtin")) {
                        this.myAnswer = OCUnknownType.INSTANCE;
                    } else if (!(type instanceof OCReferenceType && OCTypeResolveVisitor.this.containsProcessingType(OCTypeResolveVisitor.this.getTypeKey(type)) || symbol.getContainingFile() == null || symbol.getProject() == null)) {
                        OCFile containingFile = symbol.getContainingOCFile();
                        if (containingFile != null) {
                            OCType inner = type.accept(OCTypeResolveVisitor.this);
                            inner = this.myType.getSubstitution().substitute(inner, OCTypeResolveVisitor.this.myContext);
                            if (inner instanceof OCStructType) {
                                for (OCStructSymbol innerStruct : ((OCStructType)inner).getStructs()) {
                                    this.storeStructSymbolInAnswer(innerStruct, ((OCStructType)inner).getTypedefName());
                                }
                                this.myAnswer = this.myAnswer.cloneWithAddedCVQualifiers(inner.getCVQualifiers(), symbol.getProject());
                            }
                            if (this.myAnswer == null || this.myAnswer instanceof OCTypeParameterType && !(inner instanceof OCTypeParameterType)) {
                                this.myAnswer = inner;
                            }
                            if (symbol instanceof OCSymbolWithQualifiedName) {
                                OCSymbolWithQualifiedName substitutedSymbol = (OCSymbolWithQualifiedName)OCTypeResolveVisitor.this.myContext.getSubstitution().substitute(symbol, OCTypeResolveVisitor.this.myContext);
                                substitutedSymbol = this.myType.getSubstitution().substitute(substitutedSymbol, OCTypeResolveVisitor.this.myContext);
                                OCQualifiedName qualifiedName = substitutedSymbol.getResolvedQualifiedName(true, OCTypeResolveVisitor.this.myContext, true, true, true, true, true);
                                if (qualifiedName != null) {
                                    String alias = qualifiedName.getCanonicalName(OCType.Presentation.FULL, false, OCTypeResolveVisitor.this.myContext, 0);
                                    alias = CVQualifiers.appendCVQualifiers(alias, this.myType, OCTypeResolveVisitor.this.myContext.getProject());
                                    this.myAnswer = this.myAnswer.equals((Object)OCIntType.BOOL, containingFile) && Comparing.equal((String)"BOOL", (String)alias) ? OCIntType.BOOL : this.myAnswer.cloneWithAliasName(alias);
                                }
                            }
                        }
                    } else {
                        this.myAnswer = OCUnknownType.INSTANCE;
                    }
                    this.addUsedImport(symbol);
                    if (this.myAnswer == null) {
                        this.myAnswer = type.cloneWithAliasName(this.myType.getCanonicalName(OCTypeResolveVisitor.this.myFile));
                    }
                    return true;
                }
            } else {
                if (symbol instanceof OCStructSymbol) {
                    if (this.myPreferableKind != null && this.myPreferableKind != symbol.getKind() || OCTypeResolveVisitor.this.myIsInOldC && this.myPreferableKind == null) {
                        return true;
                    }
                    this.addUsedImport(symbol);
                    this.storeStructSymbolInAnswer((OCStructSymbol)symbol, null);
                    return true;
                }
                if (symbol instanceof OCTypeParameterSymbol) {
                    TypeKey typeKey;
                    OCTypeArgument argument = this.myType.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    String aliasName = null;
                    if (argument == null) {
                        argument = OCTypeResolveVisitor.this.myContext.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    }
                    if (argument instanceof OCReferenceType || argument instanceof OCAutoType) {
                        OCType substituted = this.myType.getSubstitution().substitute((OCType)argument, OCTypeResolveVisitor.this.myContext);
                        this.myAnswer = substituted.accept(OCTypeResolveVisitor.this).cloneWithAliasName(this.myType.getCanonicalName(OCTypeResolveVisitor.this.myFile));
                        return true;
                    }
                    if (argument instanceof OCTypeParameterType && OCTypeResolveVisitor.this.addProcessingType(typeKey = OCTypeResolveVisitor.this.getTypeKey((OCType)argument))) {
                        boolean result = this.process((OCSymbol)((Object)((OCTypeParameterType)argument).getSymbol()));
                        OCTypeResolveVisitor.this.removeProcessingType(typeKey);
                        return result;
                    }
                    if (argument instanceof OCType) {
                        this.myAnswer = (OCType)argument;
                    } else if (this.myAnswer == null) {
                        this.myAnswer = symbol instanceof OCGenericParameterSymbol ? ((OCGenericParameterSymbol)symbol).getDefaultValue() : new OCTypeParameterType((OCTypeParameterSymbol)((Object)symbol));
                    }
                    if (aliasName != null) {
                        this.myAnswer = this.myAnswer.cloneWithAliasName(aliasName);
                    }
                } else if (symbol instanceof OCUsingSymbol) {
                    this.addUsedImport(symbol);
                    return ((OCUsingSymbol)symbol).getSymbolReference().processPossibleSymbols((Processor<OCSymbol>)this, OCTypeResolveVisitor.this.myFile);
                }
            }
            return true;
        }

        private boolean isNullOrMagic(@Nullable OCType type) {
            return type == null || type instanceof OCReferenceType || type instanceof OCTypeParameterType;
        }

        private void addUsedImport(@NotNull OCSymbol symbol) {
            ContainerUtil.addIfNotNull((Collection)OCTypeResolveVisitor.this.myUsedFiles, (Object)OCFileSymbols.getFileToImport(OCTypeResolveVisitor.this.myFile, symbol));
        }

        private void storeStructSymbolInAnswer(OCStructSymbol symbol, String typedefName) {
            List<OCTypeArgument> arguments;
            OCStructSymbol substitute = this.myType.getSubstitution().substitute(symbol, OCTypeResolveVisitor.this.myContext);
            OCQualifiedName qualifiedName = this.myType.getReference(OCTypeResolveVisitor.this.myFile).getQualifiedName();
            List<OCTypeArgument> list = arguments = qualifiedName instanceof OCQualifiedNameWithArguments ? ((OCQualifiedNameWithArguments)qualifiedName).getArguments() : null;
            if (this.myAnswer instanceof OCStructType) {
                List<OCStructSymbol> innerStructs = null;
                if (((OCStructType)this.myAnswer).isPredeclaration() && !symbol.isPredeclaration()) {
                    innerStructs = new ArrayList<OCStructSymbol>();
                    this.myAnswer = new OCStructType(innerStructs, typedefName, arguments);
                } else if (((OCStructType)this.myAnswer).isPredeclaration() == symbol.isPredeclaration() && !((OCStructType)this.myAnswer).getStructs().contains(substitute)) {
                    innerStructs = ((OCStructType)this.myAnswer).getStructs();
                }
                if (innerStructs != null) {
                    if (!innerStructs.isEmpty() && !Comparing.equal((String)((OCStructSymbol)innerStructs.get(0)).getName(), (String)substitute.getName())) {
                        this.myAnswer = OCUnknownType.INSTANCE;
                    }
                    innerStructs.add(substitute);
                }
            } else if (this.isNullOrMagic(this.myAnswer)) {
                ArrayList<OCStructSymbol> innerStructs = new ArrayList<OCStructSymbol>();
                innerStructs.add(substitute);
                this.myAnswer = new OCStructType(innerStructs, typedefName, arguments);
            }
        }

        public List<OCProtocolSymbol> getProtocols(boolean addDeclaredProtocols, boolean isTransitive) {
            ArrayDeque<String> queue = new ArrayDeque<String>(this.myType.getProtocolNames());
            if (addDeclaredProtocols) {
                if (this.myInterface != null) {
                    queue.addAll(this.myInterface.getProtocolNames());
                }
                for (OCInterfaceSymbol category : this.myCategoryInterfaces) {
                    queue.addAll(category.getProtocolNames());
                }
            }
            com.intellij.util.containers.HashSet processed2 = new com.intellij.util.containers.HashSet();
            ArrayList<OCProtocolSymbol> result = new ArrayList<OCProtocolSymbol>();
            while (!queue.isEmpty()) {
                String protocol = (String)queue.poll();
                if (processed2.contains(protocol)) continue;
                processed2.add(protocol);
                OCClassSymbol foundProtocol = null;
                for (OCSymbol symbol : OCSymbolReference.getGlobalReference(protocol, null).resolveToSymbols(OCTypeResolveVisitor.this.myFile)) {
                    if (!(symbol instanceof OCProtocolSymbol)) continue;
                    if (!symbol.isPredeclaration()) {
                        foundProtocol = (OCProtocolSymbol)symbol;
                        break;
                    }
                    foundProtocol = (OCProtocolSymbol)symbol;
                }
                if (foundProtocol == null) continue;
                result.add((OCProtocolSymbol)foundProtocol);
                if (!isTransitive) continue;
                queue.addAll(foundProtocol.getProtocolNames());
            }
            return result;
        }

        @Nullable
        public OCType getAnswer() {
            if (this.myAnswer != null) {
                return this.myAnswer;
            }
            if (this.myInterface != null || this.myImplementation != null || this.myType.getProtocolNames().size() > 0) {
                OCReferenceType superType;
                OCType resolved;
                OCObjectType resolvedSuper = null;
                if ((this.myInterface != null || this.myImplementation != null) && (resolved = OCTypeResolveVisitor.this.visitReferenceType(superType = this.myInterface != null ? this.myInterface.getSuperType() : this.myImplementation.getSuperType())) instanceof OCObjectType) {
                    resolvedSuper = (OCObjectType)resolved;
                }
                return new OCObjectType(this.myInterface, this.myImplementation, this.getProtocols(true, true), this.getProtocols(false, false), this.myCategoryInterfaces, this.myCategoryImplementations, resolvedSuper, false, false, this.myType.isKindof());
            }
            return null;
        }
    }

    public static class TypeKey {
        private OCType type;
        private OCTypeSubstitution substitution;
        private final boolean isInSFINAE;

        public TypeKey(OCType type, OCTypeSubstitution substitution, boolean isInSFINAE) {
            this.type = type;
            this.substitution = substitution;
            this.isInSFINAE = isInSFINAE;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeKey)) {
                return false;
            }
            TypeKey key = (TypeKey)obj;
            return DeepEqual.equalObjects(this.type, key.type) && DeepEqual.equalObjects(this.substitution, key.substitution) && this.isInSFINAE == key.isInSFINAE;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.substitution != null ? this.substitution.hashCode() : 0);
            result = 31 * result + (this.isInSFINAE ? 1 : 0);
            return result;
        }
    }

    private static class ResultInfo {
        final OCType resolvedType;
        final Collection<VirtualFile> usedFiles;
        final Set<OCTypeParameterSymbol> typeDependencies;

        private ResultInfo(OCType type, Collection<VirtualFile> files, Set<OCTypeParameterSymbol> typeDependencies) {
            this.resolvedType = type;
            this.usedFiles = files;
            this.typeDependencies = typeDependencies;
        }
    }
}

