/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class OCTypeParentSymbolSetter
extends OCTypeCloneVisitor {
    private OCSymbolWithQualifiedName mySymbol;

    public OCTypeParentSymbolSetter(OCSymbolWithQualifiedName symbol) {
        super(false);
        this.mySymbol = symbol;
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type) {
        OCQualifiedName qualifiedName = this.replaceQualifiedName(type.getReference().getQualifiedName());
        OCSymbolReference.GlobalReference ref = OCSymbolReference.getGlobalReference(qualifiedName, this.mySymbol, type.getReference().getFilter());
        OCReferenceTypeBuilder resultBuilder = new OCReferenceTypeBuilder(ref);
        resultBuilder.setProtocolSubstitutionARCFromType(type);
        resultBuilder.setConstVolatile(type);
        return resultBuilder.build();
    }

    @Nullable
    public OCQualifiedName replaceQualifiedName(OCQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        if (qualifiedName instanceof OCQualifiedNameWithArguments) {
            ArrayList<OCTypeArgument> list = new ArrayList<OCTypeArgument>();
            for (OCTypeArgument arg : ((OCQualifiedNameWithArguments)qualifiedName).getArguments()) {
                if (arg instanceof OCType) {
                    list.add(((OCType)arg).accept(this));
                    continue;
                }
                list.add(arg);
            }
            return new OCQualifiedNameWithArguments(this.replaceQualifiedName(qualifiedName.getQualifier()), qualifiedName.getName(), list);
        }
        OCQualifiedName qualifier = this.replaceQualifiedName(qualifiedName.getQualifier());
        if (qualifier == qualifiedName.getQualifier()) {
            return qualifiedName;
        }
        return OCQualifiedName.with(qualifier, qualifiedName.getName());
    }
}

