/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeNameVisitor
implements OCTypeVisitor<String> {
    private static final int MAX_STRUCT_PARAMETERS_IN_PRESENTATION = 5;
    public static final int MAX_TEMPLATE_DEPTH_IN_PRESENTATION = 10;
    private final OCType.Presentation myPresentation;
    private final boolean myAppendContextName;
    private final boolean myIncludeGlobalQualifier;
    private final boolean myAliased;
    private final boolean myIsInOldC;
    private final int myTemplateDepth;
    @Nullable
    private final OCResolveContext myContext;

    public static String getFunctionSignature(PsiElement context, OCFunctionType type, String signatureWithoutParams) {
        return new OCTypeNameVisitor(context).getFunctionSignature(type, signatureWithoutParams);
    }

    public static String getFunctionSignature(PsiElement context, OCFunctionType type, String signatureWithoutParams, boolean withNames, List<OCExpression> arguments) {
        return new OCTypeNameVisitor(context).getFunctionSignature(type, signatureWithoutParams, withNames, arguments);
    }

    public OCTypeNameVisitor(@Nullable PsiElement context) {
        this(OCType.Presentation.BEST, new OCResolveContext(context));
    }

    public OCTypeNameVisitor(OCType.Presentation presentation, @Nullable PsiElement context) {
        this(presentation, true, true, true, new OCResolveContext(context), 0);
    }

    public OCTypeNameVisitor(OCType.Presentation presentation, @NotNull OCResolveContext context) {
        this(presentation, true, true, true, context, 0);
    }

    public OCTypeNameVisitor(OCType.Presentation presentation, boolean aliased, boolean appendContextName, boolean includeGlobalQualifier, @Nullable PsiElement context) {
        this(presentation, aliased, appendContextName, includeGlobalQualifier, new OCResolveContext(context), 0);
    }

    public OCTypeNameVisitor(OCType.Presentation presentation, boolean aliased, boolean appendContextName, boolean includeGlobalQualifier, @NotNull OCResolveContext context, int templateDepth) {
        this.myPresentation = presentation;
        this.myAliased = aliased;
        this.myContext = context;
        this.myIsInOldC = OCCodeInsightUtil.isInPlainOldC(this.myContext.getElement());
        this.myAppendContextName = appendContextName;
        this.myIncludeGlobalQualifier = includeGlobalQualifier;
        this.myTemplateDepth = templateDepth;
    }

    @NotNull
    public String getName(OCType type) {
        String aliasName = type.getAliasName();
        if (this.myPresentation == OCType.Presentation.BEST) {
            String name = this.getShortestQualifiedName(type, this.myAliased ? aliasName : null);
            if (name != null) {
                return name;
            }
            return type.accept(this);
        }
        if (this.myAliased && aliasName != null) {
            return aliasName;
        }
        return type.accept(this);
    }

    @Nullable
    private String getShortestQualifiedName(OCType type, String qualifiedName) {
        String result;
        if (qualifiedName == null || this.myContext == null) {
            return null;
        }
        if ("instancetype".equals(qualifiedName)) {
            OCObjectType inheritorType;
            OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)this.myContext.getElement(), (boolean)false, (Class[])new Class[]{OCClassDeclaration.class});
            OCType terminalType = type.getTerminalType();
            OCObjectType oCObjectType = inheritorType = clazz != null ? clazz.getType() : null;
            if (inheritorType != null && terminalType instanceof OCObjectType && ((OCObjectType)terminalType).isAncestorOf(inheritorType)) {
                return qualifiedName;
            }
        }
        String qualifier = "const";
        if (qualifiedName.endsWith(" " + qualifier)) {
            qualifiedName = qualifiedName.substring(0, qualifiedName.length() - qualifier.length() - 1);
        } else {
            qualifier = "";
        }
        ArrayList<String> parts = new ArrayList<String>();
        OCTypeNameVisitor.splitToParts(qualifiedName, parts);
        Ref tagRef = new Ref((Object)"");
        parts.set(0, OCTypeNameVisitor.cutOffTag((String)parts.get(0), (Ref<String>)tagRef));
        if (((String)tagRef.get()).equals("const")) {
            qualifier = "const";
        }
        return (result = this.getShortestName(type, parts, 0, null)) != null ? OCTypeNameVisitor.addTypeQualifier(result, type, this.myContext.getProject(), qualifier) : null;
    }

    @Nullable
    private String getShortestName(OCType type, List<String> parts, int index, @Nullable OCQualifiedName candidate) {
        if (this.myContext == null) {
            return null;
        }
        if (parts.size() - 1 == index) {
            OCReferenceType candidateType = new OCReferenceTypeBuilder(OCTypeNameVisitor.removeArguments(candidate = OCTypeNameVisitor.appendPart(candidate, parts.get(index))), this.myContext.getElement()).build();
            if (type.equalsAfterResolving(candidateType, this.myContext, true, true)) {
                return candidate.getCanonicalName(true);
            }
            return null;
        }
        if (parts.get(index).isEmpty()) {
            return this.getShortestName(type, parts, index + 1, candidate);
        }
        String shortName = this.getShortestName(type, parts, index + 1, candidate);
        if (shortName != null) {
            return shortName;
        }
        return this.getShortestName(type, parts, index + 1, OCTypeNameVisitor.appendPart(candidate, parts.get(index)));
    }

    private static String appendIsKindof(boolean isKindof, String typeString) {
        if (!isKindof || typeString.startsWith("__kindof ")) {
            return typeString;
        }
        return "__kindof " + typeString;
    }

    private String appendCVQualifiers(OCType type, String typeString) {
        return CVQualifiers.appendCVQualifiers(typeString, type, this.myContext != null ? this.myContext.getProject() : null);
    }

    @NotNull
    public static String addTypeQualifier(@NotNull String typeString, @NotNull OCType type, @Nullable Project project2, @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        if (qualifier.isEmpty()) {
            return typeString;
        }
        OCCodeStyleSettings oCCodeStyleSettings = settings = project2 != null ? (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || type instanceof OCFunctionType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            return typeString.endsWith(" " + qualifier) ? typeString : typeString + " " + qualifier;
        }
        return typeString.startsWith(qualifier + " ") ? typeString : qualifier + " " + typeString;
    }

    @NotNull
    public static String removeTypeQualifier(@NotNull String typeString, @NotNull OCType type, @Nullable Project project2, @NotNull String qualifier) {
        OCCodeStyleSettings settings;
        OCCodeStyleSettings oCCodeStyleSettings = settings = project2 != null ? (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class) : null;
        if (type instanceof OCPointerType || settings != null && settings.TYPE_QUALIFIERS_PLACEMENT == OCCodeStyleSettings.Placement.AFTER) {
            return typeString.endsWith(" " + qualifier) ? typeString.substring(0, typeString.length() - qualifier.length() - 1) : typeString;
        }
        return typeString.startsWith(qualifier + " ") ? typeString.substring(qualifier.length() + 1) : typeString;
    }

    private static OCQualifiedName appendPart(OCQualifiedName candidate, String part) {
        return candidate == null ? OCQualifiedName.interned(part) : OCQualifiedName.interned(candidate, part);
    }

    private static OCQualifiedName removeArguments(OCQualifiedName qualifiedName) {
        OCQualifiedName qualifier = qualifiedName.getQualifier() != null ? OCTypeNameVisitor.removeArguments(qualifiedName.getQualifier()) : null;
        String name = qualifiedName.getName();
        int pos = name != null ? name.indexOf(60) : -1;
        name = pos != -1 ? name.substring(0, pos) : name;
        return qualifier != null ? OCQualifiedName.interned(qualifier, name) : OCQualifiedName.interned(name);
    }

    private static String cutOffTag(String name, Ref<String> tag) {
        int index;
        for (index = 0; index < name.length() && Character.isLetter(name.charAt(index)); ++index) {
        }
        if (index < name.length() && name.charAt(index) == ' ') {
            String[] parts = name.split(" ");
            tag.set((Object)parts[0]);
            return parts.length > 1 ? parts[1] : "";
        }
        return name;
    }

    private static void splitToParts(String name, List<String> parts) {
        int balance = 0;
        int partStartPos = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '<') {
                ++balance;
                continue;
            }
            if (c == '>') {
                --balance;
                continue;
            }
            if (balance != 0 || c != ':' || i + 1 >= name.length() || name.charAt(i + 1) != ':') continue;
            parts.add(name.substring(partStartPos, i));
            partStartPos = i + 2;
        }
        if (partStartPos < name.length()) {
            parts.add(name.substring(partStartPos, name.length()));
        }
    }

    @Override
    public String visitEllipsisReferenceType(OCEllipsisType type) {
        return "...";
    }

    @Override
    public String visitFunctionType(OCFunctionType type) {
        String name = this.getName(type.getReturnType());
        if (this.myPresentation == OCType.Presentation.BEST) {
            return this.getFunctionSignature(type, name, false, null);
        }
        return this.getFunctionSignature(type, name);
    }

    private String getFunctionSignature(OCFunctionType type, String signatureWithoutParams) {
        StringBuilder builder = new StringBuilder(signatureWithoutParams);
        builder.append('(');
        builder.append(StringUtil.join(type.getParameterTypes(true), (Function)new Function<OCType, String>(){

            public String fun(OCType argumentType) {
                return OCTypeNameVisitor.this.getName(argumentType);
            }
        }, (String)","));
        builder.append(')');
        return this.appendCVQualifiers(type, builder.toString());
    }

    private String getFunctionSignature(OCFunctionType type, String signatureWithoutParams, boolean withNames, @Nullable List<OCExpression> arguments) {
        if (this.myContext == null) {
            return null;
        }
        HashSet<String> createdNames = new HashSet<String>();
        StringBuilder builder = new StringBuilder(signatureWithoutParams);
        builder.append('(');
        List<OCType> types = type.getParameterTypes(true);
        List<String> argumentNames = type.getParameterNames(true);
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            OCType argumentType = types.get(i);
            if (i > 0) {
                builder.append(',');
            }
            if (withNames) {
                String paramName;
                String string = paramName = argumentNames != null ? argumentNames.get(i) : "";
                if (paramName.isEmpty() && !argumentType.isVoid()) {
                    paramName = OCNameSuggester.suggestForParameter(createdNames, argumentType, arguments != null && i < arguments.size() ? arguments.get(i) : null);
                }
                createdNames.add(paramName);
                builder.append(OCElementFactory.declarationText(paramName, argumentType, this.myContext.getElement()));
                continue;
            }
            builder.append(this.getName(argumentType));
        }
        builder.append(')');
        return this.appendCVQualifiers(type, builder.toString());
    }

    @Override
    public String visitMagicType(OCMagicType type) {
        String magicName = type.getMagicName();
        PsiFile file2 = this.myContext != null ? this.myContext.getFile() : null;
        return file2 instanceof OCFile && "<unknown>".equals(magicName) && ((OCFile)file2).getKind().isObjC() ? "id" : magicName;
    }

    @Override
    public String visitObjectType(OCObjectType type) {
        boolean isGeneric;
        List<OCProtocolSymbol> protocols = type.getAugmentedProtocols();
        OCInterfaceSymbol interfaceSymbol = type.getInterface();
        boolean bl = isGeneric = interfaceSymbol != null && !interfaceSymbol.getGenericParameters().isEmpty() && interfaceSymbol.getSubstitution() != OCTypeSubstitution.ID;
        if (protocols.isEmpty() && !isGeneric) {
            return OCTypeNameVisitor.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, type.getClassName()));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(isGeneric ? this.getSubstitutedTypeName(type.getClassName(), interfaceSymbol) : type.getClassName());
        if (!protocols.isEmpty()) {
            builder.append('<');
            builder.append(StringUtil.join(protocols, OCSymbol::getName, (String)", "));
            builder.append('>');
        }
        return OCTypeNameVisitor.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder.toString()));
    }

    @Override
    public String visitArrayType(OCArrayType type) {
        return this.getArrayTypeName(type, null);
    }

    @NotNull
    private String getArrayTypeName(OCArrayType type, @Nullable String modifier) {
        StringBuilder builder = new StringBuilder();
        OCType current = type;
        while (current instanceof OCArrayType) {
            OCArrayType arrayType = current;
            int length = arrayType.getLength();
            builder.append("[");
            if (arrayType.hasLength()) {
                builder.append(length);
            }
            builder.append("]");
            current = arrayType.getRefType();
        }
        if (modifier != null) {
            builder.insert(0, modifier);
        }
        builder.insert(0, this.getName(current));
        return builder.toString();
    }

    @Override
    public String visitPointerType(OCPointerType type) {
        if (type.getTerminalType() instanceof OCFunctionType) {
            OCFunctionType ft = (OCFunctionType)type.getTerminalType();
            StringBuilder builder = new StringBuilder();
            builder.append(ft.getReturnType().getName()).append(" (");
            StringBuilder asteriskBuilder = new StringBuilder();
            if (type.getClassQualifier() != null) {
                builder.append(this.getName(type.getClassQualifier())).append("::");
            }
            OCType cur = type;
            while (cur instanceof OCPointerType) {
                asteriskBuilder.append(cur instanceof OCBlockPointerType ? (char)'^' : '*');
                cur = cur.getRefType();
            }
            for (int i = asteriskBuilder.length() - 1; i >= 0; --i) {
                builder.append(asteriskBuilder.charAt(i));
            }
            builder.append(')');
            String signature = this.getFunctionSignature(ft, builder.toString());
            return this.appendCVQualifiers(type, signature);
        }
        String refCanonical = (type.getARCAttribute() != null ? type.getARCAttribute().getTokenName() + " " : "") + this.getName(type.getRefType());
        if (type instanceof OCBlockPointerType) {
            return "invalid_block_pointer: ^(" + refCanonical + ")";
        }
        if (type.getRefType() instanceof OCIdType) {
            return refCanonical;
        }
        String suffix = "*";
        if (type.getClassQualifier() != null) {
            suffix = type.getClassQualifier().getName() + "::" + suffix;
        }
        return this.appendCVQualifiers(type, refCanonical + " " + suffix);
    }

    @Override
    public String visitBlockPointerType(OCBlockPointerType type) {
        return this.visitPointerType(type);
    }

    @Override
    public String visitCppReferenceType(OCCppReferenceType type) {
        String modifier;
        String string = modifier = type.isRvalueRef() ? "&&" : "&";
        if (type.getTerminalType() instanceof OCFunctionType) {
            OCFunctionType ft = (OCFunctionType)type.getTerminalType();
            return this.getFunctionSignature(ft, this.getName(ft.getReturnType()) + " (" + modifier + ")");
        }
        if (type.getRefType() instanceof OCArrayType) {
            return this.getArrayTypeName((OCArrayType)type.getRefType(), " (" + modifier + ")");
        }
        String refCanonical = this.getName(type.getRefType());
        if (type.getRefType() instanceof OCIdType) {
            return refCanonical;
        }
        return this.appendCVQualifiers(type, refCanonical + " " + modifier);
    }

    @Override
    public String visitIdType(OCIdType type) {
        return this.visitObjectType(type);
    }

    @Override
    public String visitIntType(OCIntType type) {
        return this.appendCVQualifiers(type, type.getText());
    }

    @Override
    public String visitRealType(OCRealType type) {
        String result;
        PsiFile file2;
        PsiFile psiFile = file2 = this.myContext != null ? this.myContext.getFile() : null;
        if (file2 instanceof OCFile && type.isComplex()) {
            result = type.getText() + " _Complex";
            OCNamespaceLikeSymbol symbols = OCFileGlobalSymbolsCache.getInstance(file2.getProject()).lightTableForFile((OCFile)file2);
            if (!symbols.processMembers("complex", new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    return !(symbol instanceof OCMacroSymbol);
                }
            })) {
                result = "complex " + type.getText();
            }
        } else {
            result = type.getText();
        }
        return this.appendCVQualifiers(type, result);
    }

    @Override
    public String visitReferenceType(OCReferenceType type) {
        OCSymbolReference reference = type.getReference();
        OCQualifiedName qualifiedName = reference.getQualifiedName();
        String name = null;
        if (this.myContext != null) {
            String qualifiedNameString = qualifiedName.getName();
            boolean hasTypeToken = OCSymbolReference.removeTypeToken((String)qualifiedNameString).typeToken != null;
            name = this.myPresentation == OCType.Presentation.BEST && qualifiedNameString != null && hasTypeToken ? qualifiedNameString : qualifiedName.getCanonicalName(this.myPresentation, true, this.myContext, this.myTemplateDepth);
        }
        if (type.getProtocolNames().isEmpty()) {
            return name != null ? OCTypeNameVisitor.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, name)) : "<unnamed>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(name).append('<');
        StringUtil.join(type.getProtocolNames(), (String)", ", (StringBuilder)builder);
        builder.append('>');
        return OCTypeNameVisitor.appendIsKindof(type.isKindof(), this.appendCVQualifiers(type, builder.toString()));
    }

    @Override
    public String visitStructType(OCStructType type) {
        String baseName;
        OCStructSymbol symbol = type.getStructs().get(0);
        boolean addKind = this.myIsInOldC && !symbol.isUnnamed();
        boolean specializationAdded = false;
        if (this.myContext != null && this.myPresentation == OCType.Presentation.BEST) {
            String canonicalName;
            String name = this.getShortestQualifiedName(type, type.getAliasName());
            if (name != null) {
                return name;
            }
            OCQualifiedName resolvedName = symbol.getResolvedQualifiedName(this.myContext);
            if (!symbol.isUnnamed() && resolvedName != null) {
                canonicalName = resolvedName.getCanonicalName(this.myPresentation, true, this.myContext, this.myTemplateDepth);
            } else {
                canonicalName = type.getCanonicalName(this.myContext.getElement());
                addKind = false;
            }
            specializationAdded = true;
            name = this.getShortestQualifiedName(type, canonicalName);
            baseName = name != null ? name : (canonicalName.startsWith("::") ? canonicalName.substring(2) : canonicalName);
        } else {
            String shortName;
            String string = type.getTypedefName() != null ? type.getTypedefName() : (shortName = symbol.isUnnamed() ? "anonymous " + symbol.getKind().getNameLowercase() : symbol.getName());
            if (this.myPresentation == OCType.Presentation.FULL && this.myContext != null) {
                OCQualifiedName resolvedName = symbol.getResolvedQualifiedName(this.myContext);
                if (this.myIsInOldC && resolvedName != null) {
                    resolvedName = resolvedName.dropSuperQualifier();
                }
                OCQualifiedName qualifiedName = resolvedName != null ? resolvedName.changeName(shortName) : symbol.getQualifiedName();
                return OCTypeNameVisitor.getNameWithKind(symbol, qualifiedName.getCanonicalName(this.myPresentation, this.myIncludeGlobalQualifier, this.myContext, this.myTemplateDepth), addKind);
            }
            baseName = shortName;
        }
        OCTypeSubstitution substitution = symbol.getSubstitution();
        if (!specializationAdded && (substitution != OCTypeSubstitution.ID || symbol.isSpecialization())) {
            return this.appendCVQualifiers(type, OCTypeNameVisitor.getNameWithKind(symbol, this.getSubstitutedTypeName(baseName, symbol), false));
        }
        return this.appendCVQualifiers(type, OCTypeNameVisitor.getNameWithKind(symbol, baseName, addKind));
    }

    private static String getNameWithKind(OCStructSymbol symbol, String baseName, boolean addKind) {
        return addKind ? symbol.getKind().getNameLowercase() + " " + baseName : baseName;
    }

    private String getSubstitutedTypeName(String baseName, OCTemplateSymbol<? extends PsiElement> symbol) {
        if (this.myContext == null) {
            return null;
        }
        List<OCTypeArgument> arguments = OCTypeNameVisitor.getTypeArguments(this.myPresentation, symbol, this.myPresentation != OCType.Presentation.SHORT, true, true, this.myContext);
        StringBuilder builder = new StringBuilder(baseName);
        if (arguments.size() > 0) {
            builder.append('<');
            if (this.myTemplateDepth < 10) {
                for (int j = 0; j < arguments.size(); ++j) {
                    if (j > 5) {
                        builder.append("...");
                        break;
                    }
                    if (j != 0) {
                        builder.append(", ");
                    }
                    OCTypeArgument argument = arguments.get(j);
                    if (symbol.isSpecialization() && argument != null) {
                        builder.append(argument.getNameForPresentation(this.myPresentation, this.myContext, this.myIncludeGlobalQualifier, this.myTemplateDepth + 1));
                        continue;
                    }
                    if (argument instanceof OCType) {
                        builder.append(this.getName((OCType)argument));
                        continue;
                    }
                    if (argument != null) {
                        builder.append(argument.getNameForPresentation(this.myPresentation, this.myContext, this.myIncludeGlobalQualifier, this.myTemplateDepth + 1));
                        continue;
                    }
                    builder.append(symbol.getTemplateParameters().get(j).getName());
                }
            } else {
                builder.append("...");
            }
            builder.append(">");
        }
        return builder.toString();
    }

    @NotNull
    public static List<OCTypeArgument> getTypeArguments(OCType.Presentation presentation, OCTemplateSymbol<?> symbol, boolean resolveArguments, boolean appendNullArguments, boolean removeDefaultArguments, @NotNull OCResolveContext context) {
        ArrayList<OCTypeArgument> arguments;
        block6: {
            OCTypeArgument typeArgument;
            OCTypeSubstitution substitution;
            block7: {
                substitution = symbol.getSubstitution();
                if (resolveArguments) {
                    context = context.substituteFirst(substitution);
                }
                arguments = new ArrayList<OCTypeArgument>();
                List<OCTypeArgument> specialization = symbol.getTemplateSpecialization();
                if (specialization == null) break block7;
                for (OCTypeArgument argument : specialization) {
                    if (resolveArguments && argument instanceof OCType) {
                        arguments.add(((OCType)argument).resolve(context));
                        continue;
                    }
                    arguments.add(argument);
                }
                break block6;
            }
            for (OCTypeParameterSymbol argument : symbol.getTemplateParameters()) {
                typeArgument = substitution.getSubstitutionFor(argument);
                if (typeArgument == null && !appendNullArguments) continue;
                arguments.add(typeArgument);
            }
            if (!removeDefaultArguments) break block6;
            for (int i = arguments.size() - 1; i >= 0; --i) {
                OCTypeParameterSymbol argument;
                argument = symbol.getTemplateParameters().get(i);
                typeArgument = (OCTypeArgument)arguments.get(i);
                if (presentation == OCType.Presentation.SHORT || !(typeArgument instanceof OCType) || !(argument.getDefaultValue() instanceof OCType)) continue;
                OCType defValue = substitution.substitute((OCType)argument.getDefaultValue(), context).resolve(context);
                OCTypeEqualityAfterResolvingVisitor eq = new OCTypeEqualityAfterResolvingVisitor(defValue, true, context);
                if (((OCType)typeArgument).accept(eq).booleanValue()) {
                    arguments.remove(i);
                    continue;
                }
                break;
            }
        }
        return arguments;
    }

    @Override
    public String visitUnknownType(OCUnknownType type) {
        return this.visitMagicType(type);
    }

    @Override
    public String visitVoidType(OCVoidType type) {
        return this.appendCVQualifiers(type, "void");
    }

    @Override
    public String visitTypeParameterType(OCTypeParameterType type) {
        return this.appendCVQualifiers(type, type.getSymbol().getName());
    }

    @Override
    public String visitAutoType(OCAutoType type) {
        return "auto";
    }

    @Override
    public String visitVariadicType(OCVariadicType type) {
        return this.getName(type.getUnderlyingType()) + "...";
    }

    @Override
    public String visitExpansionPackType(OCExpansionPackType type) {
        return StringUtil.join((Collection)ContainerUtil.map(type.getExpansions(), (Function)new Function<OCTypeArgument, String>(){

            public String fun(OCTypeArgument typeArgument) {
                return typeArgument.getNameForPresentation(OCTypeNameVisitor.this.myPresentation, OCTypeNameVisitor.this.myContext, OCTypeNameVisitor.this.myIncludeGlobalQualifier, OCTypeNameVisitor.this.myTemplateDepth);
            }
        }), (String)", ");
    }
}

