/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCSetSuperclassIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCStructType
extends OCTypeCompatibilityVisitor<OCStructType> {
    protected OCTypeCompatibilityVisitor_OCStructType(@NotNull OCStructType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(final OCFunctionType type) {
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myContext, false)) {
            String message = "Taking pointer from integer without a cast";
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
        }
        if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM && !((OCStructType)this.mySourceType).isEnumClass()) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Taking integer from enum type '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, false)) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.visitType(type);
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(final OCPointerType type) {
        OCType.TypeCheckResult result;
        OCType lTerminalType = type.getTerminalType();
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, false) && !lTerminalType.isUnknown() && type.isPointerToPointerToObjectCompatible() ^ ((OCStructType)this.mySourceType).isPointerToPointerToObjectCompatible() && OCCompilerHelper.isArcEnabled(this.myContext.getContainingFile()) && (result = this.checkArcBridgeCast(type, false)) != null) {
            return result;
        }
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myContext, false)) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
        }
        if (type.isPointerToVoid() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, this.myAllowImplicitConversions) && !isCpp) {
            return OK_RESULT;
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, false)) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.visitType(type);
    }

    @Override
    protected OCType.TypeCheckResult checkRefType(OCCppReferenceType type) {
        OCType.TypeCheckResult result = super.checkRefType(type);
        if (this.myContext instanceof OCCastExpression && result.getState().isError(this.myContext) && this.isCppClassType(type.getTerminalType()) && ((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT) {
            result.setState(OCType.TypeCheckState.WARNING);
        }
        return result;
    }

    @Override
    public OCType.TypeCheckResult visitStructType(final OCStructType type) {
        OCFunctionDefinition declaringFun;
        if (new OCTypeEqualityVisitor(this.mySourceType, false, false, true, this.myAssumeNullSubstitutionsEquals, true, true, true, this.myResolveContext).equal(type) && (!((OCStructType)this.mySourceType).isVolatile() || type.isVolatile())) {
            return OK_RESULT;
        }
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type)) {
            return OK_RESULT;
        }
        if (type.getKind() == OCSymbolKind.ENUM) {
            if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleEnums.class, "warn_impcast_different_enum_types", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Incompatible enum types '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                    }
                };
            }
            Object message = null;
            if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myContext, false)) {
                message = new Computable<String>(){

                    public String compute() {
                        return "Taking enum type '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "' from integer";
                    }
                };
            } else if (!type.isEnumClass() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, false)) {
                message = new Computable<String>(){

                    public String compute() {
                        return "Taking enum type '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "' from pointer";
                    }
                };
            }
            if (message != null) {
                return this.checkAssignToEnum(type, (Computable<String>)message);
            }
        }
        OCFunctionSymbol declaringSymbol = (declaringFun = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, OCFunctionDefinition.class)) != null ? declaringFun.getSymbol() : null;
        boolean isFunctionReturnTypeContext = this.myContext.getParent() instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)this.myContext.getParent()).getReturnTypeElement() == this.myContext;
        for (final OCStructSymbol struct : type.getStructs()) {
            OCType.TypeCheckResult result = this.processTransparentUnion(struct, type);
            if (result != null) {
                return result;
            }
            if (this.myAllowImplicitConversions) {
                result = this.processConstructors(struct);
            }
            if (((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT && this.isCppClassType(type)) {
                boolean isInsideClass = declaringSymbol != null && declaringSymbol.getResolvedOwner() instanceof OCStructSymbol && struct.isAncestor((OCStructSymbol)declaringSymbol.getResolvedOwner());
                for (final OCStructSymbol symbol : ((OCStructType)this.mySourceType).getStructs()) {
                    final Ref visibilityRef = new Ref();
                    if (!symbol.processAllBaseClasses(new OCResolveContext((PsiElement)this.myContext.getContainingFile()), new OCStructSymbol.BaseClassProcessor(){

                        @Override
                        public boolean process(OCSymbol baseSymbol, OCVisibility visibility) {
                            if (baseSymbol instanceof OCStructSymbol && ((OCStructSymbol)baseSymbol).resolvedNamesEqual(struct) || baseSymbol instanceof OCTypeParameterSymbol) {
                                visibilityRef.set((Object)visibility);
                                return false;
                            }
                            return true;
                        }
                    }, isInsideClass)) {
                        if (!isFunctionReturnTypeContext && (!isInsideClass && visibilityRef.get() != OCVisibility.PUBLIC || visibilityRef.get() == OCVisibility.PRIVATE)) {
                            if (result == null) {
                                result = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.MemberVisibility.class, "err_typecheck_convert_incompatible", new IntentionAction[]{new OCSetSuperclassIntentionAction(symbol, struct, OCVisibility.PUBLIC), this.getNewConstructorFix(struct)}){

                                    @Override
                                    public String getMessage() {
                                        return struct.getKindUppercase() + " '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "'" + " is a " + visibilityRef.toString() + " base class of " + symbol.getKindLowercase() + " '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                                    }
                                };
                            }
                        } else {
                            return OK_RESULT;
                        }
                    }
                    if (result != null) continue;
                    result = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.NotSuperclass.class, "err_ovl_no_viable_oper", new IntentionAction[]{new OCSetSuperclassIntentionAction(symbol, struct, OCVisibility.PUBLIC), this.getNewConstructorFix(struct)}){

                        @Override
                        public String getMessage() {
                            return symbol.getKindUppercase() + " '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "' is not compatible with " + struct.getKindLowercase() + " '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "'";
                        }
                    };
                }
            }
            if (result == null) continue;
            return result;
        }
        OCType.TypeCheckResult result = this.visitType(type);
        if (result != OK_RESULT && this.isCppClassType(type)) {
            result.setQuickFixes(new IntentionAction[]{this.getNewConstructorFix(type.getSymbol())});
        }
        return result;
    }
}

