/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCPointerType
extends OCTypeCompatibilityVisitor<OCPointerType> {
    protected OCTypeCompatibilityVisitor_OCPointerType(@NotNull OCPointerType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(final OCFunctionType type) {
        if (((OCPointerType)this.mySourceType).getRefType() instanceof OCVoidType) {
            return OK_RESULT;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCPointerType.this.myContext) + "' and '" + OCTypeCompatibilityVisitor_OCPointerType.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCType.TypeCheckResult visitArrayType(OCArrayType type) {
        OCType.TypeCheckResult result = this.checkAssignPointerToArray(type);
        return result != null ? result : super.visitArrayType(type);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(final OCPointerType type) {
        OCType lTerminalType = type.getTerminalType();
        OCType rTerminalType = ((OCPointerType)this.mySourceType).getTerminalType();
        int lPointersDepth = type.pointersDepth();
        int rPointersDepth = ((OCPointerType)this.mySourceType).pointersDepth();
        OCType.TypeCheckResult error = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCPointerType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCPointerType.this.getSourceTypeName() + "'";
            }
        };
        if (type.getClassQualifier() != null && ((OCPointerType)this.mySourceType).getClassQualifier() != null ? !((OCPointerType)this.mySourceType).getClassQualifier().isCompatible(type.getClassQualifier(), this.myContext) : type.getClassQualifier() != null && !(type.getClassQualifier() instanceof OCMagicType) || ((OCPointerType)this.mySourceType).getClassQualifier() != null && !(((OCPointerType)this.mySourceType).getClassQualifier() instanceof OCMagicType)) {
            return error;
        }
        if (!(lTerminalType.isUnknown() || rTerminalType.isUnknown() || lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType || !(type.isPointerToPointerToObjectCompatible() ^ ((OCPointerType)this.mySourceType).isPointerToPointerToObjectCompatible()))) {
            boolean isTollFreeBridge = OCTollFreeBridges.isCompatible(type, this.mySourceType);
            if (OCCompilerHelper.isArcEnabled(this.myContext.getContainingFile())) {
                OCType.TypeCheckResult result = this.checkArcBridgeCast(type, isTollFreeBridge);
                if (result != null) {
                    return result;
                }
            } else if (isTollFreeBridge) {
                return OK_RESULT;
            }
        }
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        OCType.TypeCheckResult checkResult = type.validateConstPointers(this.mySourceType, this.myContext);
        if (checkResult.getState() != OCType.TypeCheckState.ERROR) {
            return checkResult;
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && type.getRefType().isCompatible(((OCPointerType)this.mySourceType).getRefType(), this.myContext)) {
            return OK_RESULT;
        }
        if (type.isPointerToVoid() && !isCpp) {
            return OK_RESULT;
        }
        if (((OCPointerType)this.mySourceType).isPointerToVoid() && !isCpp) {
            return OK_RESULT;
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && lPointersDepth == rPointersDepth) {
            return type.getRefType().checkCompatible(((OCPointerType)this.mySourceType).getRefType(), this.mySource, this.myContext);
        }
        if (lTerminalType instanceof OCMagicType) {
            return OK_RESULT;
        }
        if (this.isCppClassType(lTerminalType) && this.isCppClassType(rTerminalType) && lPointersDepth == rPointersDepth) {
            OCType.TypeCheckResult result = type.getRefType().checkCompatible(((OCPointerType)this.mySourceType).getRefType(), this.mySource, this.myContext);
            if ((!isCpp || this.myContext instanceof OCCastExpression) && result.getState().isError(this.myContext)) {
                result.setState(OCType.TypeCheckState.WARNING);
            }
            return result;
        }
        if (lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType && lPointersDepth == rPointersDepth && (type instanceof OCBlockPointerType || !(this.mySourceType instanceof OCBlockPointerType))) {
            return type.getRefType().checkCompatible(((OCPointerType)this.mySourceType).getRefType(), this.mySource, this.myContext);
        }
        if (type.getRefType() instanceof OCIdType && ((OCIdType)type.getRefType()).getAllProtocols().isEmpty() && ((OCPointerType)this.mySourceType).isPointerToObjectCompatible() || type.isPointerToObjectCompatible() && ((OCPointerType)this.mySourceType).isPointerToID() && ((OCPointerType)this.mySourceType).getTerminalType() instanceof OCObjectType && ((OCObjectType)((OCPointerType)this.mySourceType).getTerminalType()).getAllProtocols().isEmpty()) {
            return OK_RESULT;
        }
        if ((lTerminalType instanceof OCReferenceType || rTerminalType instanceof OCReferenceType) && type.getCanonicalName(this.myContext).equals(((OCPointerType)this.mySourceType).getCanonicalName(this.myContext))) {
            return OK_RESULT;
        }
        if (checkResult.getState() == OCType.TypeCheckState.ERROR_IF_CPP) {
            return checkResult;
        }
        return error;
    }

    @Override
    public OCType.TypeCheckResult visitStructType(final OCStructType type) {
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type)) {
            return OK_RESULT;
        }
        if (type.getKind() == OCSymbolKind.ENUM && !type.isEnumClass()) {
            Computable<String> message = new Computable<String>(){

                public String compute() {
                    return "Taking enum type '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCPointerType.this.myContext) + "' from pointer";
                }
            };
            return this.checkAssignToEnum(type, message);
        }
        return this.checkStructCompatibleCtor(type);
    }
}

