/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeCloneVisitor
implements OCTypeVisitor<OCType> {
    private final boolean isShallow;
    @Nullable
    private final OCType myRootType;
    private final Boolean myForcedConst;
    private final Boolean myForcedVolatile;
    private int myDepth;

    public OCTypeCloneVisitor(boolean shallow) {
        this(shallow, null, null, null);
    }

    public OCTypeCloneVisitor(boolean shallow, @Nullable OCType rootType, @Nullable Boolean forcedConstValue, @Nullable Boolean forcedVolatileValue) {
        this.isShallow = shallow;
        this.myRootType = rootType;
        this.myForcedConst = forcedConstValue;
        this.myForcedVolatile = forcedVolatileValue;
    }

    private OCType cloneKid(OCType kid) {
        if (this.isShallow || this.myDepth >= 256) {
            return kid;
        }
        ++this.myDepth;
        OCType result = kid.transformType(this);
        --this.myDepth;
        return result;
    }

    private boolean isConstCopy(@NotNull OCType original) {
        boolean allowedToForceConst;
        boolean bl = allowedToForceConst = this.myRootType != null && this.myRootType.getArrayElementType() == original.getArrayElementType();
        if (allowedToForceConst && this.myForcedConst != null) {
            return this.myForcedConst;
        }
        return original.isConst();
    }

    private boolean isVolatileCopy(@NotNull OCType original) {
        return this.myForcedVolatile != null ? this.myForcedVolatile.booleanValue() : original.isVolatile();
    }

    @Override
    public OCType visitEllipsisReferenceType(OCEllipsisType type) {
        return OCEllipsisType.instance();
    }

    @Override
    public OCType visitFunctionType(OCFunctionType type) {
        List<OCType> oldParamTypes = type.getParameterTypes(true);
        List<String> oldParamNames = type.getParameterNames(true);
        ArrayList<OCType> clonedArgs = new ArrayList<OCType>(oldParamTypes.size());
        for (OCType argumentType : oldParamTypes) {
            clonedArgs.add(this.cloneKid(argumentType));
        }
        ArrayList<String> clonedNames = oldParamNames != null ? new ArrayList<String>(oldParamNames) : null;
        return new OCFunctionType(this.cloneKid(type.getReturnType()), clonedArgs, clonedNames, this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitMagicType(OCMagicType type) {
        return new OCMagicType(type.getName(), type.getGuessedType(), false, false);
    }

    @Override
    public OCType visitObjectType(OCObjectType type) {
        return new OCObjectType(type.getInterface(), type.getImplementation(), type.getAllProtocols(), type.getAugmentedProtocols(), type.getCategoryInterfaces(), type.getCategoryImplementations(), type.getSuperType(), this.isConstCopy(type), this.isVolatileCopy(type), type.isKindof());
    }

    @Override
    public OCType visitArrayType(OCArrayType type) {
        OCType forcedClone = type.getRefType().transformType(this);
        return OCArrayType.to(forcedClone, type.getLength(), type.getARCAttribute());
    }

    @Override
    public OCType visitPointerType(OCPointerType type) {
        OCType qualifier = type.getClassQualifier() != null ? this.cloneKid(type.getClassQualifier()) : null;
        OCPointerType clone = OCPointerType.to(this.cloneKid(type.getRefType()), type.getARCAttribute(), qualifier, this.isConstCopy(type), this.isVolatileCopy(type));
        clone.setLengthInBrackets(type.getLengthInBrackets());
        return clone;
    }

    @Override
    public OCType visitBlockPointerType(OCBlockPointerType type) {
        return OCBlockPointerType.blockPtr(this.cloneKid(type.getRefType()), type.getARCAttribute(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitCppReferenceType(OCCppReferenceType type) {
        OCType inner = this.cloneKid(type.getRefType());
        boolean isConst = this.isConstCopy(type);
        boolean isVolatile = this.isVolatileCopy(type);
        return type.isRvalueRef() ? OCCppReferenceType.to(inner, true, isConst, isVolatile) : OCCppReferenceType.to(inner, false, isConst, isVolatile);
    }

    @Override
    public OCType visitIdType(OCIdType type) {
        return new OCIdType(type.getAllProtocols(), type.getAugmentedProtocols(), type.getProject(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitIntType(OCIntType type) {
        return type.cloneType(this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitRealType(OCRealType type) {
        return type.cloneType(this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type) {
        OCReferenceTypeBuilder resultBuilder = new OCReferenceTypeBuilder(type.getReference());
        resultBuilder.setProtocolSubstitutionARCFromType(type);
        resultBuilder.setConstVolatile(this.isConstCopy(type), this.isVolatileCopy(type));
        resultBuilder.setFunctionParameterType(type.isFunctionParameterType());
        resultBuilder.setIsKindof(type.isKindof());
        return resultBuilder.build();
    }

    @Override
    public OCType visitStructType(OCStructType type) {
        return new OCStructType(type.getStructs(), type.getTypedefName(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitUnknownType(OCUnknownType type) {
        return OCUnknownType.INSTANCE;
    }

    @Override
    public OCType visitVoidType(OCVoidType type) {
        return OCVoidType.instance(this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitTypeParameterType(OCTypeParameterType type) {
        return new OCTypeParameterType(type.getSymbol(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitAutoType(OCAutoType type) {
        return new OCAutoType(type.getExpressionSymbol(), type.getExpressionElement(), type.getIncompleteType(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitVariadicType(OCVariadicType type) {
        return new OCVariadicType(this.cloneKid(type.getUnderlyingType()));
    }

    @Override
    public OCType visitExpansionPackType(OCExpansionPackType type) {
        return new OCExpansionPackType(ContainerUtil.map(type.getExpansions(), (Function)new Function<OCTypeArgument, OCTypeArgument>(){

            public OCTypeArgument fun(OCTypeArgument typeArgument) {
                return typeArgument instanceof OCType ? ((OCType)typeArgument).transformType(new OCTypeCloneVisitor(OCTypeCloneVisitor.this.isShallow, (OCType)typeArgument, OCTypeCloneVisitor.this.myForcedConst, OCTypeCloneVisitor.this.myForcedVolatile)) : typeArgument;
            }
        }));
    }
}

