/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCTypeUtils {
    public static <T extends OCTypeArgument> Set<T> newTypeSet() {
        return new THashSet(new TObjectHashingStrategy<T>(){

            public int computeHashCode(T object) {
                return object.hashCode();
            }

            public boolean equals(T o1, T o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
    }

    public static Set<OCNamespaceLikeSymbol> newSymbolWithSubstitutionSet() {
        return new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<OCNamespaceLikeSymbol>(){

            public int computeHashCode(OCNamespaceLikeSymbol symbol) {
                return symbol.hashCode() * 31 + (symbol instanceof OCSymbolWithSubstitution ? ((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution().hashCode() : 0);
            }

            public boolean equals(OCNamespaceLikeSymbol o1, OCNamespaceLikeSymbol o2) {
                if (!o1.equals(o2)) {
                    return false;
                }
                return !(o1 instanceof OCSymbolWithSubstitution) || !(o2 instanceof OCSymbolWithSubstitution) || DeepEqual.equalObjects(((OCSymbolWithSubstitution)((Object)o1)).getSubstitution(), ((OCSymbolWithSubstitution)((Object)o2)).getSubstitution());
            }
        });
    }

    public static Set<Pair<OCSymbolReference, OCTypeSubstitution>> newReferenceWithSubstitutionSet() {
        return new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<OCSymbolReference, OCTypeSubstitution>>(){

            public int computeHashCode(Pair<OCSymbolReference, OCTypeSubstitution> object) {
                return object.hashCode();
            }

            public boolean equals(Pair<OCSymbolReference, OCTypeSubstitution> o1, Pair<OCSymbolReference, OCTypeSubstitution> o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
    }

    public static boolean areSignaturesEqual(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes) {
        List templateParams2;
        if ((s1 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s1)).isTemplateSymbol()) != (s2 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s2)).isTemplateSymbol())) {
            return false;
        }
        OCQualifiedName fqn1 = s1.getResolvedQualifiedName(context, false);
        OCQualifiedName fqn2 = s2.getResolvedQualifiedName(context, false);
        if (fqn1 == null || fqn2 == null || !fqn1.equals(fqn2)) {
            return false;
        }
        List templateParams1 = s1 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s1)).getTemplateParameters() : Collections.emptyList();
        List<Object> list = templateParams2 = s2 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s2)).getTemplateParameters() : Collections.emptyList();
        if (templateParams1.size() != templateParams2.size()) {
            return false;
        }
        HashMap<OCTypeParameterSymbol, OCTypeArgument> map = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
        OCType t1 = (s1 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s1).getTypeWithoutSubstitution() : s1.getType()).resolve(context);
        OCType t2 = (s2 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s2).getTypeWithoutSubstitution() : s2.getType()).resolve(context);
        if (!new OCTypeUnificationVisitor(false, checkFunctionReturnTypes, false, false, t2, null, map, null, context).unify(t1, t2).isUnified()) {
            return false;
        }
        for (Map.Entry<OCTypeParameterSymbol, OCTypeArgument> each : map.entrySet()) {
            if (!(each.getValue() instanceof OCTypeParameterType)) {
                return false;
            }
            OCTypeParameterSymbol key = each.getKey();
            OCTypeParameterSymbol value = ((OCTypeParameterType)each.getValue()).getSymbol();
            if (templateParams1.indexOf(key) == templateParams2.indexOf(value)) continue;
            return false;
        }
        for (int i = 0; i < templateParams1.size(); ++i) {
            OCType pt1 = ((OCSymbol)templateParams1.get(i)).getType().resolve(context);
            OCType pt2 = ((OCSymbol)templateParams2.get(i)).getType().resolve(context);
            if (pt1 instanceof OCTypeParameterType && pt2 instanceof OCTypeParameterType || pt1.equals(pt2, true, context)) continue;
            return false;
        }
        return true;
    }

    public static OCType getExtractExpressionType(OCType type, @NotNull PsiElement context, boolean disallowConst) {
        return OCTypeUtils.getExtractExpressionType(type, context, disallowConst, false);
    }

    public static OCType getExtractExpressionType(OCType type, @NotNull PsiElement context, boolean disallowConst, boolean forceReferenceMode) {
        if ((type = type.resolve(context.getContainingFile())) instanceof OCArrayType) {
            OCArrayType array = (OCArrayType)type;
            type = OCPointerType.to(array.getRefType(), array.getARCAttribute(), array.getClassQualifier(), false, false);
        }
        if (OCTypeUtils.isPassableByReference(type, forceReferenceMode, context)) {
            return OCCppReferenceType.to(disallowConst ? type : type.cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type instanceof OCCppReferenceType) {
            return OCCppReferenceType.to(((OCCppReferenceType)type).getRefType().cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type instanceof OCPointerType && !(type instanceof OCBlockPointerType) && !type.isPointerToObject()) {
            return OCPointerType.to(((OCPointerType)type).getRefType().cloneWithConstModifier(context.getProject()));
        }
        return type;
    }

    public static boolean isPassableByReference(OCType type, boolean forceReferenceMode, PsiElement context) {
        return (forceReferenceMode || type instanceof OCStructType && ((OCStructType)type).getKind() != OCSymbolKind.ENUM || type instanceof OCReferenceType) && !OCCodeInsightUtil.isInPlainOldC(context);
    }
}

