/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCType
implements OCTypeArgument {
    private static final int IS_CONST = 1;
    private static final int IS_VOLATILE = 2;
    @Nullable
    protected String myAliasName;
    @Nullable
    private OCType myGuessedType;
    private int myCVAttributes;
    private static Pattern requiresNilAttributePattern = Pattern.compile("sentinel.*");

    public OCType() {
    }

    public OCType(boolean isConst, boolean isVolatile) {
        this.myCVAttributes = (isConst ? 1 : 0) | (isVolatile ? 2 : 0);
    }

    public void attachAliasName(@Nullable String aliasName) {
        this.myAliasName = aliasName;
    }

    public void attachGuessedType(@Nullable OCType guessedType) {
        this.myGuessedType = guessedType;
    }

    @NotNull
    public String getName() {
        return this.getSimpleName(null);
    }

    @NotNull
    public String getName(@Nullable PsiElement context) {
        return context != null ? this.getBestNameInContext(context) : this.getName();
    }

    @NotNull
    public String getName(@NotNull OCResolveContext context) {
        return this.getBestNameInContext(context, null, 0);
    }

    @NotNull
    public String getSimpleName(@Nullable PsiElement context) {
        return new OCTypeNameVisitor(Presentation.SHORT, context).getName(this);
    }

    public String getBestNameInContext(@Nullable PsiElement context) {
        return this.getBestNameInContext(context, null);
    }

    public String getBestNameInContext(@Nullable PsiElement context, @Nullable String nameHint) {
        return this.getBestNameInContext(new OCResolveContext(context), nameHint, 0);
    }

    public String getBestNameInContext(@NotNull OCResolveContext context, @Nullable String nameHint, int templateDepth) {
        if (nameHint != null && this.equalsAfterResolving(nameHint, context)) {
            return nameHint;
        }
        return new OCTypeNameVisitor(Presentation.BEST, true, true, true, context, templateDepth).getName(this.resolve(context));
    }

    @NotNull
    public String getCanonicalName() {
        return this.getCanonicalName(null);
    }

    @NotNull
    public String getCanonicalName(@Nullable PsiElement context) {
        return new OCTypeNameVisitor(Presentation.FULL, false, false, true, context).getName(this);
    }

    @Override
    public String getNameForPresentation(Presentation presentation, @NotNull OCResolveContext context, boolean includeGlobalQualifier, int templateDepth) {
        if (presentation == Presentation.SHORT) {
            return this.getSimpleName(context.getElement());
        }
        if (presentation == Presentation.BEST) {
            return this.getBestNameInContext(context, null, templateDepth);
        }
        return new OCTypeNameVisitor(Presentation.FULL, false, false, includeGlobalQualifier, context, templateDepth).getName(this);
    }

    @Nullable
    public String getAliasName() {
        return this.myAliasName;
    }

    public boolean isBetterAliasName(OCType candidateType, String candidateName, String bestAliasName, PsiElement context) {
        if (context != null && candidateName != null && (bestAliasName == null || OCType.getNameComplexity(bestAliasName) > OCType.getNameComplexity(candidateName))) {
            OCType thisType = this;
            if (thisType instanceof OCCppReferenceType) {
                thisType = ((OCCppReferenceType)thisType).getRefType();
            }
            if (candidateType instanceof OCCppReferenceType) {
                candidateType = ((OCCppReferenceType)candidateType).getRefType();
            }
            return thisType.equals((Object)candidateType, context);
        }
        return false;
    }

    protected static int getNameComplexity(String name) {
        int complexity = 0;
        for (int i = 0; i < name.length(); ++i) {
            char symbol = name.charAt(i);
            if (symbol != ':' && symbol != '<' && symbol != '>') continue;
            ++complexity;
        }
        return complexity;
    }

    @NotNull
    public OCType getGuessedType() {
        return this.myGuessedType != null ? this.myGuessedType : this;
    }

    public boolean hasGuessedType() {
        return this.myGuessedType != null;
    }

    public boolean isConst() {
        return (this.myCVAttributes & 1) != 0;
    }

    public boolean isVolatile() {
        return (this.myCVAttributes & 2) != 0;
    }

    @NotNull
    public CVQualifiers getCVQualifiers() {
        return new CVQualifiers(this.isConst(), this.isVolatile());
    }

    @NotNull
    public OCType getGuessedUnmagicType() {
        return this;
    }

    @NotNull
    public OCType cloneWithCVQualifiers(@NotNull CVQualifiers modifiers, @Nullable Project project2) {
        if (this.isConst() != modifiers.isConst() || this.isVolatile() != modifiers.isVolatile()) {
            OCType clone = this.getShallowCopy(true, modifiers.isConst(), modifiers.isVolatile());
            if (clone.myAliasName != null) {
                String aliasName = clone.myAliasName;
                aliasName = modifiers.isConst() ? OCTypeNameVisitor.addTypeQualifier(aliasName, clone, project2, "const") : OCTypeNameVisitor.removeTypeQualifier(aliasName, clone, project2, "const");
                aliasName = modifiers.isVolatile() ? OCTypeNameVisitor.addTypeQualifier(aliasName, clone, project2, "volatile") : OCTypeNameVisitor.removeTypeQualifier(aliasName, clone, project2, "volatile");
                clone.attachAliasName(aliasName);
            }
            return clone;
        }
        return this;
    }

    @NotNull
    public OCType cloneWithoutCVQualifiers(@Nullable Project project2) {
        return this.cloneWithCVQualifiers(CVQualifiers.EMPTY, project2);
    }

    @NotNull
    public OCType cloneWithAddedCVQualifiers(@NotNull CVQualifiers modifiers, @Nullable Project project2) {
        return this.cloneWithCVQualifiers(this.getCVQualifiers().or(modifiers), project2);
    }

    @NotNull
    public OCType cloneWithoutConstModifier(@Nullable Project project2) {
        return this.cloneWithCVQualifiers(new CVQualifiers(false, this.isVolatile()), project2);
    }

    @NotNull
    public OCType cloneWithConstModifier(@Nullable Project project2) {
        return this.cloneWithCVQualifiers(new CVQualifiers(true, this.isVolatile()), project2);
    }

    @NotNull
    public OCType cloneWithAliasName(String aliasName) {
        OCType clone = this.getShallowCopy();
        clone.attachAliasName(aliasName);
        return clone;
    }

    @NotNull
    public OCType cloneWithGuessedType(OCType guessedType) {
        OCType clone = this.getShallowCopy(true, null, null);
        clone.attachGuessedType(guessedType);
        return clone;
    }

    public OCType getShallowCopy() {
        return this.getShallowCopy(false, null, null);
    }

    private OCType getShallowCopy(boolean keepAliasName, Boolean forcedConst, Boolean forcedVolatile) {
        OCTypeCloneVisitor visitor = new OCTypeCloneVisitor(true, this, forcedConst, forcedVolatile);
        OCType clone = this.transformType(visitor);
        if (!keepAliasName) {
            clone.attachAliasName(null);
        }
        return clone;
    }

    @NotNull
    public OCType resolve(@Nullable PsiFile file2) {
        return this.resolve(file2, false);
    }

    @NotNull
    public OCType resolve(@NotNull OCResolveContext context) {
        return this.transformType(new OCTypeResolveVisitor(context));
    }

    @NotNull
    public OCType resolve(@Nullable PsiFile file2, boolean ignoringImports) {
        return this.transformType(new OCTypeResolveVisitor(file2, ignoringImports));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @NotNull
    public OCType getTerminalType() {
        return this;
    }

    @NotNull
    public OCType getArrayElementType() {
        return this;
    }

    public int pointersDepth() {
        return 0;
    }

    public boolean isVoid() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public final boolean isUnresolved(@NotNull PsiElement context) {
        return this.isUnresolved(new OCResolveContext(context));
    }

    public boolean isUnresolved(@NotNull OCResolveContext context) {
        return false;
    }

    public boolean isMagicInside(@NotNull OCResolveContext context) {
        return false;
    }

    public boolean isSubclassOfMagic(@Nullable PsiElement context) {
        return this.isSubclassOfMagic(new OCResolveContext(context));
    }

    public boolean isSubclassOfMagic(@NotNull OCResolveContext context) {
        return false;
    }

    public boolean isScalar() {
        return false;
    }

    public boolean isChar() {
        return false;
    }

    public boolean isScalarOrConvertibleToScalar(PsiElement context) {
        return this.isScalar() || this.isCppStructType() && (this.isIntConvertible(context) || this.isPointerConvertible(context) || OCIntType.BOOL_NATIVE.isConvertibleByOperator(this, context, true));
    }

    public boolean isInstanceable() {
        return false;
    }

    public boolean isPointerCompatible(PsiElement context, boolean checkCppConvertible) {
        return OCCodeInsightUtil.isInPlainOldC(context) && this.isIntegerCompatible(context) || checkCppConvertible && this.isCppStructType() && this.isPointerConvertible(context);
    }

    public boolean isPointerCompatible(PsiElement context) {
        return this.isPointerCompatible(context, true);
    }

    public boolean isPointerToString() {
        return "NSString *".equals(this.getName());
    }

    public boolean isPointerToStringCompatible() {
        return this.isPointerToStringCompatible(false);
    }

    public boolean isPointerToStringCompatible(boolean includeMutable) {
        return "NSString *".equals(this.getName()) || "NSString *".equals(OCTollFreeBridges.getNSCounterpart(this.getName())) || includeMutable && ("NSMutableString *".equals(this.getName()) || "NSMutableString *".equals(OCTollFreeBridges.getNSCounterpart(this.getName())));
    }

    public boolean isObjCRootType() {
        String name = this.getName();
        return "id".equals(name) || "NSObject *".equals(name);
    }

    private boolean isPointerConvertible(PsiElement context) {
        return OCPointerType.to(OCVoidType.instance()).isConvertibleByOperator(this, context, false);
    }

    private boolean isIntConvertible(PsiElement context) {
        return OCIntType.INT.isConvertibleByOperator(this, context, false);
    }

    public boolean isNumberCompatible(PsiElement context) {
        return context != null && this.isCppStructType() && OCRealType.DOUBLE.isConvertibleByOperator(this, context, false);
    }

    public boolean isIntegerCompatible(PsiElement context, boolean checkCppConvertible) {
        return checkCppConvertible && this.isCppStructType() && this.isIntConvertible(context);
    }

    public boolean isIntegerCompatible(PsiElement context) {
        return this.isIntegerCompatible(context, true);
    }

    public boolean isPointerToObject() {
        return false;
    }

    public boolean isPointerToObjectCompatible() {
        return this.isPointerToObject() || this.isClassType() || this instanceof OCBlockPointerType;
    }

    public boolean isPointerToPointerToObjectCompatible() {
        return this.isPointerToObjectCompatible() || this instanceof OCPointerType && ((OCPointerType)this).getRefType().isPointerToPointerToObjectCompatible();
    }

    public boolean isPointerToID() {
        return false;
    }

    public boolean isPointerToChar() {
        return false;
    }

    public boolean isCString() {
        return false;
    }

    public boolean isPointer() {
        return false;
    }

    public boolean isPointerToVoid() {
        return false;
    }

    public boolean isClassType() {
        if (this instanceof OCPointerType) {
            String name = ((OCPointerType)this).getRefType().getName();
            return name.equals("struct objc_class") || name.equals("objc_class");
        }
        return false;
    }

    public boolean isCppStructType() {
        return false;
    }

    public boolean isPointerToCppStructType() {
        return false;
    }

    @Override
    public boolean isVariadic() {
        return false;
    }

    @NotNull
    public String getDefaultValue(@Nullable PsiElement context) {
        if (this.isPointerToObject()) {
            return "nil";
        }
        if (context != null && OCCompilerHelper.supportsNullptr(context.getContainingFile())) {
            return "nullptr";
        }
        return "NULL";
    }

    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return -1;
    }

    public OCType transformType(OCTypeVisitor<OCType> visitor) {
        OCType result = this.accept(visitor);
        if (result.myAliasName == null) {
            result.attachAliasName(this.myAliasName);
        }
        if (result.myGuessedType == null) {
            result.attachGuessedType(this.myGuessedType);
        }
        return result;
    }

    public abstract <T> T accept(OCTypeVisitor<T> var1);

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCType f = (OCType)first;
        OCType s = (OCType)second;
        if (f.myCVAttributes != s.myCVAttributes) {
            return false;
        }
        if (!Comparing.equal((String)f.myAliasName, (String)s.myAliasName)) {
            return false;
        }
        return c.equalObjects(f.myGuessedType, s.myGuessedType);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Use equals(Object o, @NotNull OCMemoization context) instead");
    }

    public boolean equals(Object o, @Nullable PsiElement context) {
        return this.equals(o, true, new OCResolveContext(context));
    }

    @Override
    public boolean equals(Object o, @NotNull OCResolveContext context) {
        return this.equals(o, true, context);
    }

    public boolean equals(Object o, boolean checkCV, @NotNull OCResolveContext context) {
        return o instanceof OCType && new OCTypeEqualityVisitor((OCType)o, false, false, false, false, false, true, !checkCV, context).equal(this);
    }

    protected int baseHashCode() {
        int result = this.myAliasName != null ? this.myAliasName.hashCode() : 0;
        result = 31 * result + (this.myGuessedType != null ? this.myGuessedType.hashCode() : 0);
        result = 31 * result + this.myCVAttributes;
        return result;
    }

    public int hashCode() {
        OCLog.LOG.warn("An attempt to get hashCode for OCType base class!");
        return 0;
    }

    public boolean equalsAfterResolving(String typeName, @NotNull OCResolveContext context) {
        PsiElement element = context.getElement();
        return element != null && this.equalsAfterResolving(OCElementUtil.getType(OCElementFactory.typeCodeFragment(typeName, element)), context, true, false);
    }

    public boolean equalsAfterResolving(OCType type, @NotNull OCResolveContext context, boolean magicTypeEquals, boolean ignoreArguments) {
        OCType thisType = this;
        if (type == null) {
            return false;
        }
        if (thisType instanceof OCCppReferenceType) {
            thisType = ((OCCppReferenceType)thisType).getRefType();
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        return new OCTypeEqualityAfterResolvingVisitor(type, false, magicTypeEquals, true, ignoreArguments, true, context).equal(thisType);
    }

    public boolean equalsAfterResolving(OCType type, @Nullable PsiElement context) {
        return new OCTypeEqualityAfterResolvingVisitor(type, false, new OCResolveContext(context)).equal(this);
    }

    public boolean equalsWithAliasName(OCType type, @Nullable PsiElement context) {
        String thisAliasName = this.getAliasName();
        String typeAliasName = type.getAliasName();
        if (thisAliasName == null) {
            thisAliasName = this.getCanonicalName(context);
        }
        if (typeAliasName == null) {
            typeAliasName = type.getCanonicalName(context);
        }
        return Comparing.equal((String)thisAliasName, (String)typeAliasName) && this.equalsAfterResolving(type, context);
    }

    @NotNull
    public OCType getLeastCommonType(OCType type, @Nullable PsiElement context) {
        OCType commonGuessedType;
        if (type == null) {
            return OCUnknownType.INSTANCE;
        }
        OCType result = this.doGetLeastCommonType(type, context);
        result = result.cloneWithAddedCVQualifiers(this.getCVQualifiers().or(type.getCVQualifiers()), context != null ? context.getProject() : null);
        if (!(this.myGuessedType == null || type.myGuessedType == null || (commonGuessedType = this.myGuessedType.doGetLeastCommonType(type.myGuessedType, context)).isUnknown() || !result.isPointerToID() && commonGuessedType.isCompatible(result, context))) {
            result = result.cloneWithGuessedType(commonGuessedType);
        }
        return result;
    }

    @NotNull
    protected OCType doGetLeastCommonType(OCType type, PsiElement context) {
        return OCUnknownType.INSTANCE;
    }

    @NotNull
    public TypeCheckResult checkCompatible(OCType type, @Nullable PsiElement context) {
        return this.checkCompatible(type, null, context);
    }

    @NotNull
    public TypeCheckResult checkCompatible(OCType type, @Nullable OCTypeOwner expression, @Nullable PsiElement context) {
        return this.checkCompatible(type, expression, context, true, true, new OCResolveContext(context));
    }

    @NotNull
    public TypeCheckResult checkCompatible(OCType type, @Nullable OCTypeOwner expression, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        return OCTypeCompatibilityVisitor.checkConvertible(this, type, expression, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    public boolean isConvertibleByOperator(OCType type, @NotNull PsiElement context, boolean isExplicitCast) {
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCStructType) {
            TypeCheckResult error = new TypeCheckResult(TypeCheckState.ERROR);
            OCResolveContext resolveContext = new OCResolveContext(context);
            return !OCTypeCompatibilityVisitor.checkConversionOperators(this, (OCStructType)type, null, context, error, isExplicitCast, resolveContext).getState().isError(context);
        }
        return false;
    }

    public boolean isCompatible(OCType type, @Nullable PsiElement context) {
        return this.checkCompatible(type, context).getState() == TypeCheckState.OK;
    }

    public boolean isCompatible(OCType type, @NotNull PsiElement context, boolean allowImplicitConversions) {
        return this.checkCompatible(type, null, context, allowImplicitConversions, true, new OCResolveContext(context)).getState() == TypeCheckState.OK;
    }

    public boolean isCompatible(OCType type, @Nullable OCTypeOwner expression, @NotNull PsiElement context) {
        return this.checkCompatible(type, expression, context).getState() == TypeCheckState.OK;
    }

    public boolean isSuperType(OCType type, PsiElement context) {
        PsiFile file2 = context.getContainingFile();
        OCType self = this.resolve(file2);
        type = type.resolve(file2);
        if (self.isPointerToObject() && type.isPointerToObject() || self.isCppStructType() && type.isCppStructType()) {
            return self.isCompatible(type, context) && this.myCVAttributes == type.myCVAttributes;
        }
        if (type instanceof OCArrayType && this instanceof OCPointerType) {
            OCType refType = ((OCPointerType)this).getRefType().resolve(file2);
            OCType typeRefType = ((OCArrayType)type).getRefType().resolve(file2);
            if (refType.isPointerToID() && typeRefType.isPointerToID()) {
                return true;
            }
        }
        return self.equalsAfterResolving(type, (PsiElement)file2);
    }

    @Nullable
    public String getFormatString() {
        return null;
    }

    public static boolean isFunctionRequiringNil(OCSymbol<?> callable) {
        for (String attribute : callable.getAttributes()) {
            Matcher matcher = requiresNilAttributePattern.matcher(attribute);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public OCType convertArrayToPointer(PsiFile context) {
        return this.resolve(context).transformType(OCArrayToPointerChanger.INSTANCE);
    }

    public static class TypeCheckResult {
        private TypeCheckState state;
        private String message;
        private Class<? extends OCInspection> inspectionClass;
        private String clangID;
        private IntentionAction[] quickFixes;
        private PsiElement myAnnotationElement;
        private boolean myIsWithConversion;
        private OCType myTypeAfterConversion;
        private OCFunctionSymbol myImplicitConstructor;

        public TypeCheckResult(TypeCheckState state, Class<? extends OCInspection> inspectionClass, String clangID, IntentionAction ... quickFixes) {
            this(state, inspectionClass, clangID, false, null, quickFixes);
        }

        public TypeCheckResult(TypeCheckState state, String message, Class<? extends OCInspection> inspectionClass, String clangID, IntentionAction ... quickFixes) {
            this(state, inspectionClass, clangID, false, null, quickFixes);
            this.message = message;
        }

        public TypeCheckResult(TypeCheckState state, Class<? extends OCInspection> inspectionClass, String clangID, PsiElement annotationElement, IntentionAction ... quickFixes) {
            this(state, inspectionClass, clangID, false, null, quickFixes);
            this.myAnnotationElement = annotationElement;
        }

        public TypeCheckResult(TypeCheckState state, Class<? extends OCInspection> inspectionClass, String clangID, boolean withConversion, OCType typeAfterConversion, IntentionAction ... quickFixes) {
            this.state = state;
            this.inspectionClass = inspectionClass;
            this.clangID = clangID;
            this.myIsWithConversion = withConversion;
            this.myTypeAfterConversion = typeAfterConversion;
            this.quickFixes = quickFixes;
        }

        public TypeCheckResult(TypeCheckState state) {
            this.state = state;
        }

        public TypeCheckState getState() {
            return this.state;
        }

        public void setState(TypeCheckState state) {
            this.state = state;
        }

        public String getMessage() {
            return this.message;
        }

        public Class<? extends OCInspection> getInspectionClass() {
            return this.inspectionClass;
        }

        public String getClangID() {
            return this.clangID;
        }

        public IntentionAction[] getQuickFixes() {
            return this.quickFixes;
        }

        public void setQuickFixes(IntentionAction[] quickFixes) {
            this.quickFixes = quickFixes;
        }

        @Nullable
        public PsiElement getAnnotationElement() {
            return this.myAnnotationElement;
        }

        public void setAnnotationElement(PsiElement annotationElement) {
            this.myAnnotationElement = annotationElement;
        }

        public boolean isWithConversion() {
            return this.myIsWithConversion;
        }

        @Nullable
        public OCType getTypeAfterConversion() {
            return this.myTypeAfterConversion;
        }

        @Nullable
        public OCFunctionSymbol getImplicitConstructor() {
            return this.myImplicitConstructor;
        }

        public void setImplicitConstructor(OCFunctionSymbol implicitConstructor) {
            this.myImplicitConstructor = implicitConstructor;
        }

        public boolean canBeCasted(OCType lType, OCType rType, PsiElement context) {
            if (this.state != TypeCheckState.ERROR) {
                return true;
            }
            if (lType.isPointerCompatible(context) && rType.isPointerCompatible(context) && lType.isPointerToObjectCompatible() == rType.isPointerToObjectCompatible()) {
                return true;
            }
            return lType instanceof OCCppReferenceType && ((OCCppReferenceType)lType).isRvalueRef() && ((OCCppReferenceType)lType).getRefType().checkCompatible(rType, context).getState() == TypeCheckState.OK;
        }
    }

    public static enum TypeCheckState implements Comparable<TypeCheckState>
    {
        OK,
        INFO,
        WARNING,
        ERROR_IF_CPP,
        ERROR;


        public boolean isOK() {
            return this == OK;
        }

        public boolean isWarning(@NotNull PsiElement context) {
            return this == WARNING || this == ERROR_IF_CPP && !((OCFile)context.getContainingFile()).isCpp();
        }

        public boolean isError(@Nullable PsiElement context) {
            return this == ERROR || context != null && this == ERROR_IF_CPP && ((OCFile)context.getContainingFile()).isCpp();
        }
    }

    public static enum Presentation {
        FULL,
        BEST,
        SHORT;

    }
}

