/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceType
extends OCType
implements Serializable {
    @NotNull
    private OCSymbolReference myReference;
    @NotNull
    private List<String> myProtocolNames;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private ARCAttribute myARCAttribute;
    private boolean myIsKindof;
    private boolean myFunctionParameterType = false;

    public OCReferenceType() {
    }

    public OCReferenceType(boolean isConst, boolean isVolatile, @NotNull OCSymbolReference reference, @NotNull List<String> protocolNames, @NotNull OCTypeSubstitution substitution, @Nullable ARCAttribute arcAttribute, boolean functionParameterType, boolean isKindof) {
        super(isConst, isVolatile);
        this.myReference = reference;
        this.myProtocolNames = protocolNames;
        this.mySubstitution = substitution;
        this.myARCAttribute = arcAttribute;
        this.myFunctionParameterType = functionParameterType;
        this.myIsKindof = isKindof;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCReferenceType f = (OCReferenceType)first;
        OCReferenceType s = (OCReferenceType)second;
        if (f.myARCAttribute != s.myARCAttribute) {
            return false;
        }
        if (f.myIsKindof != s.myIsKindof) {
            return false;
        }
        if (!f.myProtocolNames.equals(s.myProtocolNames)) {
            return false;
        }
        if (!c.equalObjects(f.myReference, s.myReference)) {
            return false;
        }
        return c.equalObjects(f.mySubstitution, s.mySubstitution);
    }

    @Override
    public int hashCode() {
        int result = this.baseHashCode();
        result = 31 * result + this.myReference.hashCode();
        result = 31 * result + (this.myARCAttribute == null ? 0 : this.myARCAttribute.hashCode());
        result = 31 * result + this.myProtocolNames.hashCode();
        result = 31 * result + this.mySubstitution.hashCode();
        result = 31 * result + Boolean.valueOf(this.myIsKindof).hashCode();
        return result;
    }

    @NotNull
    public List<String> getProtocolNames() {
        return this.myProtocolNames;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        return true;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @NotNull
    public static OCType resolvedFromText(String name, @Nullable PsiFile file2) {
        return OCReferenceType.fromText(name).resolve(file2);
    }

    @NotNull
    public static OCType resolvedFromText(String name, @NotNull String protocolName, @Nullable PsiFile file2) {
        return OCReferenceType.fromText(name, protocolName).resolve(file2);
    }

    @NotNull
    public static OCType resolvedFromText(String name, PsiFile file2, boolean ignoreImports) {
        return OCReferenceType.fromText(name).resolve(file2, ignoreImports);
    }

    @NotNull
    public static OCReferenceType fromText(String name) {
        return new OCReferenceTypeBuilder(name).build();
    }

    @NotNull
    public static OCReferenceType fromText(String name, @NotNull String protocolName) {
        return new OCReferenceTypeBuilder(name).setSingleProtocolName(protocolName).build();
    }

    @NotNull
    public static OCReferenceType fromText(String name, @NotNull List<String> protocolNames) {
        return new OCReferenceTypeBuilder(name).setProtocolNames(protocolNames).build();
    }

    public static OCReferenceType fromLocalText(OCQualifiedName name) {
        return new OCReferenceTypeBuilder(name, null).build();
    }

    @NotNull
    public OCSymbolReference getReference() {
        return this.myReference;
    }

    @NotNull
    public OCSymbolReference getReference(@NotNull OCResolveContext context) {
        return this.getReference(context.getFile());
    }

    @NotNull
    public OCSymbolReference getReference(@Nullable PsiFile file2) {
        if (file2 == null) {
            return this.myReference;
        }
        OCQualifiedName qualifiedName = this.myReference.getQualifiedName();
        if (!this.myProtocolNames.isEmpty() && !(qualifiedName instanceof OCQualifiedNameWithArguments) && file2 instanceof OCFile && !((OCFile)file2).getKind().isObjC()) {
            return this.myReference.applyTypeArguments(ContainerUtil.map(this.myProtocolNames, (Function)new Function<String, OCTypeArgument>(){

                public OCTypeArgument fun(String argumentName) {
                    return new OCReferenceTypeBuilder(OCReferenceType.this.myReference.createReferenceInSameContext(OCQualifiedName.interned(argumentName))).build();
                }
            }));
        }
        return this.myReference;
    }

    @Nullable
    public ARCAttribute getARCAttribute() {
        return this.myARCAttribute;
    }

    public boolean isFunctionParameterType() {
        return this.myFunctionParameterType;
    }

    public void setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
    }

    public boolean isKindof() {
        return this.myIsKindof;
    }
}

