/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionType
extends OCType {
    private OCType myReturnType;
    private List<OCType> myParameterTypes;
    private List<String> myParameterNames;

    public OCFunctionType() {
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<OCType> parameterTypes) {
        this(returnType, parameterTypes, null, false, false);
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<OCType> parameterTypes, @Nullable List<String> parameterNames) {
        this(returnType, parameterTypes, parameterNames, false, false);
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<OCType> parameterTypes, @Nullable List<String> parameterNames, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myReturnType = returnType;
        this.myParameterTypes = parameterTypes;
        this.myParameterNames = parameterNames;
        assert (this.myParameterNames == null || this.myParameterNames.size() == this.myParameterTypes.size());
    }

    public static OCType convertArrayParameterType(OCType type) {
        if (type instanceof OCArrayType) {
            OCArrayType array = (OCArrayType)type;
            OCPointerType pointer = OCPointerType.to(array.getRefType(), array.getARCAttribute(), array.getClassQualifier(), false, array.isVolatile());
            pointer.setLengthInBrackets(array.getLength());
            type = pointer;
        }
        return type;
    }

    @NotNull
    public OCType getReturnType() {
        return this.myReturnType;
    }

    @NotNull
    public List<OCType> getParameterTypes(boolean includeVoid) {
        return !includeVoid && this.hasNoParameters() ? Collections.emptyList() : this.myParameterTypes;
    }

    @NotNull
    public List<OCType> getParameterTypes() {
        return this.getParameterTypes(false);
    }

    @Nullable
    public List<String> getParameterNames(boolean includeVoid) {
        return !includeVoid && this.hasNoParameters() ? Collections.emptyList() : this.myParameterNames;
    }

    @Nullable
    public List<String> getParameterNames() {
        return this.getParameterNames(false);
    }

    public boolean isVararg() {
        if (this.myParameterTypes.size() > 0) {
            OCType lastParamType = this.myParameterTypes.get(this.myParameterTypes.size() - 1).getTerminalType();
            return lastParamType instanceof OCEllipsisType || lastParamType instanceof OCVariadicType;
        }
        return false;
    }

    public boolean hasNoParameters() {
        if (this.myParameterTypes.isEmpty()) {
            return true;
        }
        if (this.myParameterTypes.size() == 1) {
            return this.myParameterTypes.get(0) instanceof OCVoidType && (this.myParameterNames == null || "<unnamed>".equals(this.myParameterNames.get(0)));
        }
        return false;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitFunctionType(this);
    }

    @Override
    public int hashCode() {
        int result = this.baseHashCode();
        result = 31 * result + this.myReturnType.hashCode();
        result = 31 * result + this.myParameterTypes.hashCode();
        return result;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCFunctionType f = (OCFunctionType)first;
        OCFunctionType s = (OCFunctionType)second;
        if (!Comparing.equal(f.myParameterNames, s.myParameterNames)) {
            return false;
        }
        if (!c.equalIterable(f.myParameterTypes, s.myParameterTypes)) {
            return false;
        }
        return c.equalObjects(f.myReturnType, s.myReturnType);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, PsiElement context) {
        if (type == null) {
            return OCUnknownType.INSTANCE;
        }
        if (type instanceof OCMagicType) {
            return type;
        }
        if (type.isNumberCompatible(context)) {
            return OCIntType.INT.getLeastCommonType(type, context);
        }
        if (type.isPointerCompatible(context)) {
            if (this.equals((Object)type, context)) {
                return this;
            }
            return OCPointerType.to(OCVoidType.instance());
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public boolean isPointerCompatible(PsiElement context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (this.myReturnType.isUnresolved(context) || this.myReturnType instanceof OCFunctionType || this.myReturnType instanceof OCArrayType) {
            return true;
        }
        for (OCType type : this.myParameterTypes) {
            if (!type.isUnresolved(context) && !(type instanceof OCVoidType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFormatString() {
        return "%p";
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return OCIntType.INT.getSizeInBytes(file2, context);
    }
}

