/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCExpansionPackType
extends OCType {
    private List<OCTypeArgument> myExpansions = Collections.emptyList();

    public OCExpansionPackType() {
    }

    public OCExpansionPackType(@NotNull List<OCTypeArgument> expansions) {
        this.myExpansions = Collections.unmodifiableList(expansions);
    }

    public OCExpansionPackType appendTypeArgument(@NotNull OCTypeArgument typeArgument) {
        return new OCExpansionPackType(ContainerUtil.append(this.myExpansions, (Object[])new OCTypeArgument[]{typeArgument}));
    }

    @NotNull
    public List<OCTypeArgument> getExpansions() {
        return this.myExpansions;
    }

    public int getExpansionsCnt() {
        return this.myExpansions.size();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCExpansionPackType f = (OCExpansionPackType)first;
        OCExpansionPackType s = (OCExpansionPackType)second;
        return c.equalObjects(f.myExpansions, s.myExpansions);
    }

    @Override
    public int hashCode() {
        return this.myExpansions.hashCode();
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitExpansionPackType(this);
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        for (OCTypeArgument expansion : this.myExpansions) {
            if (!(expansion instanceof OCType) || !((OCType)expansion).isMagicInside(context)) continue;
            return true;
        }
        return false;
    }
}

