/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAutoType
extends OCType {
    @Nullable
    private OCType myIncompleteType;
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    private OCExpressionSymbol myExpressionSymbol;
    private OCExpression myExpressionElement;

    public OCAutoType(@Nullable OCExpressionSymbol expressionSymbol, @Nullable OCExpression expressionElement, @Nullable OCType incompleteType, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myExpressionSymbol = expressionSymbol;
        this.myExpressionElement = expressionElement;
        this.myIncompleteType = incompleteType;
    }

    public OCAutoType(@NotNull OCAutoType origin, OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        this.myIncompleteType = origin.getIncompleteType();
        this.myExpressionSymbol = origin.getExpressionSymbol();
        this.myExpressionElement = origin.getExpressionElement();
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
    }

    public OCAutoType() {
    }

    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCAutoType f = (OCAutoType)first;
        OCAutoType s = (OCAutoType)second;
        if (!c.equalObjects(f.myExpressionSymbol, s.myExpressionSymbol)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return this.myExpressionElement == null == (s.myExpressionElement == null);
    }

    @Nullable
    public OCType getIncompleteType() {
        return this.myIncompleteType;
    }

    @Nullable
    public OCExpressionSymbol getExpressionSymbol() {
        return this.myExpressionSymbol;
    }

    @Nullable
    public OCExpression getExpressionElement() {
        return this.myExpressionElement;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitAutoType(this);
    }

    @Override
    public int hashCode() {
        int result = this.baseHashCode();
        result = 31 * result + (this.myIncompleteType != null ? this.myIncompleteType.hashCode() : 0);
        result = 31 * result + (this.mySubstitution != null ? this.mySubstitution.hashCode() : 0);
        result = 31 * result + (this.myExpressionSymbol != null ? this.myExpressionSymbol.hashCode() : 0);
        return result;
    }
}

