/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CVQualifiers {
    public static CVQualifiers EMPTY = new CVQualifiers(false, false);
    private final boolean myConst;
    private final boolean myVolatile;

    public CVQualifiers(boolean isConst, boolean isVolatile) {
        this.myConst = isConst;
        this.myVolatile = isVolatile;
    }

    public boolean isConst() {
        return this.myConst;
    }

    public boolean isVolatile() {
        return this.myVolatile;
    }

    @NotNull
    public CVQualifiers or(@NotNull CVQualifiers modifiers) {
        return new CVQualifiers(this.myConst || modifiers.isConst(), this.myVolatile || modifiers.isVolatile());
    }

    public void appendCVQualifiers(@NotNull StringBuilder buffer) {
        if (this.isConst()) {
            buffer.append(" const");
        }
        if (this.isVolatile()) {
            buffer.append(" volatile");
        }
    }

    @NotNull
    public static String appendCVQualifiers(@NotNull String typeString, @NotNull OCType type, @Nullable Project project2) {
        if (type.isConst()) {
            typeString = OCTypeNameVisitor.addTypeQualifier(typeString, type, project2, "const");
        }
        if (type.isVolatile()) {
            typeString = OCTypeNameVisitor.addTypeQualifier(typeString, type, project2, "volatile");
        }
        return typeString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CVQualifiers that = (CVQualifiers)o;
        if (this.myConst != that.myConst) {
            return false;
        }
        return this.myVolatile == that.myVolatile;
    }

    public int hashCode() {
        int result = this.myConst ? 1 : 0;
        result = 31 * result + (this.myVolatile ? 1 : 0);
        return result;
    }
}

