/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NotNullProducer;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTablesBuildingActivity {
    @Nullable
    private static NotNullProducer<ProgressIndicator> ourIndicatorFactory;
    @NotNull
    private static final Set<Thread> mySymbolBuildingThreads;
    public static final NotNullLazyKey<List<String>, Project> ACTIVITY_LOG;
    private final Project project;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();

    public static OCSymbolTablesBuildingActivity getInstance(Project project2) {
        return (OCSymbolTablesBuildingActivity)ServiceManager.getService((Project)project2, OCSymbolTablesBuildingActivity.class);
    }

    public OCSymbolTablesBuildingActivity(@NotNull Project project2) {
        this.project = project2;
    }

    @NotNull
    public SimpleModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public void assertParsingAndSymbolBuildingAllowed() {
        this.assertParsingAndSymbolBuildingAllowed(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertParsingAndSymbolBuildingAllowed(Thread thread) {
        boolean allowed;
        boolean bl = allowed = FileSymbolTablesCache.areSymbolsLoaded(this.project) || mySymbolBuildingThreads.contains(thread);
        if (!allowed) {
            String logEntries;
            List log;
            List list = log = (List)ACTIVITY_LOG.getValue((UserDataHolder)this.project);
            synchronized (list) {
                logEntries = StringUtil.join((Collection)log, (String)"\n");
            }
            OCLog.LOG.error("Symbol building is not allowed: " + System.currentTimeMillis() + " . \n" + "Loaded: " + FileSymbolTablesCache.areSymbolsLoaded(this.project) + "\n" + "Dumb: " + DumbService.isDumb((Project)this.project) + "\n" + "Previous activities: \n" + logEntries);
        }
    }

    public static void setIndicatorFactory(@Nullable NotNullProducer<ProgressIndicator> indicatorFactory) {
        ourIndicatorFactory = indicatorFactory;
    }

    public void rebuildSymbols() {
        this.rebuildSymbols(true);
    }

    public void rebuildSymbols(final boolean reuseSerializedTables) {
        this.runSymbolActivity("rebuildSymbols", new Processor<MyProgressIndicator>(){

            public boolean process(MyProgressIndicator indicator) {
                OCSymbolTablesBuildingActivity.this.buildSymbolsInternal(indicator, reuseSerializedTables);
                return true;
            }
        });
    }

    public void rebuildSwiftModules(final FileType swiftFileType) {
        this.runSymbolActivity("rebuildSwiftModules", new Processor<MyProgressIndicator>(){

            public boolean process(MyProgressIndicator indicator) {
                OCSymbolTablesBuildingActivity.this.processSwiftModules(ContainerUtil.createMaybeSingletonList((Object)new LightVirtualFile("", swiftFileType, (CharSequence)"")), indicator);
                return true;
            }
        });
    }

    public void buildSymbolsForFiles(final @NotNull Collection<VirtualFile> files) {
        this.runSymbolActivity("buildSymbolsForFiles", new Processor<MyProgressIndicator>(){

            public boolean process(MyProgressIndicator indicator) {
                OCSymbolTablesBuildingActivity.this.buildSymbolsForFilesInternal(indicator, files);
                return true;
            }
        });
    }

    private void runSymbolActivity(final @NotNull String activityName, final @NotNull Processor<MyProgressIndicator> activity) {
        DumbService.getInstance((Project)this.project).queueTask(new DumbModeTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void performInDumbMode(@NotNull ProgressIndicator _) {
                final MyProgressIndicator indicator = new MyProgressIndicator(_);
                class MyDisposable
                implements Disposable {
                    boolean shouldCancel = true;

                    MyDisposable() {
                    }

                    public void dispose() {
                        if (this.shouldCancel) {
                            indicator.cancel();
                        }
                    }
                }
                MyDisposable cancelOnProjectDispose = new MyDisposable();
                try {
                    List log = (List)ACTIVITY_LOG.getValue((UserDataHolder)OCSymbolTablesBuildingActivity.this.project);
                    long start = System.currentTimeMillis();
                    List list = log;
                    synchronized (list) {
                        log.add(activityName + " " + start + ": START");
                    }
                    Disposer.register((Disposable)OCSymbolTablesBuildingActivity.this.project, (Disposable)cancelOnProjectDispose);
                    activity.process((Object)indicator);
                    cancelOnProjectDispose.shouldCancel = false;
                    list = log;
                    synchronized (list) {
                        log.add(activityName + " " + start + ": END after " + (System.currentTimeMillis() - start));
                    }
                }
                catch (Throwable t) {
                    if (!OCSymbolTablesBuildingActivity.this.project.isDisposed() && OCSymbolTablesBuildingActivity.this.project.isOpen()) {
                        boolean pce = t instanceof ProcessCanceledException;
                        OCLog.LOG.error("Unexpected exception during symbol building (" + activityName + ")", pce ? new RuntimeException(t) : t);
                    }
                }
                finally {
                    Disposer.dispose((Disposable)cancelOnProjectDispose);
                }
            }
        });
    }

    private void buildSymbolsForFilesInternal(final @NotNull MyProgressIndicator indicator, @NotNull Collection<VirtualFile> sourceFiles) {
        final FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.project);
        if (!cache.shouldBuildTables()) {
            return;
        }
        OCSymbolTablesBuildingActivity.invokeAndWaitSafely((ProgressIndicator)indicator, new Runnable(){

            @Override
            public void run() {
                if (indicator.isCanceled()) {
                    return;
                }
                cache.notifySymbolsUnloaded();
                cache.reparseCachedPsiFiles();
            }
        });
        indicator.checkCanceled();
        indicator.setText("Updating symbols...");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        indicator.setInterval(indicator.getFraction(), 1.0);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, sourceFiles).processBuildFiles();
        this.notifySymbolsAreLoadedAndReparseCachedFiles(cache, indicator);
    }

    private void buildSymbolsInternal(final @NotNull MyProgressIndicator indicator, boolean reuseSerializedTables) {
        final FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.project);
        if (!cache.shouldBuildTables()) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            OCLog.LOG.error("Symbols building must not be initiated from write action, otherwise deadlock will occur");
            return;
        }
        indicator.checkCanceled();
        indicator.setText("Building symbols...");
        indicator.setText2("");
        indicator.setIndeterminate(true);
        indicator.startTiming("Clearing symbols");
        final String[] projectLocationHash = new String[1];
        OCSymbolTablesBuildingActivity.invokeAndWaitSafely((ProgressIndicator)indicator, new Runnable(){

            @Override
            public void run() {
                if (indicator.isCanceled()) {
                    return;
                }
                cache.notifySymbolsUnloaded();
                cache.clearAllTables();
                cache.reparseCachedPsiFiles();
                OCSymbolTablesBuildingActivity.this.clearAllSymbolDependentCaches();
                projectLocationHash[0] = OCSymbolTablesBuildingActivity.this.project.getLocationHash();
            }
        });
        indicator.logTiming();
        indicator.checkCanceled();
        indicator.setText("Loading symbols...");
        indicator.startTiming("Loading symbols");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        final Collection<VirtualFile> allFiles = OCSymbolTablesBuildingActivity.getFilesToBuildCachesForSafely((ProgressIndicator)indicator, cache);
        final ArrayList<VirtualFile> sourceFiles = new ArrayList<VirtualFile>();
        OCSymbolTablesBuildingActivity.runReadActionSafely((ProgressIndicator)indicator, new Runnable(){

            @Override
            public void run() {
                sourceFiles.addAll(ContainerUtil.findAll((Collection)allFiles, (Condition)new Condition<VirtualFile>(){

                    public boolean value(VirtualFile file2) {
                        return !OCInclusionContextUtil.isNeedToFindRoot(file2, OCSymbolTablesBuildingActivity.this.project);
                    }
                }));
            }
        });
        long loadedFileCount = reuseSerializedTables ? cache.deserializeTables(projectLocationHash[0], allFiles, (ProgressIndicator)indicator) : 0L;
        double loadedFraction = indicator.getFraction();
        double savingFraction = 1.0 - (1.0 - loadedFraction) * 0.15;
        indicator.logTiming();
        HashSet loadedFiles = new HashSet(cache.getCachedFiles());
        indicator.checkCanceled();
        indicator.setText(loadedFiles.isEmpty() ? "Building symbols..." : "Updating symbols...");
        indicator.startTiming("Building symbols");
        List sourceFilesWithoutTables = ContainerUtil.findAll(sourceFiles, (Condition)new Condition<VirtualFile>((Set)loadedFiles){
            final /* synthetic */ Set val$loadedFiles;
            {
                this.val$loadedFiles = set;
            }

            public boolean value(VirtualFile file2) {
                return !this.val$loadedFiles.contains(file2);
            }
        });
        double loadedAndSourceCount = (double)loadedFileCount + (double)sourceFilesWithoutTables.size();
        double headerWithoutTablesCount = (double)allFiles.size() - loadedAndSourceCount;
        double headersPart = headerWithoutTablesCount * 0.2;
        indicator.setInterval(indicator.getFraction(), savingFraction * (loadedAndSourceCount / Math.max(loadedAndSourceCount + headersPart, 1.0)));
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, sourceFiles).processBuildFiles();
        indicator.checkCanceled();
        this.processSwiftModules(allFiles, indicator);
        HashSet headersWithoutTables = new HashSet(allFiles);
        headersWithoutTables.removeAll(cache.getFilesWithUsedTables());
        indicator.setInterval(indicator.getFraction(), savingFraction);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, (Collection<VirtualFile>)headersWithoutTables).processBuildFiles();
        indicator.logTiming();
        cache.removeUnusedTables();
        HashSet modifiedTables = new HashSet(cache.getFilesWithChangedTables());
        this.notifySymbolsAreLoadedAndReparseCachedFiles(cache, indicator);
        indicator.checkCanceled();
        indicator.setText("Saving symbols...");
        indicator.startTiming("Saving symbols");
        indicator.setInterval(savingFraction, 1.0);
        cache.serializeTables(projectLocationHash[0], (Set<VirtualFile>)modifiedTables, (ProgressIndicator)indicator);
        indicator.logTiming();
        FileSymbolTable.reportStats(this.project);
    }

    private void processSwiftModules(@NotNull Collection<VirtualFile> allFiles, @NotNull MyProgressIndicator indicator) {
        ArrayList tasks = ContainerUtil.newArrayList();
        for (SymbolTableProvider provider : (SymbolTableProvider[])SymbolTableProvider.INSTANCE.getExtensions()) {
            List<TaskProvider<?>> additionalActivities = provider.getItemProviderAndWorkerForAdditionalSymbolLoading(this.project, (ProgressIndicator)indicator, allFiles);
            if (additionalActivities == null) continue;
            for (TaskProvider<?> taskProvider : additionalActivities) {
                tasks.add(OCSymbolTablesBuildingActivity.createTask(taskProvider, (ProgressIndicator)indicator));
            }
        }
        if (!tasks.isEmpty()) {
            indicator.setText("Processing Swift modules...");
            indicator.setInterval(0.0, 1.0);
            indicator.setFraction(0.0);
            OCSymbolTablesBuildingActivity.processFutures(tasks);
        }
    }

    private void notifySymbolsAreLoadedAndReparseCachedFiles(final @NotNull FileSymbolTablesCache cache, final @NotNull MyProgressIndicator indicator) {
        indicator.checkCanceled();
        OCSymbolTablesBuildingActivity.runReadActionSafely((ProgressIndicator)indicator, new Runnable(){

            @Override
            public void run() {
                indicator.checkCanceled();
                cache.compact();
                cache.notifySymbolsLoaded();
            }
        });
        indicator.checkCanceled();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (OCSymbolTablesBuildingActivity.this.project.isDisposed() || indicator.isCanceled()) {
                    return;
                }
                cache.reparseCachedPsiFiles();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    private void clearAllSymbolDependentCaches() {
        this.myModificationTracker.incModificationCount();
        for (OCResolveConfiguration oCResolveConfiguration : OCWorkspaceManager.getWorkspace(this.project).getConfigurations()) {
            OCInclusionContext.onPrecompiledContextChange(oCResolveConfiguration);
            OCInclusionContext.clearSymbolTableConformanceCache(oCResolveConfiguration);
            OCImportGraph.invalidateRootHeadersCache(oCResolveConfiguration);
        }
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.project);
    }

    @NotNull
    private static Collection<VirtualFile> getFilesToBuildCachesForSafely(@NotNull ProgressIndicator indicator, final @NotNull FileSymbolTablesCache cache) {
        final Ref result = new Ref();
        OCSymbolTablesBuildingActivity.runReadActionSafely(indicator, new Runnable(){

            @Override
            public void run() {
                result.set(cache.getFilesToBuildTablesFor());
            }
        });
        return (Collection)result.get();
    }

    private static void runReadActionSafely(@NotNull ProgressIndicator indicator, final @NotNull Runnable runnable2) {
        OCSymbolTablesBuildingActivity.waitForCondition(indicator, new Condition(){

            public boolean value(Object o) {
                return ApplicationManagerEx.getApplicationEx().tryRunReadAction(runnable2);
            }
        });
    }

    private static void invokeAndWaitSafely(@NotNull ProgressIndicator indicator, final @NotNull Runnable runnable2) {
        final Semaphore s = new Semaphore(0);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            runnable2.run();
                        }
                        finally {
                            s.release();
                        }
                    }
                });
            }
        });
        OCSymbolTablesBuildingActivity.waitForCondition(indicator, new Condition(){

            public boolean value(Object o) {
                return s.tryAcquire();
            }
        });
    }

    private static void waitForCondition(@NotNull ProgressIndicator indicator, @NotNull Condition condition) {
        long sleep = 1L;
        while (true) {
            indicator.checkCanceled();
            if (condition.value(null)) break;
            try {
                Thread.sleep(sleep);
                sleep *= 2L;
                sleep = Math.min(sleep, 100L);
            }
            catch (InterruptedException ignore) {
                throw new ProcessCanceledException();
            }
        }
    }

    private static void processFutures(@NotNull Iterable<Future> tasks) {
        for (Future future2 : tasks) {
            try {
                future2.get();
            }
            catch (InterruptedException ignore) {
                return;
            }
            catch (ExecutionException e) {
                OCLog.LOG.error(e.getMessage());
            }
        }
    }

    private static <T> Future<?> createTask(final @NotNull TaskProvider<T> taskProvider, final @NotNull ProgressIndicator indicator) {
        return ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                assert (!mySymbolBuildingThreads.contains(currentThread)) : "Dedicated thread should be used for symbols building";
                mySymbolBuildingThreads.add(currentThread);
                try {
                    OCSymbolTablesBuildingActivity.processItemsInReadAction(taskProvider.getItemProvider(), taskProvider.getWorker(), indicator);
                }
                finally {
                    mySymbolBuildingThreads.remove(currentThread);
                }
            }
        });
    }

    private static <T> void processItemsInReadAction(@NotNull Producer<T> itemProvider, @NotNull Consumer<T> worker, @NotNull ProgressIndicator globalIndicator) {
        Object localProgress = ourIndicatorFactory != null ? (ProgressIndicator)ourIndicatorFactory.produce() : new SensitiveProgressWrapper(globalIndicator){

            @Override
            protected boolean isReuseable() {
                return true;
            }
        };
        ProgressManager.getInstance().runProcess(new Runnable((ProgressIndicator)localProgress, globalIndicator, (Producer)itemProvider, (Consumer)worker){
            final /* synthetic */ ProgressIndicator val$localProgress;
            final /* synthetic */ ProgressIndicator val$globalIndicator;
            final /* synthetic */ Producer val$itemProvider;
            final /* synthetic */ Consumer val$worker;
            {
                this.val$localProgress = progressIndicator;
                this.val$globalIndicator = progressIndicator2;
                this.val$itemProvider = producer;
                this.val$worker = consumer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ApplicationAdapter applicationListener = new ApplicationAdapter(){

                    public void beforeWriteActionStart(Object action) {
                        val$localProgress.cancel();
                    }

                    public void writeActionFinished(Object action) {
                        if (val$localProgress.isRunning()) {
                            val$localProgress.stop();
                        }
                        val$localProgress.start();
                    }
                };
                ApplicationManager.getApplication().addApplicationListener((ApplicationListener)applicationListener);
                try {
                    final Ref currentItem = new Ref();
                    while (!this.val$globalIndicator.isCanceled()) {
                        if (currentItem.get() == null) {
                            Object item = this.val$itemProvider.produce();
                            if (item == null) {
                                break;
                            }
                            currentItem.set(item);
                        }
                        OCSymbolTablesBuildingActivity.runReadActionSafely(this.val$globalIndicator, new Runnable(){

                            @Override
                            public void run() {
                                if (val$globalIndicator.isCanceled()) {
                                    return;
                                }
                                Object item = currentItem.get();
                                currentItem.set(null);
                                try {
                                    val$worker.consume(item);
                                }
                                catch (ProcessCanceledException ignore) {
                                    currentItem.set(item);
                                }
                                catch (Throwable e) {
                                    OCLog.LOG.error(e);
                                }
                            }
                        });
                    }
                }
                finally {
                    ApplicationManager.getApplication().removeApplicationListener((ApplicationListener)applicationListener);
                }
            }
        }, localProgress);
    }

    static {
        mySymbolBuildingThreads = ContainerUtil.newConcurrentSet();
        ACTIVITY_LOG = NotNullLazyKey.create((String)"SYMBOL ACTIVITY LOG", (NotNullFunction)new NotNullFunction<Project, List<String>>(){

            @NotNull
            public List<String> fun(Project dom) {
                return new ArrayList<String>();
            }
        });
    }

    public static interface TaskProvider<T> {
        public Producer<T> getItemProvider();

        public Consumer<T> getWorker();
    }

    private static class MyProgressIndicator
    extends DelegatingProgressIndicator {
        private double myFromFraction;
        private double myToFraction = 1.0;
        private String lastActivity;
        private long activityStarted;

        public MyProgressIndicator(@NotNull ProgressIndicator indicator) {
            super(indicator);
        }

        public void startTiming(String activity) {
            this.activityStarted = System.currentTimeMillis();
            this.lastActivity = activity;
        }

        public void setText(String text) {
            super.setText(text);
        }

        public void logTiming() {
            long now = System.currentTimeMillis();
            OCLog.LOG.info(this.lastActivity + " finished in " + (now - this.activityStarted) / 1000L + " s.");
        }

        public void setInterval(double from, double to) {
            this.myFromFraction = from;
            this.myToFraction = to;
        }

        public void setFraction(double fraction) {
            super.setFraction(this.myFromFraction + (this.myToFraction - this.myFromFraction) * fraction);
        }
    }

    private static class OCSymbolTableBuilder {
        private final ProgressIndicator myIndicator;
        private final MultiMap<OCBuildFileCategory, OCBuildFileDescriptor> myClusterization = new MultiMap();

        public OCSymbolTableBuilder(final @NotNull Project project2, @NotNull ProgressIndicator progressIndicator, @NotNull Collection<VirtualFile> files) {
            this.myIndicator = progressIndicator;
            final Iterator<VirtualFile> iterator = files.iterator();
            Producer<VirtualFile> provider = new Producer<VirtualFile>(){

                @Nullable
                public VirtualFile produce() {
                    return iterator.hasNext() ? (VirtualFile)iterator.next() : null;
                }
            };
            OCSymbolTablesBuildingActivity.processItemsInReadAction((Producer)provider, (Consumer)new Consumer<VirtualFile>(){

                public void consume(VirtualFile virtualFile) {
                    if (!virtualFile.isValid()) {
                        return;
                    }
                    PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                    if (file2 instanceof OCConfigurationOwner) {
                        OCLanguageKind kind = OCInclusionContextUtil.isNeedToFindRoot(file2) ? CLanguageKind.maxLanguage(project2) : ((OCConfigurationOwner)file2).getKind();
                        for (OCResolveConfiguration oCResolveConfiguration : OCInclusionContextUtil.getAllBuildConfigurationsForIndexing(virtualFile, project2)) {
                            OCBuildFileCategory traits = new OCBuildFileCategory(oCResolveConfiguration.getIndexingCluster(), kind);
                            OCBuildFileDescriptor fileDescriptor = new OCBuildFileDescriptor(oCResolveConfiguration, virtualFile, kind);
                            myClusterization.putValue((Object)traits, (Object)fileDescriptor);
                        }
                    }
                }
            }, progressIndicator);
        }

        public void processBuildFiles() {
            final int totalFilesCount = this.myClusterization.values().size();
            Set traits = this.myClusterization.keySet();
            ArrayList<Future> tasks = new ArrayList<Future>(traits.size());
            final AtomicInteger processedFiles = new AtomicInteger(0);
            final ArrayList<3> clusterProviders = new ArrayList<3>();
            HashSet notProcessedFiles = new HashSet();
            for (OCBuildFileCategory t : traits) {
                Collection files = Collections.unmodifiableCollection(this.myClusterization.get((Object)t));
                notProcessedFiles.addAll(files);
                final Iterator clusterIterator = files.iterator();
                clusterProviders.add(new BuildFileProvider((Set)notProcessedFiles){
                    final /* synthetic */ Set val$notProcessedFiles;
                    {
                        this.val$notProcessedFiles = set;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Nullable
                    public OCBuildFileDescriptor produce() {
                        while (clusterIterator.hasNext()) {
                            OCBuildFileDescriptor next = (OCBuildFileDescriptor)clusterIterator.next();
                            Set set = this.val$notProcessedFiles;
                            synchronized (set) {
                                if (this.val$notProcessedFiles.contains(next)) {
                                    this.val$notProcessedFiles.remove(next);
                                    return next;
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            final BuildFileProvider remainingProvider = new BuildFileProvider((Set)notProcessedFiles){
                final /* synthetic */ Set val$notProcessedFiles;
                {
                    this.val$notProcessedFiles = set;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public OCBuildFileDescriptor produce() {
                    Set set = this.val$notProcessedFiles;
                    synchronized (set) {
                        if (!this.val$notProcessedFiles.isEmpty()) {
                            OCBuildFileDescriptor next = (OCBuildFileDescriptor)this.val$notProcessedFiles.iterator().next();
                            this.val$notProcessedFiles.remove(next);
                            return next;
                        }
                    }
                    return null;
                }
            };
            for (int i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
                tasks.add(OCSymbolTablesBuildingActivity.createTask(new TaskProvider<OCBuildFileDescriptor>(){

                    @Override
                    public Producer<OCBuildFileDescriptor> getItemProvider() {
                        return new PrioritizedBuildFileProvider(clusterProviders, remainingProvider);
                    }

                    @Override
                    public Consumer<OCBuildFileDescriptor> getWorker() {
                        return new Consumer<OCBuildFileDescriptor>(){

                            public void consume(OCBuildFileDescriptor descriptor) {
                                OCImportGraph.buildSymbolAndRootHeaderCache(descriptor.myConfiguration, descriptor.myFile, descriptor.myLanguageKind, myIndicator);
                                myIndicator.setFraction((double)processedFiles.incrementAndGet() / (double)totalFilesCount);
                            }
                        };
                    }
                }, this.myIndicator));
            }
            OCSymbolTablesBuildingActivity.processFutures(tasks);
        }

        private static class PrioritizedBuildFileProvider
        implements BuildFileProvider {
            private boolean myUseClusters = true;
            private Producer<OCBuildFileDescriptor> myCurrentProvider;
            @NotNull
            private final Collection<BuildFileProvider> myProviders;
            @NotNull
            private final BuildFileProvider myBottomProvider;

            private PrioritizedBuildFileProvider(@NotNull Collection<BuildFileProvider> providers, @NotNull BuildFileProvider bottomProvider) {
                this.myProviders = providers;
                this.myBottomProvider = bottomProvider;
            }

            @Nullable
            public OCBuildFileDescriptor produce() {
                OCBuildFileDescriptor fromCluster = this.nextFromProviders();
                return fromCluster != null ? fromCluster : (OCBuildFileDescriptor)this.myBottomProvider.produce();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private OCBuildFileDescriptor nextFromProviders() {
                if (!this.myUseClusters) {
                    return null;
                }
                while (true) {
                    BuildFileProvider provider;
                    OCBuildFileDescriptor next;
                    if (this.myCurrentProvider != null && (next = (OCBuildFileDescriptor)this.myCurrentProvider.produce()) != null) {
                        return next;
                    }
                    Collection<BuildFileProvider> collection = this.myProviders;
                    synchronized (collection) {
                        Iterator<BuildFileProvider> iterator = this.myProviders.iterator();
                        if (!iterator.hasNext()) {
                            break;
                        }
                        provider = iterator.next();
                        iterator.remove();
                    }
                    this.myCurrentProvider = provider;
                }
                this.myUseClusters = false;
                return null;
            }
        }

        private static interface BuildFileProvider
        extends Producer<OCBuildFileDescriptor> {
        }

        private static final class OCBuildFileDescriptor {
            private final VirtualFile myFile;
            private final OCResolveConfiguration myConfiguration;
            private final OCLanguageKind myLanguageKind;

            private OCBuildFileDescriptor(OCResolveConfiguration configuration, VirtualFile file2, OCLanguageKind kind) {
                this.myConfiguration = configuration;
                this.myFile = file2;
                this.myLanguageKind = kind;
            }
        }

        private static final class OCBuildFileCategory {
            private final Object myConfigurationCluster;
            private final OCLanguageKind myKind;

            private OCBuildFileCategory(@Nullable Object configurationCluster, @Nullable OCLanguageKind kind) {
                this.myConfigurationCluster = configurationCluster;
                this.myKind = kind;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OCBuildFileCategory category = (OCBuildFileCategory)o;
                if (this.myKind != category.myKind) {
                    return false;
                }
                return !(this.myConfigurationCluster != null ? !this.myConfigurationCluster.equals(category.myConfigurationCluster) : category.myConfigurationCluster != null);
            }

            public int hashCode() {
                int result = this.myConfigurationCluster != null ? this.myConfigurationCluster.hashCode() : 0;
                result = 31 * result + (this.myKind != null ? this.myKind.hashCode() : 0);
                return result;
            }
        }
    }
}

