/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.NodeStructure;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCLazyElementBase;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCContextSignatureBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import org.jetbrains.annotations.NotNull;

public class OCSymbolTableProvider
extends SymbolTableProvider<OCFile> {
    @Override
    public boolean isSource(@NotNull PsiFile file2) {
        return file2 instanceof OCFile;
    }

    @Override
    public boolean isSource(@NotNull VirtualFile file2) {
        return file2.getFileType() == OCFileType.INSTANCE;
    }

    @Override
    @NotNull
    public FileSymbolTable calcTable(@NotNull OCFile file2, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText2(file2.getName());
        }
        Project project2 = file2.getProject();
        OCContextSignatureBuilder signatureBuilder = new OCContextSignatureBuilder(context.getLanguageKind());
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)OCLanguage.getInstance());
        assert (parserDefinition != null);
        OCInclusionContext currentFileContext = context.deriveButDontCopyTypes(false);
        currentFileContext.setSignatureBuilder(signatureBuilder);
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(currentFileContext, file2);
        String text = OCSymbolTableProvider.getFileText(file2, virtualFile);
        PsiBuilder b = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)lexer, (CharSequence)text);
        new OCParsing(b, (IElementType)OCTokenTypes.OC_FILE, OCParsing.BlockParsingMode.SKIP).parseFileContents();
        currentFileContext.setSignatureBuilder(null);
        assert (context.getLanguageKind() == currentFileContext.getLanguageKind());
        FlyweightCapableTreeStructure structure = b.getLightTree();
        FileSymbolTable answer = new FileSymbolTable(virtualFile, project2, signatureBuilder.build());
        return OCSymbolTableProvider.buildTable(file2, text, context, answer, structure, NodeStructure.LIGHTER_NODE_STRUCTURE);
    }

    @Override
    @NotNull
    public FileSymbolTable calcTableUsingPSI(@NotNull OCFile file2, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        FileSymbolTable answer = new FileSymbolTable(virtualFile, file2.getProject(), new ContextSignature());
        OCInclusionContext currentFileContext = context.deriveButDontCopyTypes(false);
        return OCSymbolTableProvider.buildTable(file2, file2.getText(), currentFileContext, answer, new ASTStructure((ASTNode)file2.getNode()){

            @Override
            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                return astNode instanceof OCLazyElementBase ? 0 : super.getChildren(astNode, into);
            }
        }, BuilderDriverBase.AST_NAMED_NODE_STRUCTURE);
    }

    private static <T> FileSymbolTable buildTable(OCFile file2, String text, OCInclusionContext context, final FileSymbolTable answer, FlyweightCapableTreeStructure<T> structure, NodeStructure<T> nodeStructure) {
        Processor<OCSymbol> builder = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                answer.append(symbol);
                return true;
            }
        };
        OCBuilderDriver<Object> driver = new OCBuilderDriver<Object>(file2, context, text, structure, nodeStructure, builder);
        driver.processDeclarationsList(structure.getRoot());
        answer.sortSymbols();
        return answer;
    }
}

