/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInternator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class OCNamesInternary {
    private static final OCInternator<String> STRING_INTERNATOR = new OCInternator<String>(){

        @Override
        @NotNull
        protected String valueToStore(@NotNull String original) {
            return new String(original);
        }
    };
    private static final ConcurrentMap<OCQualifiedName, OCQualifiedName> ourQualifiedNamesCache = ContainerUtil.createConcurrentWeakKeyWeakValueMap();

    private OCNamesInternary() {
    }

    public static String intern(@NotNull String text) {
        return STRING_INTERNATOR.intern(text);
    }

    public static OCQualifiedName intern(OCQualifiedName name) {
        OCQualifiedName value = (OCQualifiedName)ourQualifiedNamesCache.get(name);
        if (value != null) {
            return value;
        }
        for (OCQualifiedName current = name; current != null; current = current.getQualifier()) {
            if (!(current instanceof OCQualifiedNameWithArguments)) continue;
            return name;
        }
        return (OCQualifiedName)ConcurrencyUtil.cacheOrGet(ourQualifiedNamesCache, (Object)name, (Object)name);
    }
}

