/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCContextSignatureBuilder
implements OCInclusionContext.SignatureBuilder {
    public static final int START_TEMP_CAPACITY = 512;
    private final THashSet<String> myDefined = new THashSet();
    private final THashSet<String> myNotDefined = new THashSet();
    private final List<String> myPendingDefined = new ArrayList<String>(512);
    private final List<String> myPendingNotDefined = new ArrayList<String>(512);
    private final THashMap<String, Integer> myDefinitions = new THashMap();
    private final List<String> myPendingDefinitions = new ArrayList<String>(512);
    private final List<Integer> myPendingDefinitionHashes = new ArrayList<Integer>(512);
    @Nullable
    public final OCLanguageKind languageKind;
    private boolean myInConformMode;

    public OCContextSignatureBuilder(@Nullable OCLanguageKind kind) {
        this.languageKind = kind;
    }

    @Override
    public void setDefined(@NotNull String name, boolean isDefined) {
        String intName = OCNamesInternary.intern(name);
        if (this.myInConformMode) {
            if (isDefined) {
                this.myPendingDefined.add(intName);
            } else {
                this.myPendingNotDefined.add(intName);
            }
        } else if (isDefined) {
            this.myDefined.add((Object)intName);
        } else {
            this.myNotDefined.add((Object)intName);
        }
    }

    @Override
    public void setDefinition(@NotNull String name, @NotNull OCMacroSymbol result) {
        String intName = OCNamesInternary.intern(name);
        int substHash = result.getSubstitutionHash();
        if (this.myInConformMode) {
            this.myPendingDefinitions.add(intName);
            this.myPendingDefinitionHashes.add(substHash);
        } else {
            this.myDefinitions.put((Object)intName, (Object)substHash);
        }
    }

    @Override
    public void enterConformanceCheckMode() {
        this.resetPendingDefinitions();
        this.myInConformMode = true;
    }

    @Override
    public void exitConformanceCheckMode(boolean commit) {
        if (commit) {
            this.myDefined.addAll(this.myPendingDefined);
            this.myNotDefined.addAll(this.myPendingNotDefined);
            for (int i = 0; i < this.myPendingDefinitions.size(); ++i) {
                this.myDefinitions.put((Object)this.myPendingDefinitions.get(i), (Object)this.myPendingDefinitionHashes.get(i));
            }
        }
        this.resetPendingDefinitions();
        this.myInConformMode = false;
    }

    private void resetPendingDefinitions() {
        this.myPendingDefined.clear();
        this.myPendingNotDefined.clear();
        this.myPendingDefinitions.clear();
        this.myPendingDefinitionHashes.clear();
    }

    @NotNull
    public ContextSignature build() {
        for (String d : this.myDefined) {
            if (this.myDefinitions.containsKey((Object)d)) continue;
            this.myDefinitions.put((Object)d, null);
        }
        this.myDefined.clear();
        return new ContextSignature(this.languageKind, (Map<String, Integer>)this.myDefinitions, (Set<String>)this.myNotDefined);
    }
}

