/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.FastInput;
import com.esotericsoftware.kryo.io.FastOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.DefaultArraySerializers;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import com.esotericsoftware.minlog.Log;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCKeywordElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.impl.OCBlockExpressionImpl;
import com.jetbrains.cidr.lang.psi.impl.OCLambdaExpressionImpl;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.ProjectAndVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLabelSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLocalFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCBinaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCastExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCommaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCConditionalExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNewExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPostfixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPrefixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.NeverSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.OCJavaSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.symbols.symtable.SerializerProvider;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeMapper;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.util.OCNumber;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTableSerializer {
    private static final Logger LOG = Logger.getInstance(FileSymbolTableSerializer.class);
    private static final int CHUNK_SIZE = 65536;
    private final Kryo myKryo;
    private VirtualFile myCurrentFile;
    private Project myProject;

    public FileSymbolTableSerializer(Project project2) {
        this.myProject = project2;
        this.myKryo = new Kryo(){

            public <T> T newInstance(Class<T> type) {
                LOG.error("Serializing default type: " + type);
                return (T)super.newInstance(type);
            }
        };
        this.configureKryo();
    }

    void configureKryo() {
        this.myKryo.setAutoReset(true);
        this.myKryo.setRegistrationRequired(true);
        Log.set((int)4);
        this.myKryo.register(FileSymbolTablesPack.class, (Serializer)new FileSymbolTablesPack.FileSymbolsPackSerializer(this.myKryo));
        this.myKryo.register(String.class, (Serializer)new DefaultSerializers.StringSerializer(){

            public String read(Kryo kryo, Input input, Class<String> type) {
                return OCNamesInternary.intern(super.read(kryo, input, type));
            }
        });
        this.myKryo.register(ArrayList.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new ArrayList();
            }
        });
        this.myKryo.register(java.util.HashMap.class, (Serializer)new MapSerializer(){

            protected Map create(Kryo kryo, Input input, Class<Map> type) {
                return new java.util.HashMap();
            }
        });
        this.myKryo.register(HashMap.class, (Serializer)new MapSerializer(){

            protected Map create(Kryo kryo, Input input, Class<Map> type) {
                return new HashMap();
            }
        });
        this.myKryo.register(com.intellij.util.containers.HashMap.class, (Serializer)new MapSerializer(){

            protected Map create(Kryo kryo, Input input, Class<Map> type) {
                return new com.intellij.util.containers.HashMap();
            }
        });
        this.myKryo.register(HashSet.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new HashSet();
            }
        });
        this.myKryo.register(com.intellij.util.containers.HashSet.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new com.intellij.util.containers.HashSet();
            }
        });
        this.myKryo.register(THashSet.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new THashSet();
            }
        });
        this.myKryo.register(Set.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new HashSet();
            }
        });
        this.myKryo.register(THashMap.class, (Serializer)new MapSerializer(){

            protected Map create(Kryo kryo, Input input, Class<Map> type) {
                return new THashMap();
            }
        });
        this.myKryo.register(TObjectIntHashMap.class, (Serializer)new OCJavaSerializer());
        this.myKryo.register(ContextSignature.class, (Serializer)new FieldSerializer<ContextSignature>(this.myKryo, ContextSignature.class){

            protected ContextSignature create(Kryo kryo, Input input, Class<ContextSignature> type) {
                return new ContextSignature();
            }
        });
        this.myKryo.register(FileSymbolTable.class, (Serializer)new ProjectAndFileOwnerSerializer<FileSymbolTable>(FileSymbolTable.class){

            @Override
            public FileSymbolTable createInstance(Kryo kryo, Input input, Class type) {
                return new FileSymbolTable();
            }
        });
        this.myKryo.register(OCQualifiedName.class, (Serializer)new Serializer<OCQualifiedName>(true){

            public void write(Kryo kryo, Output output, OCQualifiedName object) {
                kryo.writeClassAndObject(output, (Object)object.getQualifier());
                kryo.writeObjectOrNull(output, (Object)object.getName(), String.class);
            }

            public OCQualifiedName read(Kryo kryo, Input input, Class<OCQualifiedName> type) {
                OCQualifiedName qualifier = (OCQualifiedName)kryo.readClassAndObject(input);
                String name = (String)kryo.readObjectOrNull(input, String.class);
                return OCQualifiedName.interned(qualifier, name);
            }
        });
        this.myKryo.register(OCQualifiedNameWithArguments.class, (Serializer)new FieldSerializer<OCQualifiedNameWithArguments>(this.myKryo, OCQualifiedNameWithArguments.class){

            protected OCQualifiedNameWithArguments create(Kryo kryo, Input input, Class<OCQualifiedNameWithArguments> type) {
                return new OCQualifiedNameWithArguments();
            }
        });
        this.myKryo.register(OCImplementationSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCImplementationSymbol>(OCImplementationSymbol.class){

            @Override
            public OCImplementationSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCImplementationSymbol();
            }
        });
        this.myKryo.register(OCInterfaceSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCInterfaceSymbolImpl>(OCInterfaceSymbolImpl.class){

            @Override
            public OCInterfaceSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCInterfaceSymbolImpl();
            }
        });
        this.myKryo.register(OCProtocolSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCProtocolSymbolImpl>(OCProtocolSymbolImpl.class){

            @Override
            public OCProtocolSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCProtocolSymbolImpl();
            }
        });
        this.myKryo.register(OCLabelSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCLabelSymbol>(OCLabelSymbol.class){

            @Override
            public OCLabelSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCLabelSymbol();
            }
        });
        this.myKryo.register(OCMacroParameterSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCMacroParameterSymbol>(OCMacroParameterSymbol.class){

            @Override
            public OCMacroParameterSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCMacroParameterSymbol();
            }
        });
        this.myKryo.register(OCMacroSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCMacroSymbol>(OCMacroSymbol.class){

            @Override
            public OCMacroSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCMacroSymbol();
            }
        });
        this.myKryo.register(OCInstanceVariableSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCInstanceVariableSymbolImpl>(OCInstanceVariableSymbolImpl.class){

            @Override
            public OCInstanceVariableSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCInstanceVariableSymbolImpl();
            }
        });
        this.myKryo.register(OCMethodSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCMethodSymbolImpl>(OCMethodSymbolImpl.class){

            @Override
            public OCMethodSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCMethodSymbolImpl();
            }
        });
        this.myKryo.register(OCPropertySymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCPropertySymbolImpl>(OCPropertySymbolImpl.class){

            @Override
            public OCPropertySymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCPropertySymbolImpl();
            }
        });
        this.myKryo.register(OCSynthesizeSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCSynthesizeSymbol>(OCSynthesizeSymbol.class){

            @Override
            public OCSynthesizeSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCSynthesizeSymbol();
            }
        });
        this.myKryo.register(OCDeclaratorSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCDeclaratorSymbol>(OCDeclaratorSymbol.class){

            @Override
            public OCDeclaratorSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCDeclaratorSymbol();
            }
        });
        this.myKryo.register(OCFunctionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCFunctionSymbol>(OCFunctionSymbol.class){

            @Override
            public OCFunctionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCFunctionSymbol();
            }
        });
        this.myKryo.register(OCLocalFunctionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCLocalFunctionSymbol>(OCLocalFunctionSymbol.class){

            @Override
            public OCLocalFunctionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCLocalFunctionSymbol();
            }
        });
        this.myKryo.register(OCNamespaceSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCNamespaceSymbol>(OCNamespaceSymbol.class){

            @Override
            public OCNamespaceSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCNamespaceSymbol();
            }
        });
        this.myKryo.register(OCNamespaceAliasSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCNamespaceAliasSymbol>(OCNamespaceAliasSymbol.class){

            @Override
            public OCNamespaceAliasSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCNamespaceAliasSymbol();
            }
        });
        this.myKryo.register(OCStructSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCStructSymbol>(OCStructSymbol.class){

            @Override
            public OCStructSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCStructSymbol();
            }
        });
        this.myKryo.register(OCTypeParameterTypeSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCTypeParameterTypeSymbol>(OCTypeParameterTypeSymbol.class){

            @Override
            public OCTypeParameterTypeSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCTypeParameterTypeSymbol();
            }
        });
        this.myKryo.register(OCTypeParameterValueSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCTypeParameterValueSymbol>(OCTypeParameterValueSymbol.class){

            @Override
            public OCTypeParameterValueSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCTypeParameterValueSymbol();
            }
        });
        this.myKryo.register(OCBinaryExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCBinaryExpressionSymbol>(OCBinaryExpressionSymbol.class){

            @Override
            public OCBinaryExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCBinaryExpressionSymbol();
            }
        });
        this.myKryo.register(OCUnaryExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCUnaryExpressionSymbol>(OCUnaryExpressionSymbol.class){

            @Override
            public OCUnaryExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCUnaryExpressionSymbol();
            }
        });
        this.myKryo.register(OCPrefixExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCPrefixExpressionSymbol>(OCPrefixExpressionSymbol.class){

            @Override
            public OCPrefixExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCPrefixExpressionSymbol();
            }
        });
        this.myKryo.register(OCPostfixExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCPostfixExpressionSymbol>(OCPostfixExpressionSymbol.class){

            @Override
            public OCPostfixExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCPostfixExpressionSymbol();
            }
        });
        this.myKryo.register(OCConditionalExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCConditionalExpressionSymbol>(OCConditionalExpressionSymbol.class){

            @Override
            public OCConditionalExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCConditionalExpressionSymbol();
            }
        });
        this.myKryo.register(OCCallExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCCallExpressionSymbol>(OCCallExpressionSymbol.class){

            @Override
            public OCCallExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCCallExpressionSymbol();
            }
        });
        this.myKryo.register(OCCastExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCCastExpressionSymbol>(OCCastExpressionSymbol.class){

            @Override
            public OCCastExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCCastExpressionSymbol();
            }
        });
        this.myKryo.register(OCNewExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCNewExpressionSymbol>(OCNewExpressionSymbol.class){

            @Override
            public OCNewExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCNewExpressionSymbol();
            }
        });
        this.myKryo.register(OCSizeofExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCSizeofExpressionSymbol>(OCSizeofExpressionSymbol.class){

            @Override
            public OCSizeofExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCSizeofExpressionSymbol();
            }
        });
        this.myKryo.register(OCLiteralExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCLiteralExpressionSymbol>(OCLiteralExpressionSymbol.class){

            @Override
            public OCLiteralExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCLiteralExpressionSymbol();
            }
        });
        this.myKryo.register(OCInitializerListExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCInitializerListExpressionSymbol>(OCInitializerListExpressionSymbol.class){

            @Override
            public OCInitializerListExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCInitializerListExpressionSymbol();
            }
        });
        this.myKryo.register(OCCommaExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCCommaExpressionSymbol>(OCCommaExpressionSymbol.class){

            @Override
            public OCCommaExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCCommaExpressionSymbol();
            }
        });
        this.myKryo.register(OCLambdaExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCLambdaExpressionSymbol>(OCLambdaExpressionSymbol.class){

            @Override
            public OCLambdaExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCLambdaExpressionSymbol();
            }
        });
        this.myKryo.register(OCReferenceExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCReferenceExpressionSymbol>(OCReferenceExpressionSymbol.class){

            @Override
            public OCReferenceExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCReferenceExpressionSymbol();
            }
        });
        this.myKryo.register(OCQualifiedExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCQualifiedExpressionSymbol>(OCQualifiedExpressionSymbol.class){

            @Override
            public OCQualifiedExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCQualifiedExpressionSymbol();
            }
        });
        this.myKryo.register(OCUnknownExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCUnknownExpressionSymbol>(OCUnknownExpressionSymbol.class){

            @Override
            public OCUnknownExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCUnknownExpressionSymbol();
            }
        });
        this.myKryo.register(OCUndefMacroSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCUndefMacroSymbol>(OCUndefMacroSymbol.class){

            @Override
            public OCUndefMacroSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCUndefMacroSymbol();
            }
        });
        this.myKryo.register(OCUsingSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCUsingSymbol>(OCUsingSymbol.class){

            @Override
            public OCUsingSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCUsingSymbol();
            }
        });
        this.myKryo.register(OCAliasUsingSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCAliasUsingSymbol>(OCAliasUsingSymbol.class){

            @Override
            public OCAliasUsingSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCAliasUsingSymbol();
            }
        });
        this.myKryo.register(OCCompatibilityAliasSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCCompatibilityAliasSymbol>(OCCompatibilityAliasSymbol.class){

            @Override
            public OCCompatibilityAliasSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCCompatibilityAliasSymbol();
            }
        });
        this.myKryo.register(OCLambdaExpressionImpl.OCLambdaSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCLambdaExpressionImpl.OCLambdaSymbol>(OCLambdaExpressionImpl.OCLambdaSymbol.class){

            @Override
            public OCLambdaExpressionImpl.OCLambdaSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCLambdaExpressionImpl.OCLambdaSymbol();
            }
        });
        this.myKryo.register(OCBlockExpressionImpl.OCBlockSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCBlockExpressionImpl.OCBlockSymbol>(OCBlockExpressionImpl.OCBlockSymbol.class){

            @Override
            public OCBlockExpressionImpl.OCBlockSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCBlockExpressionImpl.OCBlockSymbol();
            }
        });
        this.myKryo.register(OCThisSelfSuperSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCThisSelfSuperSymbol>(OCThisSelfSuperSymbol.class){

            @Override
            public OCThisSelfSuperSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCThisSelfSuperSymbol();
            }
        });
        this.myKryo.register(OCPunctuatorElementType.class, (Serializer)new Serializer<OCPunctuatorElementType>(){

            public void write(Kryo kryo, Output output, OCPunctuatorElementType elementType) {
                output.writeString(elementType.toString());
            }

            public OCPunctuatorElementType read(Kryo kryo, Input input, Class<OCPunctuatorElementType> type) {
                return (OCPunctuatorElementType)OCTokenTypes.ourNameToTokenType.get(input.readString());
            }
        });
        this.myKryo.register(OCElementType.class, (Serializer)new Serializer<OCElementType>(){

            public void write(Kryo kryo, Output output, OCElementType elementType) {
                output.writeString(elementType.toString());
            }

            public OCElementType read(Kryo kryo, Input input, Class<OCElementType> type) {
                return OCTokenTypes.ourNameToTokenType.get(input.readString());
            }
        });
        this.myKryo.register(OCKeywordElementType.class, (Serializer)new Serializer<OCKeywordElementType>(){

            public void write(Kryo kryo, Output output, OCKeywordElementType elementType) {
                output.writeString(elementType.toString());
            }

            public OCKeywordElementType read(Kryo kryo, Input input, Class<OCKeywordElementType> type) {
                return (OCKeywordElementType)OCTokenTypes.ourNameToTokenType.get(input.readString());
            }
        });
        this.myKryo.register(OCMethodSymbolImpl.SelectorPartSymbolImpl.class, (Serializer)new FieldSerializer<OCMethodSymbolImpl.SelectorPartSymbolImpl>(this.myKryo, OCMethodSymbolImpl.SelectorPartSymbolImpl.class){

            protected OCMethodSymbolImpl.SelectorPartSymbolImpl create(Kryo kryo, Input input, Class<OCMethodSymbolImpl.SelectorPartSymbolImpl> type) {
                return new OCMethodSymbolImpl.SelectorPartSymbolImpl();
            }
        });
        this.myKryo.register(OCSymbolReference.class, (Serializer)new FieldSerializer(this.myKryo, OCSymbolReference.class));
        this.myKryo.register(OCSymbolReference.SymbolFilter.class, (Serializer)new FieldSerializer(this.myKryo, OCSymbolReference.SymbolFilter.class));
        this.myKryo.register(OCSymbolReference.TrueSymbolFilter.class, (Serializer)new FieldSerializer<OCSymbolReference.TrueSymbolFilter>(this.myKryo, OCSymbolReference.TrueSymbolFilter.class){

            protected OCSymbolReference.TrueSymbolFilter create(Kryo kryo, Input input, Class<OCSymbolReference.TrueSymbolFilter> type) {
                return new OCSymbolReference.TrueSymbolFilter();
            }

            public OCSymbolReference.TrueSymbolFilter read(Kryo kryo, Input input, Class<OCSymbolReference.TrueSymbolFilter> type) {
                return OCSymbolReference.SymbolFilter.NONE;
            }
        });
        this.myKryo.register(OCSymbolReference.SymbolKindFilter.class, (Serializer)new DefaultSerializers.EnumSerializer(OCSymbolReference.SymbolKindFilter.class));
        this.myKryo.register(OCSymbolReference.GlobalReference.class, (Serializer)new FieldSerializer<OCSymbolReference.GlobalReference>(this.myKryo, OCSymbolReference.GlobalReference.class){

            protected OCSymbolReference.GlobalReference create(Kryo kryo, Input input, Class<OCSymbolReference.GlobalReference> type) {
                return new OCSymbolReference.GlobalReference();
            }
        });
        this.myKryo.register(OCSymbolReference.BaseClauseReference.class, (Serializer)new FieldSerializer<OCSymbolReference.BaseClauseReference>(this.myKryo, OCSymbolReference.BaseClauseReference.class){

            protected OCSymbolReference.BaseClauseReference create(Kryo kryo, Input input, Class<OCSymbolReference.BaseClauseReference> type) {
                return new OCSymbolReference.BaseClauseReference();
            }
        });
        this.myKryo.register(OCSymbolReference.TemplateParamsReference.class, (Serializer)new FieldSerializer<OCSymbolReference.TemplateParamsReference>(this.myKryo, OCSymbolReference.TemplateParamsReference.class){

            protected OCSymbolReference.TemplateParamsReference create(Kryo kryo, Input input, Class<OCSymbolReference.TemplateParamsReference> type) {
                return new OCSymbolReference.TemplateParamsReference();
            }
        });
        this.myKryo.register(OCSymbolReference.LocalReference.class, (Serializer)new NeverSerializer(this.myKryo, OCSymbolReference.LocalReference.class));
        this.myKryo.register(PsiElement.class, (Serializer)new NeverSerializer(this.myKryo, PsiElement.class));
        this.myKryo.register(OCTypeArgument.class, (Serializer)new FieldSerializer(this.myKryo, OCTypeArgument.class));
        this.myKryo.register(OCExpressionTypeArgument.class, (Serializer)new FieldSerializer<OCExpressionTypeArgument>(this.myKryo, OCExpressionTypeArgument.class){

            protected OCExpressionTypeArgument create(Kryo kryo, Input input, Class<OCExpressionTypeArgument> type) {
                return new OCExpressionTypeArgument();
            }
        });
        this.myKryo.register(OCType.class, (Serializer)new FieldSerializer(this.myKryo, OCType.class));
        this.myKryo.register(OCCppReferenceType.class, (Serializer)new FieldSerializer<OCCppReferenceType>(this.myKryo, OCCppReferenceType.class){

            protected OCCppReferenceType create(Kryo kryo, Input input, Class<OCCppReferenceType> type) {
                return new OCCppReferenceType();
            }
        });
        this.myKryo.register(OCEllipsisType.class, new SingletonSerializer<OCEllipsisType>(OCEllipsisType.instance()));
        this.myKryo.register(OCFunctionType.class, (Serializer)new FieldSerializer<OCFunctionType>(this.myKryo, OCFunctionType.class){

            protected OCFunctionType create(Kryo kryo, Input input, Class<OCFunctionType> type) {
                return new OCFunctionType();
            }
        });
        this.myKryo.register(OCMagicType.class, (Serializer)new FieldSerializer<OCMagicType>(this.myKryo, OCMagicType.class){

            protected OCMagicType create(Kryo kryo, Input input, Class<OCMagicType> type) {
                return new OCMagicType();
            }
        });
        this.myKryo.register(OCTypeParameterType.class, (Serializer)new FieldSerializer(this.myKryo, OCTypeParameterType.class));
        this.myKryo.register(OCUnknownType.class, new SingletonSerializer<OCUnknownType>(OCUnknownType.INSTANCE));
        this.myKryo.register(OCNumericType.class, (Serializer)new FieldSerializer(this.myKryo, OCNumericType.class));
        this.myKryo.register(OCIntType.class, (Serializer)new FieldSerializer<OCIntType>(this.myKryo, OCIntType.class){

            protected OCIntType create(Kryo kryo, Input input, Class<OCIntType> type) {
                return new OCIntType();
            }
        });
        this.myKryo.register(OCTypeMapper.CTypeId.class, (Serializer)new DefaultSerializers.EnumSerializer(OCTypeMapper.CTypeId.class));
        this.myKryo.register(OCRealType.class, (Serializer)new FieldSerializer<OCRealType>(this.myKryo, OCRealType.class){

            protected OCRealType create(Kryo kryo, Input input, Class<OCRealType> type) {
                return new OCRealType();
            }
        });
        this.myKryo.register(OCObjectType.class, (Serializer)new FieldSerializer<OCObjectType>(this.myKryo, OCObjectType.class){

            protected OCObjectType create(Kryo kryo, Input input, Class<OCObjectType> type) {
                return new OCObjectType();
            }
        });
        this.myKryo.register(OCIdType.class, (Serializer)new FieldSerializer<OCIdType>(this.myKryo, OCIdType.class){

            protected OCIdType create(Kryo kryo, Input input, Class<OCIdType> type) {
                return new OCIdType();
            }
        });
        this.myKryo.register(OCIdType.IDInterfaceSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCIdType.IDInterfaceSymbol>(OCIdType.IDInterfaceSymbol.class){

            @Override
            public OCIdType.IDInterfaceSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCIdType.IDInterfaceSymbol();
            }
        });
        this.myKryo.register(OCPointerType.class, (Serializer)new FieldSerializer<OCPointerType>(this.myKryo, OCPointerType.class){

            protected OCPointerType create(Kryo kryo, Input input, Class<OCPointerType> type) {
                return new OCPointerType();
            }
        });
        this.myKryo.register(OCBlockPointerType.class, (Serializer)new FieldSerializer<OCBlockPointerType>(this.myKryo, OCBlockPointerType.class){

            protected OCBlockPointerType create(Kryo kryo, Input input, Class<OCBlockPointerType> type) {
                return new OCBlockPointerType();
            }
        });
        this.myKryo.register(OCReferenceType.class, (Serializer)new FieldSerializer<OCReferenceType>(this.myKryo, OCReferenceType.class){

            protected OCReferenceType create(Kryo kryo, Input input, Class<OCReferenceType> type) {
                return new OCReferenceType();
            }
        });
        this.myKryo.register(OCStructType.class, (Serializer)new FieldSerializer<OCStructType>(this.myKryo, OCStructType.class){

            protected OCStructType create(Kryo kryo, Input input, Class<OCStructType> type) {
                return new OCStructType();
            }
        });
        this.myKryo.register(OCVoidType.class, (Serializer)new Serializer<OCVoidType>(){

            public void write(Kryo kryo, Output output, OCVoidType object) {
                output.writeBoolean(object.isConst());
                output.writeBoolean(object.isVolatile());
            }

            public OCVoidType read(Kryo kryo, Input input, Class<OCVoidType> type) {
                return OCVoidType.instance(input.readBoolean(), input.readBoolean());
            }
        });
        this.myKryo.register(OCAutoType.class, (Serializer)new FieldSerializer<OCAutoType>(this.myKryo, OCAutoType.class){

            public OCAutoType create(Kryo kryo, Input input, Class<OCAutoType> type) {
                return new OCAutoType();
            }
        });
        this.myKryo.register(OCArrayType.class, (Serializer)new FieldSerializer<OCArrayType>(this.myKryo, OCArrayType.class){

            protected OCArrayType create(Kryo kryo, Input input, Class<OCArrayType> type) {
                return new OCArrayType();
            }
        });
        this.myKryo.register(OCExpansionPackType.class, (Serializer)new FieldSerializer<OCExpansionPackType>(this.myKryo, OCExpansionPackType.class){

            protected OCExpansionPackType create(Kryo kryo, Input input, Class<OCExpansionPackType> type) {
                return new OCExpansionPackType();
            }
        });
        this.myKryo.register(OCVariadicType.class, (Serializer)new FieldSerializer<OCVariadicType>(this.myKryo, OCVariadicType.class){

            protected OCVariadicType create(Kryo kryo, Input input, Class<OCVariadicType> type) {
                return new OCVariadicType();
            }
        });
        this.myKryo.register(OCVariadicPackExpressionSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCVariadicPackExpressionSymbol>(OCVariadicPackExpressionSymbol.class){

            @Override
            public OCVariadicPackExpressionSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCVariadicPackExpressionSymbol();
            }
        });
        this.myKryo.register(OCSimpleTypeSubstitution.class, (Serializer)new FieldSerializer<OCSimpleTypeSubstitution>(this.myKryo, OCSimpleTypeSubstitution.class){

            protected OCSimpleTypeSubstitution create(Kryo kryo, Input input, Class<OCSimpleTypeSubstitution> type) {
                return new OCSimpleTypeSubstitution();
            }

            public OCSimpleTypeSubstitution read(Kryo kryo, Input input, Class<OCSimpleTypeSubstitution> type) {
                boolean isId = input.readBoolean();
                if (isId) {
                    return OCTypeSubstitution.ID;
                }
                return (OCSimpleTypeSubstitution)super.read(kryo, input, type);
            }

            public void write(Kryo kryo, Output output, OCSimpleTypeSubstitution object) {
                boolean isId = object == OCTypeSubstitution.ID;
                output.writeBoolean(isId);
                if (!isId) {
                    super.write(kryo, output, (Object)object);
                }
            }
        });
        this.myKryo.register(ARCAttribute.class, (Serializer)new DefaultSerializers.EnumSerializer(ARCAttribute.class));
        this.myKryo.register(OCSymbolKind.class, (Serializer)new DefaultSerializers.EnumSerializer(OCSymbolKind.class));
        this.myKryo.register(OCIncludeSymbol.class, (Serializer)new ProjectAndFileOwnerSerializer<OCIncludeSymbol>(OCIncludeSymbol.class){

            @Override
            public OCIncludeSymbol createInstance(Kryo kryo, Input input, Class type) {
                return new OCIncludeSymbol();
            }

            @Override
            public void write(Kryo kryo, Output output, OCIncludeSymbol object) {
                String path;
                int id;
                super.write(kryo, output, object);
                VirtualFile targetFile = object.getTargetFile();
                if (targetFile != null && targetFile.isValid()) {
                    if (targetFile instanceof VirtualFileWithId) {
                        id = ((VirtualFileWithId)targetFile).getId();
                        path = targetFile.getPath();
                    } else {
                        id = -1;
                        path = CustomHeaderProvider.provideSerializationPathForFile(targetFile);
                        if (path == null) {
                            LOG.error("only LocalVirtualFiles are supported: " + targetFile.getClass() + ": " + targetFile);
                        }
                    }
                } else {
                    id = -1;
                    path = null;
                }
                output.writeInt(id, true);
                output.writeString(path);
            }

            public OCIncludeSymbol read(Kryo kryo, Input input, Class<OCIncludeSymbol> type) {
                OCIncludeSymbol include = (OCIncludeSymbol)super.read(kryo, input, type);
                int fileId = input.readInt(true);
                String path = input.readString();
                VirtualFile targetFile = null;
                if (fileId != -1) {
                    targetFile = PersistentFS.getInstance().findFileById(fileId);
                }
                if (!(path == null || targetFile != null && FileUtil.pathsEqual((String)path, (String)targetFile.getPath()) || (targetFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path)) != null)) {
                    targetFile = CustomHeaderProvider.getCustomHeaderFile(path, FileSymbolTableSerializer.this.myProject, FileSymbolTableSerializer.this.myCurrentFile);
                }
                include.updateTargetFile(targetFile);
                return include;
            }
        });
        this.myKryo.register(OCIncludeSymbol.IncludePath.class, (Serializer)new FieldSerializer<OCIncludeSymbol.IncludePath>(this.myKryo, OCIncludeSymbol.IncludePath.class){

            protected OCIncludeSymbol.IncludePath create(Kryo kryo, Input input, Class<OCIncludeSymbol.IncludePath> type) {
                return new OCIncludeSymbol.IncludePath();
            }
        });
        this.myKryo.register(OCIncludeSymbol.IncludePath.EMPTY.getClass(), new SingletonSerializer<OCIncludeSymbol.IncludePath>(OCIncludeSymbol.IncludePath.EMPTY));
        this.myKryo.register(EnumMap.class, (Serializer)new OCJavaSerializer());
        List utilEmptyList = ContainerUtilRt.emptyList();
        this.myKryo.register(utilEmptyList.getClass(), new SingletonSerializer<List>(utilEmptyList));
        MostlySingularMultiMap msEmptyMultiMap = MostlySingularMultiMap.emptyMap();
        this.myKryo.register(msEmptyMultiMap.getClass(), new SingletonSerializer<MostlySingularMultiMap>(msEmptyMultiMap));
        MultiMap emptyMultiMap = MultiMap.EMPTY;
        this.myKryo.register(emptyMultiMap.getClass(), new SingletonSerializer<MultiMap>(emptyMultiMap));
        this.myKryo.register(OCPropertySymbol.PropertyAttribute.class, (Serializer)new DefaultSerializers.EnumSerializer(OCPropertySymbol.PropertyAttribute.class));
        this.myKryo.register(OCVisibility.class, (Serializer)new DefaultSerializers.EnumSerializer(OCVisibility.class));
        this.myKryo.register(Pair.class, (Serializer)new FieldSerializer<Pair>(this.myKryo, Pair.class){

            protected Pair create(Kryo kryo, Input input, Class<Pair> type) {
                return new Pair(null, null);
            }
        });
        this.myKryo.register(MostlySingularMultiMap.class, (Serializer)new FieldSerializer<MostlySingularMultiMap>(this.myKryo, MostlySingularMultiMap.class){

            protected MostlySingularMultiMap create(Kryo kryo, Input input, Class<MostlySingularMultiMap> type) {
                return new MostlySingularMultiMap();
            }
        });
        this.myKryo.register(TextRange.class, (Serializer)new Serializer<TextRange>(){

            public void write(Kryo kryo, Output output, TextRange object) {
                output.writeInt(object.getStartOffset(), true);
                output.writeInt(object.getEndOffset(), true);
            }

            public TextRange read(Kryo kryo, Input input, Class<TextRange> type) {
                int startOffset = input.readInt(true);
                int endOffset = input.readInt(true);
                return new TextRange(startOffset, endOffset);
            }
        });
        this.myKryo.register(OCNumber.class, (Serializer)new Serializer<OCNumber>(){

            public void write(Kryo kryo, Output output, OCNumber object) {
                output.writeByte(object.getSizeInBytes());
                output.writeBoolean(object.isSigned());
                byte[] bytes = object.toByteArray();
                output.writeByte(bytes.length);
                if (bytes.length > 0) {
                    output.write(bytes);
                }
            }

            public OCNumber read(Kryo kryo, Input input, Class<OCNumber> type) {
                byte sizeInBytes = input.readByte();
                boolean isSigned = input.readBoolean();
                byte length = input.readByte();
                byte[] bytes = new byte[length];
                input.readBytes(bytes);
                return new OCNumber(bytes, (int)sizeInBytes, isSigned);
            }
        });
        this.myKryo.register(FileSymbolTablesCache.MetaData.class, (Serializer)new FieldSerializer<FileSymbolTablesCache.MetaData>(this.myKryo, FileSymbolTablesCache.MetaData.class){

            protected FileSymbolTablesCache.MetaData create(Kryo kryo, Input input, Class<FileSymbolTablesCache.MetaData> type) {
                return new FileSymbolTablesCache.MetaData();
            }
        });
        this.myKryo.register(OCGenericParameterSymbol.Covariance.class, (Serializer)new DefaultSerializers.EnumSerializer(OCGenericParameterSymbol.Covariance.class));
        this.myKryo.register(OCGenericParameterSymbolImpl.class, (Serializer)new ProjectAndFileOwnerSerializer<OCGenericParameterSymbolImpl>(OCGenericParameterSymbolImpl.class){

            @Override
            public OCGenericParameterSymbolImpl createInstance(Kryo kryo, Input input, Class type) {
                return new OCGenericParameterSymbolImpl();
            }
        });
        this.myKryo.register(OCImmutableList.class, (Serializer)new FieldSerializer<OCImmutableList>(this.myKryo, OCImmutableList.class){

            public void write(Kryo kryo, Output output, OCImmutableList l) {
                boolean hasElements = l.size() > 0;
                output.writeBoolean(hasElements);
                if (hasElements) {
                    super.write(kryo, output, (Object)l);
                }
            }

            public OCImmutableList read(Kryo kryo, Input input, Class<OCImmutableList> type) {
                boolean hasElements = input.readBoolean();
                return hasElements ? (OCImmutableList)((Object)super.read(kryo, input, type)) : OCImmutableList.emptyList();
            }

            protected OCImmutableList create(Kryo kryo, Input input, Class<OCImmutableList> type) {
                return new OCImmutableList(Collections.emptyList());
            }
        });
        this.registerCustomSerializers();
        FileSymbolTableSerializer.registerDefaultSerializers(this.myKryo);
    }

    private void registerCustomSerializers() {
        for (SerializerProvider provider : (SerializerProvider[])SerializerProvider.EP_NAME.getExtensions()) {
            provider.registerSerializers(this);
        }
    }

    public Kryo getKryo() {
        return this.myKryo;
    }

    private static void registerDefaultSerializers(Kryo kryo) {
        kryo.register(byte[].class, (Serializer)new DefaultArraySerializers.ByteArraySerializer());
        kryo.register(char[].class, (Serializer)new DefaultArraySerializers.CharArraySerializer());
        kryo.register(short[].class, (Serializer)new DefaultArraySerializers.ShortArraySerializer());
        kryo.register(int[].class, (Serializer)new DefaultArraySerializers.IntArraySerializer());
        kryo.register(long[].class, (Serializer)new DefaultArraySerializers.LongArraySerializer());
        kryo.register(float[].class, (Serializer)new DefaultArraySerializers.FloatArraySerializer());
        kryo.register(double[].class, (Serializer)new DefaultArraySerializers.DoubleArraySerializer());
        kryo.register(boolean[].class, (Serializer)new DefaultArraySerializers.BooleanArraySerializer());
        kryo.register(String[].class, (Serializer)new DefaultArraySerializers.StringArraySerializer());
        kryo.register(Object[].class, (Serializer)new DefaultArraySerializers.ObjectArraySerializer(kryo, Object[].class));
        kryo.register(BigInteger.class, (Serializer)new DefaultSerializers.BigIntegerSerializer());
        kryo.register(BigDecimal.class, (Serializer)new DefaultSerializers.BigDecimalSerializer());
        kryo.register(Class.class, (Serializer)new DefaultSerializers.ClassSerializer());
        kryo.register(Date.class, (Serializer)new DefaultSerializers.DateSerializer());
        kryo.register(EnumSet.class, (Serializer)new DefaultSerializers.EnumSetSerializer());
        try {
            kryo.register(Class.forName("java.util.RegularEnumSet"), (Serializer)new DefaultSerializers.EnumSetSerializer());
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
        }
        kryo.register(Currency.class, (Serializer)new DefaultSerializers.CurrencySerializer());
        kryo.register(StringBuffer.class, (Serializer)new DefaultSerializers.StringBufferSerializer());
        kryo.register(StringBuilder.class, (Serializer)new DefaultSerializers.StringBuilderSerializer());
        kryo.register(Collections.EMPTY_LIST.getClass(), (Serializer)new DefaultSerializers.CollectionsEmptyListSerializer());
        kryo.register(Collections.EMPTY_MAP.getClass(), (Serializer)new DefaultSerializers.CollectionsEmptyMapSerializer());
        kryo.register(Collections.EMPTY_SET.getClass(), (Serializer)new DefaultSerializers.CollectionsEmptySetSerializer());
        kryo.register(Collections.singletonList(null).getClass(), (Serializer)new DefaultSerializers.CollectionsSingletonListSerializer());
        kryo.register(Collections.singletonMap(null, null).getClass(), (Serializer)new DefaultSerializers.CollectionsSingletonMapSerializer());
        kryo.register(Collections.singleton(null).getClass(), (Serializer)new DefaultSerializers.CollectionsSingletonSetSerializer());
        kryo.register(Collection.class, (Serializer)new CollectionSerializer());
        kryo.register(TreeMap.class, (Serializer)new DefaultSerializers.TreeMapSerializer());
        kryo.register(Map.class, (Serializer)new MapSerializer());
        kryo.register(KryoSerializable.class, (Serializer)new DefaultSerializers.KryoSerializableSerializer());
        kryo.register(TimeZone.class, (Serializer)new DefaultSerializers.TimeZoneSerializer());
        kryo.register(Calendar.class, (Serializer)new DefaultSerializers.CalendarSerializer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileSymbolTablesPack readSymbolTables(@NotNull DataInputStream dis, @NotNull VirtualFile file2) {
        this.myCurrentFile = file2;
        FastInput input = new FastInput((InputStream)dis, 65536);
        try {
            FileSymbolTablesPack fileSymbolTablesPack = (FileSymbolTablesPack)this.myKryo.readObject((Input)input, FileSymbolTablesPack.class);
            return fileSymbolTablesPack;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            FileSymbolTablesPack fileSymbolTablesPack = null;
            return fileSymbolTablesPack;
        }
        finally {
            StreamUtil.closeStream((Closeable)input);
        }
    }

    public void writeSymbolTables(@NotNull DataOutputStream dos, @NotNull FileSymbolTablesPack pack) {
        this.writeObject(dos, pack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(DataOutputStream dos, Object object) {
        FastOutput output = new FastOutput((OutputStream)dos, 65536);
        try {
            this.myKryo.writeObject((Output)output, object);
            output.flush();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            StreamUtil.closeStream((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileSymbolTablesCache.MetaData readMetaData(@NotNull DataInputStream dis) {
        FastInput input = new FastInput((InputStream)dis, 65536);
        try {
            FileSymbolTablesCache.MetaData metaData = (FileSymbolTablesCache.MetaData)this.myKryo.readObject((Input)input, FileSymbolTablesCache.MetaData.class);
            return metaData;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            FileSymbolTablesCache.MetaData metaData = null;
            return metaData;
        }
        finally {
            StreamUtil.closeStream((Closeable)input);
        }
    }

    public void writeMetaData(@NotNull DataOutputStream dos, @NotNull FileSymbolTablesCache.MetaData metaData) {
        this.writeObject(dos, metaData);
    }

    public static Map<String, OCElementType> getNameToElementTypeMap(TokenSet tokenSet) {
        java.util.HashMap<String, OCElementType> result = new java.util.HashMap<String, OCElementType>();
        for (IElementType type : tokenSet.getTypes()) {
            result.put(type.toString(), (OCElementType)type);
        }
        assert (result.size() == tokenSet.getTypes().length);
        return result;
    }

    public static class SingletonSerializer<T>
    extends Serializer<T> {
        @NotNull
        private final T myInstance;

        public SingletonSerializer(@NotNull T instance) {
            this.myInstance = instance;
        }

        public void write(Kryo kryo, Output output, T object) {
        }

        public T read(Kryo kryo, Input input, Class<T> type) {
            return this.myInstance;
        }
    }

    public abstract class ProjectAndFileOwnerSerializer<T extends ProjectAndVirtualFileOwner>
    extends FieldSerializer<T> {
        public ProjectAndFileOwnerSerializer(Class<T> symbolClass) {
            super(FileSymbolTableSerializer.this.myKryo, symbolClass);
        }

        public void write(Kryo kryo, Output output, T object) {
            output.writeBoolean(object.getProject() != null);
            output.writeBoolean(object.getContainingFile() != null);
            super.write(kryo, output, object);
        }

        public final T create(Kryo kryo, Input input, Class type) {
            boolean hasProject = input.readBoolean();
            boolean hasFile = input.readBoolean();
            T result = this.createInstance(kryo, input, type);
            result.init(hasProject ? FileSymbolTableSerializer.this.myProject : null, hasFile ? FileSymbolTableSerializer.this.myCurrentFile : null);
            return result;
        }

        public abstract T createInstance(Kryo var1, Input var2, Class var3);
    }
}

