/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.ProjectAndVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import gnu.trove.THashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTable
implements Serializable,
ProjectAndVirtualFileOwner {
    private static final Key<Map<Class, Pair<Integer, Integer>>> DEBUG_STATS_KEY = Key.create((String)"FileSymbolTable.STATS_KEY");
    private static final Logger LOG = Logger.getInstance(FileSymbolTable.class);
    private final ArrayList<OCSymbol> myContents = new ArrayList();
    private ContextSignature mySignature;
    private volatile int myPackStamp;
    private transient VirtualFile myFile;
    private transient Project myProject;
    private volatile transient int myUsingCount;

    public FileSymbolTable() {
    }

    public FileSymbolTable(@NotNull VirtualFile file2, @NotNull Project project2, @NotNull ContextSignature signature) {
        this.myFile = file2;
        this.mySignature = signature;
        this.myProject = project2;
    }

    public void compact() {
        this.myContents.trimToSize();
    }

    @NotNull
    public ContextSignature getSignature() {
        return this.mySignature;
    }

    @Override
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @NotNull
    public List<OCSymbol> getContents() {
        return this.myContents;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public void internSymbols(Function<OCSymbol, OCSymbol> internator) {
        for (int i = 0; i < this.myContents.size(); ++i) {
            OCSymbol each = this.myContents.get(i);
            OCSymbol replacement = (OCSymbol)internator.fun((Object)each);
            this.incInterned(each, false);
            if (each == replacement) continue;
            this.incInterned(each, true);
            this.myContents.set(i, replacement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incInterned(OCSymbol each, boolean interned) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        Map stats = (Map)this.myProject.getUserData(DEBUG_STATS_KEY);
        if (stats == null) {
            stats = new HashMap();
            this.myProject.putUserData(DEBUG_STATS_KEY, (Object)stats);
        }
        Map map = stats;
        synchronized (map) {
            Pair s = (Pair)stats.get(each.getClass());
            if (s == null) {
                s = new Pair((Object)0, (Object)0);
            }
            s = interned ? new Pair((Object)((Integer)s.first + 1), s.second) : new Pair(s.first, (Object)((Integer)s.second + 2));
            stats.put(each.getClass(), s);
            if (each instanceof OCNamespaceSymbol) {
                ((OCNamespaceSymbol)each).processMembers((String)null, new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        FileSymbolTable.this.incInterned(symbol, false);
                        FileSymbolTable.this.incInterned(symbol, true);
                        return true;
                    }
                });
            } else if (each instanceof OCClassSymbol) {
                ((OCClassSymbol)each).processMembers(null, OCMemberSymbol.class, new Processor<OCMemberSymbol>(){

                    public boolean process(OCMemberSymbol symbol) {
                        FileSymbolTable.this.incInterned(symbol, false);
                        FileSymbolTable.this.incInterned(symbol, true);
                        return true;
                    }
                });
            }
        }
    }

    public static void reportStats(@NotNull Project project2) {
        Map stats = (Map)project2.getUserData(DEBUG_STATS_KEY);
        if (stats == null) {
            return;
        }
        project2.putUserData(DEBUG_STATS_KEY, null);
        for (Map.Entry each : stats.entrySet()) {
            LOG.debug(((Class)each.getKey()).getSimpleName() + ": interned=" + ((Pair)each.getValue()).first + " count=" + ((Pair)each.getValue()).second);
        }
    }

    public void updateOffsets(int start, int end, int lengthShift, THashSet<OCSymbol> processed2) {
        for (OCSymbol symbol : this.myContents) {
            if (!processed2.add((Object)symbol)) continue;
            symbol.updateOffset(start, end, lengthShift);
        }
    }

    @Override
    public void init(@Nullable Project project2, @Nullable VirtualFile file2) {
        this.myFile = file2;
        this.myProject = project2;
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull PsiFile file2, @NotNull OCInclusionContext context) {
        Project project2 = file2.getProject();
        OCSymbolTablesBuildingActivity.getInstance(project2).assertParsingAndSymbolBuildingAllowed();
        file2 = file2.getOriginalFile();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
        return cache.forFile(file2, context);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull PsiElement element, @NotNull Class<T> symbolClass) {
        String name;
        String string = element instanceof OCStructLike ? ((OCStructLike)element).getTypeName() : (name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null);
        if (element instanceof OCElement) {
            return this.findSymbol(name, ((OCElement)element).getComplexOffset(), symbolClass);
        }
        return this.findSymbol(name, element.getTextOffset(), symbolClass);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@Nullable String name, @NotNull Class<T> symbolClass) {
        return this.findSymbol(name, -1L, symbolClass);
    }

    @Nullable
    private <T extends OCSymbol> T findSymbol(final @Nullable String name, final long complexOffset, final @NotNull Class<T> symbolClass) {
        final OCSymbol[] result = new OCSymbol[1];
        final OCSymbol[] possible = new OCSymbol[1];
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if ((complexOffset == -1L || symbol.getOffset() == OCSymbolOffsetUtil.getTextOffset(complexOffset)) && (name == null || Comparing.equal((String)name, (String)symbol.getName())) && symbolClass.isAssignableFrom(symbol.getClass())) {
                    if (complexOffset == -1L || symbol.getComplexOffset() == complexOffset) {
                        result[0] = symbol;
                        return false;
                    }
                    possible[0] = symbol;
                }
                if (symbol instanceof OCNamespaceSymbol) {
                    return ((OCNamespaceSymbol)symbol).processMembers((String)null, this);
                }
                if (symbol instanceof OCClassSymbol) {
                    final 3 this_ = this;
                    return ((OCClassSymbol)symbol).processMembers(name, new Processor<OCMemberSymbol>(){

                        public boolean process(OCMemberSymbol symbol) {
                            return this_.process((Object)symbol);
                        }
                    });
                }
                return true;
            }
        };
        ContainerUtil.process(this.myContents, (Processor)processor2);
        if (result[0] != null) {
            return (T)result[0];
        }
        return (T)possible[0];
    }

    public boolean processFile(Processor<OCSymbol> processor2) {
        return ContainerUtil.process(this.myContents, processor2);
    }

    public boolean processFile(Processor<OCSymbol> processor2, int afterOffset, int beforeOffset) {
        return OCResolveUtil.processSymbolsFromList(processor2, this.myContents, afterOffset, beforeOffset);
    }

    public boolean processIncludes(Processor<OCIncludeSymbol> processor2) {
        for (OCSymbol item : this.myContents) {
            OCIncludeSymbol include;
            if (!(item instanceof OCIncludeSymbol) || processor2.process((Object)(include = (OCIncludeSymbol)item))) continue;
            return false;
        }
        return true;
    }

    public boolean processSymbols(@NotNull Processor<OCSymbol> processor2, @Nullable String name, @Nullable Map<OCSymbol, VirtualFile> importsMap, OCInclusionContext context) {
        return this.processSymbols(processor2, name, (Set<FileSymbolTable>)new THashSet(), importsMap, null, context, null);
    }

    public boolean shallowProcessSymbols(@NotNull Processor<OCSymbol> processor2) {
        for (OCSymbol content : this.myContents) {
            if (!(content instanceof OCSymbol) || processor2.process((Object)content)) continue;
            return false;
        }
        return false;
    }

    public boolean processSymbols(@NotNull Processor<OCSymbol> processor2, @Nullable String name, @NotNull Set<FileSymbolTable> processedTables, @Nullable Map<OCSymbol, VirtualFile> importsMap, @Nullable VirtualFile firstImportLink, @NotNull OCInclusionContext context, @Nullable VirtualFile breakOn) {
        if (this.isEmpty()) {
            return true;
        }
        if (!processedTables.add(this)) {
            return true;
        }
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
        class Builder
        implements Processor<OCSymbol> {
            private boolean done = false;
            private OCParsingNameScope myNameScope;
            final /* synthetic */ OCInclusionContext val$context;
            final /* synthetic */ FileSymbolTablesCache val$cache;
            final /* synthetic */ Set val$processedTables;
            final /* synthetic */ VirtualFile val$breakOn;
            final /* synthetic */ VirtualFile val$firstImportLink;
            final /* synthetic */ Processor val$processor;
            final /* synthetic */ String val$name;
            final /* synthetic */ Map val$importsMap;

            Builder(OCParsingNameScope nameScope) {
                this.val$context = oCInclusionContext;
                this.val$cache = fileSymbolTablesCache;
                this.val$processedTables = set;
                this.val$breakOn = virtualFile;
                this.val$firstImportLink = virtualFile2;
                this.val$processor = processor2;
                this.val$name = string;
                this.val$importsMap = map;
                this.myNameScope = nameScope;
            }

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCIncludeSymbol) {
                    PsiFile psiFile;
                    OCIncludeSymbol include = (OCIncludeSymbol)symbol;
                    ProgressManager.checkCanceled();
                    if (this.done) {
                        return true;
                    }
                    VirtualFile includeFile = include.getTargetFile();
                    FileSymbolTable table = null;
                    if (includeFile != null && includeFile.isValid() && SymbolTableProvider.isSourceFile(psiFile = PsiManager.getInstance((Project)FileSymbolTable.this.myProject).findFile(includeFile)) && this.val$context.reserveInclude(includeFile, include.isOnce())) {
                        table = this.val$cache.forFile(psiFile, this.val$context);
                    }
                    if (this.val$processedTables.contains(table)) {
                        return true;
                    }
                    if (this.val$breakOn != null && Comparing.equal((Object)includeFile, (Object)this.val$breakOn)) {
                        return false;
                    }
                    if (table != null) {
                        VirtualFile link;
                        VirtualFile virtualFile = link = this.val$firstImportLink == null ? includeFile : this.val$firstImportLink;
                        if (!table.processSymbols((Processor<OCSymbol>)this.val$processor, this.val$name, this.val$processedTables, this.val$importsMap, link, this.val$context, this.val$breakOn)) {
                            return false;
                        }
                    }
                } else {
                    ProgressManager.checkCanceled();
                    if (this.done) {
                        return true;
                    }
                    if (this.val$name != null && !this.val$name.equals(symbol.getName())) {
                        return true;
                    }
                    this.updateImportsMap(symbol);
                    this.updateContext(symbol);
                    if (!this.val$processor.process((Object)symbol)) {
                        return false;
                    }
                }
                return true;
            }

            private void updateImportsMap(@NotNull OCSymbol symbol) {
                if (this.val$importsMap != null && this.val$firstImportLink != null) {
                    this.val$importsMap.put(symbol, this.val$firstImportLink);
                    if (symbol instanceof OCMembersContainer) {
                        ((OCMembersContainer)((Object)symbol)).processMembers(null, new Processor<OCSymbol>(){

                            public boolean process(OCSymbol symbol) {
                                this.updateImportsMap(symbol);
                                return true;
                            }
                        });
                    }
                }
            }

            private void updateContext(OCSymbol symbol) {
                if (symbol instanceof OCMacroSymbol) {
                    this.val$context.define((OCMacroSymbol)symbol);
                } else if (symbol instanceof OCUndefMacroSymbol) {
                    this.val$context.undef(symbol.getName());
                } else {
                    OCSymbolKind kind = symbol.getKind();
                    boolean isCPP = this.val$context.getLanguageKind().isCpp();
                    if (isCPP && symbol instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)symbol).getMembers() != null) {
                        OCParsingNameScope inner = this.myNameScope.defineNamespace(symbol.getName());
                        final Builder innerProcessor = new Builder(inner);
                        ((OCNamespaceSymbol)symbol).processMembers((String)null, new Processor<OCSymbol>(){

                            public boolean process(OCSymbol symbol) {
                                innerProcessor.updateContext(symbol);
                                return true;
                            }
                        });
                    }
                    if (kind.isType()) {
                        if (kind == OCSymbolKind.PROTOCOL) {
                            this.myNameScope.defineProtocol(symbol.getName());
                        } else if (kind.isClass() || kind == OCSymbolKind.COMPATIBILITY_ALIAS) {
                            this.myNameScope.defineInterface(symbol.getName());
                        } else {
                            boolean isTemplate = isCPP && kind.isStructLike() && ((OCStructSymbol)symbol).isTemplateSymbol();
                            this.myNameScope.defineType(symbol.getName(), isTemplate);
                        }
                    } else if (isCPP) {
                        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).getQualifiedName().getQualifier() == null) {
                            if (!symbol.getKind().isConstructorOrDestructor() && ((OCFunctionSymbol)symbol).isTemplateSymbol()) {
                                this.myNameScope.defineValue(symbol.getName(), true);
                            }
                        } else if (symbol instanceof OCUsingSymbol) {
                            if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                                this.myNameScope.defineNamespaceUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                            } else {
                                this.myNameScope.defineSymbolUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                            }
                        }
                    }
                }
            }
        }
        return this.processFile(new Builder(context.getNameScope()));
    }

    public boolean isEmpty() {
        return this.myContents.isEmpty();
    }

    public void append(OCSymbol symbol) {
        this.myContents.add(symbol);
    }

    public void appendAll(@NotNull List<OCSymbol> symbols) {
        this.myContents.addAll(symbols);
    }

    public void sortSymbols() {
        FileSymbolTable.sortSymbols(this.myContents);
    }

    private static void sortSymbols(@Nullable List<OCSymbol> symbols) {
        if (symbols != null) {
            Collections.sort(symbols, new Comparator<OCSymbol>(){

                @Override
                public int compare(OCSymbol o1, OCSymbol o2) {
                    return OCSymbolOffsetUtil.compare(o1.getComplexOffset(), o2.getComplexOffset());
                }
            });
            for (OCSymbol symbol : symbols) {
                if (!(symbol instanceof OCNamespaceSymbol)) continue;
                FileSymbolTable.sortSymbols(((OCNamespaceSymbol)symbol).getMembersList());
            }
        }
    }

    public int incUsageCount() {
        return ++this.myUsingCount;
    }

    public int getUsageCount() {
        return this.myUsingCount;
    }

    public void resetUsageCount() {
        this.myUsingCount = 1;
    }

    public int getPackStamp() {
        return this.myPackStamp;
    }

    public void setPackStamp(int packStamp) {
        this.myPackStamp = packStamp;
    }
}

