/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextSignature
implements Serializable {
    public static final int NO_EXACT_DEFINITION_MARKER = Integer.MAX_VALUE;
    public final List<String> myDefined;
    public final int[] myDefinedHashes;
    public final List<String> myNotDefined;
    public int myDistinctiveDefinedCount = 0;
    public int myDistinctiveNotDefinedCount = 0;
    @Nullable
    public final OCLanguageKind myLanguageKind;

    public ContextSignature(@Nullable OCLanguageKind kind, Map<String, Integer> definitions, Set<String> notDefined) {
        this.myLanguageKind = kind;
        int defSize = definitions.size();
        this.myDefined = new ArrayList<String>(defSize);
        this.myDefinedHashes = new int[defSize];
        int curDef = 0;
        for (Map.Entry<String, Integer> e : definitions.entrySet()) {
            this.myDefined.add(e.getKey());
            Integer hash = e.getValue();
            this.myDefinedHashes[curDef] = hash == null ? Integer.MAX_VALUE : ContextSignature.packedHash(hash);
            ++curDef;
        }
        this.myNotDefined = new ArrayList<String>(notDefined);
    }

    public ContextSignature() {
        this(null, Collections.emptyMap(), Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompatible(@NotNull OCInclusionContext ctx) {
        if (ctx.getLanguageKind() != this.myLanguageKind) {
            return false;
        }
        ContextSignature contextSignature = this;
        synchronized (contextSignature) {
            int i;
            for (i = 0; i < this.myDistinctiveDefinedCount; ++i) {
                if (ContextSignature.checkDefined(ctx, this.myDefined.get(i), this.myDefinedHashes[i])) continue;
                return false;
            }
            for (i = 0; i < this.myDistinctiveNotDefinedCount; ++i) {
                if (!ctx.isDefined(this.myNotDefined.get(i))) continue;
                return false;
            }
            int definedSize = this.myDefined.size();
            for (int i2 = this.myDistinctiveDefinedCount; i2 < definedSize; ++i2) {
                if (ContextSignature.checkDefined(ctx, this.myDefined.get(i2), this.myDefinedHashes[i2])) continue;
                Collections.swap(this.myDefined, this.myDistinctiveDefinedCount, i2);
                ArrayUtil.swap((int[])this.myDefinedHashes, (int)this.myDistinctiveDefinedCount, (int)i2);
                ++this.myDistinctiveDefinedCount;
                return false;
            }
            int notDefinedSize = this.myNotDefined.size();
            for (int i3 = this.myDistinctiveNotDefinedCount; i3 < notDefinedSize; ++i3) {
                if (!ctx.isDefined(this.myNotDefined.get(i3))) continue;
                Collections.swap(this.myNotDefined, this.myDistinctiveNotDefinedCount, i3);
                ++this.myDistinctiveNotDefinedCount;
                return false;
            }
        }
        return true;
    }

    public static boolean checkDefined(@NotNull OCInclusionContext ctx, String def, int defHash) {
        boolean ok;
        boolean shouldCheckExactDefinition = defHash != Integer.MAX_VALUE;
        OCMacroSymbol ctxDef = ctx.getDefinition(def, shouldCheckExactDefinition ? OCImmutableInclusionContext.SignaturePart.EXACT_DEFINITION : OCImmutableInclusionContext.SignaturePart.HAS_DEFINITION);
        boolean bl = ok = ctxDef != null;
        if (ok && shouldCheckExactDefinition) {
            ok = defHash == ContextSignature.packedHash(ctxDef.getSubstitutionHash());
        }
        return ok;
    }

    private static int packedHash(int hash) {
        return hash == Integer.MAX_VALUE ? hash - 1 : hash;
    }

    public boolean sameSignature(@NotNull ContextSignature other) {
        Map d2;
        HashSet nd2;
        if (!Comparing.equal((Object)this.myLanguageKind, (Object)other.myLanguageKind)) {
            return false;
        }
        HashSet nd1 = ContainerUtil.newHashSet(this.myNotDefined);
        if (!Comparing.equal((Object)nd1, (Object)(nd2 = ContainerUtil.newHashSet(other.myNotDefined)))) {
            return false;
        }
        Map d1 = ContainerUtil.newHashMap(this.myDefined, ContextSignature.toIntList(this.myDefinedHashes));
        return Comparing.equal((Object)d1, (Object)(d2 = ContainerUtil.newHashMap(other.myDefined, ContextSignature.toIntList(other.myDefinedHashes))));
    }

    @NotNull
    private static ArrayList<Integer> toIntList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : array) {
            list.add(i);
        }
        return list;
    }
}

