/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCPropertySymbol
extends OCMemberSymbol,
OCSymbolWithSubstitution {
    public static final Set<PropertyAttribute> PROPERTY_ATTRIBUTES_WITH_VALUE = EnumSet.of(PropertyAttribute.GETTER, PropertyAttribute.SETTER);
    public static final Set<PropertyAttribute> PROPERTY_ATTRIBUTES_FOR_OBJECT = EnumSet.of(PropertyAttribute.RETAIN, PropertyAttribute.STRONG, PropertyAttribute.COPY);
    public static final Set<PropertyAttribute> PROPERTY_ATTRIBUTES_AFTER_LLVM_30 = EnumSet.of(PropertyAttribute.STRONG, PropertyAttribute.WEAK, PropertyAttribute.UNSAFE_UNRETAINED);

    public boolean hasAttribute(PropertyAttribute var1);

    public String getAttributeValue(PropertyAttribute var1);

    public PropertyAttribute getAttributeOfGroup(PropertyAttribute var1, OCType var2, PsiElement var3);

    public boolean isOptional();

    public boolean isReadonly();

    public boolean isRetained();

    @NotNull
    public String getGetterName();

    @NotNull
    public String getSetterName();

    public boolean processAccessorMethods(Processor<? super OCMethodSymbol> var1, boolean var2);

    public boolean processSynthesizes(Processor<? super OCSynthesizeSymbol> var1);

    @Nullable
    public OCInstanceVariableSymbol getAssociatedIvar();

    public boolean hasAllAccessorsImplemented(boolean var1);

    @Nullable
    public OCPropertySymbol getAssociatedPropertyInPrivateCategory();

    @Nullable
    public OCPropertySymbol getAssociatedPropertyInMainInterface();

    public static final class PropertyAttribute
    extends Enum<PropertyAttribute> {
        public static final /* enum */ PropertyAttribute NONATOMIC = new PropertyAttribute(0);
        public static final /* enum */ PropertyAttribute ATOMIC = new PropertyAttribute(0);
        public static final /* enum */ PropertyAttribute READONLY = new PropertyAttribute(1);
        public static final /* enum */ PropertyAttribute READWRITE = new PropertyAttribute(1);
        public static final /* enum */ PropertyAttribute ASSIGN = new PropertyAttribute(2);
        public static final /* enum */ PropertyAttribute COPY = new PropertyAttribute(2);
        public static final /* enum */ PropertyAttribute RETAIN = new PropertyAttribute(2);
        public static final /* enum */ PropertyAttribute WEAK = new PropertyAttribute(2);
        public static final /* enum */ PropertyAttribute STRONG = new PropertyAttribute(2);
        public static final /* enum */ PropertyAttribute UNSAFE_UNRETAINED = new PropertyAttribute(2);
        public static final /* enum */ PropertyAttribute GETTER = new PropertyAttribute(3);
        public static final /* enum */ PropertyAttribute SETTER = new PropertyAttribute(4);
        public static final /* enum */ PropertyAttribute NONNULL = new PropertyAttribute(5);
        public static final /* enum */ PropertyAttribute NULLABLE = new PropertyAttribute(5);
        public static final /* enum */ PropertyAttribute NULL_RESETTABLE = new PropertyAttribute(5);
        public static final /* enum */ PropertyAttribute NULL_UNSPECIFIED = new PropertyAttribute(5);
        private final int myGroup;
        private static final /* synthetic */ PropertyAttribute[] $VALUES;

        public static PropertyAttribute[] values() {
            return (PropertyAttribute[])$VALUES.clone();
        }

        public static PropertyAttribute valueOf(String name) {
            return Enum.valueOf(PropertyAttribute.class, name);
        }

        private PropertyAttribute(int group) {
            this.myGroup = group;
        }

        public int getGroup() {
            return this.myGroup;
        }

        public String getTokenName() {
            return StringUtil.toLowerCase((String)this.name());
        }

        public ARCAttribute getIvarCompatibleARCAttribute() {
            switch (this) {
                case ASSIGN: 
                case UNSAFE_UNRETAINED: {
                    return ARCAttribute.UNSAFE_UNRETAINED;
                }
                case WEAK: {
                    return ARCAttribute.WEAK;
                }
                case STRONG: 
                case COPY: 
                case RETAIN: {
                    return ARCAttribute.STRONG;
                }
            }
            assert (false);
            return null;
        }

        public int getSemanticsGroup() {
            switch (this) {
                case STRONG: 
                case RETAIN: {
                    return 0;
                }
                case COPY: {
                    return 1;
                }
            }
            return 2;
        }

        @Nullable
        public PropertySemantics getSemanticsAttribute() {
            switch (this) {
                case ASSIGN: 
                case UNSAFE_UNRETAINED: {
                    return PropertySemantics.ASSIGN;
                }
                case COPY: {
                    return PropertySemantics.COPY;
                }
                case RETAIN: {
                    return PropertySemantics.RETAIN;
                }
                case WEAK: {
                    return PropertySemantics.WEAK;
                }
                case STRONG: {
                    return PropertySemantics.STRONG;
                }
            }
            return null;
        }

        static {
            $VALUES = new PropertyAttribute[]{NONATOMIC, ATOMIC, READONLY, READWRITE, ASSIGN, COPY, RETAIN, WEAK, STRONG, UNSAFE_UNRETAINED, GETTER, SETTER, NONNULL, NULLABLE, NULL_RESETTABLE, NULL_UNSPECIFIED};
        }

        public static class Group {
            public static final int GROUP_ATOMICITY = 0;
            public static final int GROUP_WRITEABILITY = 1;
            public static final int GROUP_ARC = 2;
            public static final int GROUP_GETTER = 3;
            public static final int GROUP_SETTER = 4;
            public static final int GROUP_NULLABILITY = 5;
        }
    }

    public static enum PropertySemantics {
        DEFAULT,
        STRONG,
        WEAK,
        ASSIGN,
        RETAIN,
        COPY;


        @Nullable
        public PropertyAttribute getPropertyAttribute() {
            switch (this) {
                case DEFAULT: {
                    return null;
                }
                case STRONG: {
                    return PropertyAttribute.STRONG;
                }
                case WEAK: {
                    return PropertyAttribute.WEAK;
                }
                case ASSIGN: {
                    return PropertyAttribute.ASSIGN;
                }
                case RETAIN: {
                    return PropertyAttribute.RETAIN;
                }
                case COPY: {
                    return PropertyAttribute.COPY;
                }
            }
            return null;
        }
    }
}

