/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodSymbolImpl
extends OCMemberSymbolImpl
implements OCMethodSymbol {
    private boolean myStatic;
    private boolean myOptional;
    private boolean myVararg;
    private OCType myReturnType;
    private OCPropertySymbol myGeneratedFromProperty;
    private List<OCMethodSymbol.SelectorPartSymbol> mySelectors;
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;

    public OCMethodSymbolImpl() {
    }

    public OCMethodSymbolImpl(@NotNull OCMethodSymbolImpl origin, @NotNull OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        this(origin.getProject(), origin.getContainingFile(), origin.getOffset(), origin.getName(), origin.getAttributes(), origin.myParent, origin.myStatic, origin.myOptional, origin.myVararg, origin.myReturnType, ContainerUtil.newArrayList(origin.mySelectors), origin.myGeneratedFromProperty);
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
    }

    public OCMethodSymbolImpl(Project project2, VirtualFile file2, long offset, @Nullable String name, @NotNull List<String> attributes, @NotNull OCClassSymbol parent, boolean isStatic, boolean isOptional, boolean isVararg, @NotNull OCType returnType, @NotNull List<OCMethodSymbol.SelectorPartSymbol> selectors, @Nullable OCPropertySymbol generatedFromProperty) {
        super(project2, file2, offset, name, attributes, parent);
        this.myStatic = isStatic;
        this.myGeneratedFromProperty = generatedFromProperty;
        this.myReturnType = returnType;
        this.myOptional = isOptional;
        this.myVararg = isVararg;
        this.mySelectors = ContainerUtil.trimToSize(selectors);
        for (OCMethodSymbol.SelectorPartSymbol selector : selectors) {
            OCDeclaratorSymbol parameter = selector.getParameterWithoutSubstitution();
            if (parameter == null) continue;
            parameter.setParentMethod(this);
        }
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMethodSymbolImpl f = (OCMethodSymbolImpl)first;
        OCMethodSymbolImpl s = (OCMethodSymbolImpl)second;
        if (f.myOptional != s.myOptional) {
            return false;
        }
        if (f.myStatic != s.myStatic) {
            return false;
        }
        if (f.myVararg != s.myVararg) {
            return false;
        }
        if (!c.equalObjects(f.myGeneratedFromProperty, s.myGeneratedFromProperty)) {
            return false;
        }
        if (!c.equalObjects(f.myReturnType, s.myReturnType)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalIterable(f.mySelectors, s.mySelectors);
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        for (OCMethodSymbol.SelectorPartSymbol selector : this.mySelectors) {
            OCDeclaratorSymbol param = selector.getParameter();
            if (param == null) continue;
            param.updateOffset(start, end, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        for (OCMethodSymbol.SelectorPartSymbol selector : this.mySelectors) {
            OCDeclaratorSymbol param = selector.getParameter();
            if (param == null) continue;
            param.compact();
        }
    }

    @Override
    protected Class<? extends PsiElement> getPsiElementClass() {
        return this.myGeneratedFromProperty == null ? OCMethod.class : OCDeclarator.class;
    }

    @Override
    @NotNull
    public OCType getReturnType(@Nullable OCObjectType receiverType) {
        if (this.myReturnType instanceof OCReferenceType && this.myReturnType.getName().equals("instancetype")) {
            if (receiverType != null && receiverType.getClassSymbol() != null && receiverType.getClassSymbol().isSubclass(this.getParent())) {
                return OCPointerType.to(receiverType);
            }
            OCPointerType type = OCPointerType.to(OCReferenceType.fromText(this.getParent().getName()));
            return type.cloneWithAliasName("instancetype");
        }
        return this.mySubstitution.substitute(this.myReturnType, new OCResolveContext());
    }

    @Override
    @NotNull
    public OCType getReturnType() {
        return this.getReturnType(null);
    }

    @Override
    public boolean isStatic() {
        return this.myStatic;
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    public boolean isVararg() {
        return this.myVararg;
    }

    @Override
    public boolean isFactoryMethod() {
        String className = StringUtil.trimStart((String)this.getParent().getName(), (String)"NS");
        String selector = this.getName();
        if (this.isStatic()) {
            List classWords = NameUtil.nameToWordsLowerCase((String)className);
            List selectorWords = NameUtil.nameToWordsLowerCase((String)selector);
            String word = (String)ContainerUtil.getFirstItem((List)selectorWords);
            if ("default".equalsIgnoreCase(word) || "common".equalsIgnoreCase(word) || "shared".equalsIgnoreCase(word) || "main".equalsIgnoreCase(word)) {
                selectorWords.remove(0);
            }
            if (classWords.isEmpty() || selectorWords.isEmpty()) {
                return false;
            }
            block0: for (int wordCount = 1; wordCount <= Math.min(classWords.size(), selectorWords.size()); ++wordCount) {
                for (int i = 0; i < wordCount; ++i) {
                    String classWord = (String)classWords.get(classWords.size() - wordCount + i);
                    String selectorWord = (String)selectorWords.get(i);
                    if (!selectorWord.equals(classWord)) continue block0;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConstructorMethod() {
        return !this.isStatic() && OCElementUtil.startsWithWord(this.getName(), "init");
    }

    @Override
    public boolean isClassConstructorMethod() {
        return this.isStatic() && OCElementUtil.startsWithWord(this.getName(), "objectWith");
    }

    @Override
    public boolean isPredeclaration() {
        return !(this.getParent() instanceof OCImplementationSymbol);
    }

    @Override
    @Nullable
    public OCMethodSymbol getDefinitionSymbol() {
        if (this.isPredeclaration()) {
            return this.getAssociatedSymbol();
        }
        return this;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.doComputeIcon(false);
    }

    @Override
    public Icon computeFullIcon(@Nullable PsiElement symbolElement) {
        return this.doComputeIcon(true);
    }

    @Override
    public Icon doComputeIcon(boolean full) {
        OCPropertySymbol associatedProperty;
        OCMethodSymbol associatedMethod;
        OCPropertySymbol property = this.getGeneratedFromProperty();
        if (property != null) {
            return property.getIcon();
        }
        if (full && this.myParent instanceof OCImplementationSymbol && (associatedMethod = this.getAssociatedSymbol(this.myParent.getContainingOCFile())) != null && (associatedProperty = associatedMethod.getGeneratedFromProperty()) != null) {
            return associatedProperty.getIcon();
        }
        return OCIcons.getMethodIcon(this.isStatic(), this.isOptional(), false);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.METHOD;
    }

    @Override
    public boolean isGetter() {
        return !this.isStatic() && OCNameSuggester.isObjCGetter(this.myName) && !this.getEffectiveResolvedType().isVoid();
    }

    @Override
    public boolean isSetter() {
        return !this.isStatic() && OCNameSuggester.isObjCSetter(this.myName) && this.getEffectiveResolvedType().isVoid();
    }

    @Override
    public OCPropertySymbol getGeneratedFromProperty() {
        return this.myGeneratedFromProperty;
    }

    @Override
    public boolean isSynthetic() {
        return this.myGeneratedFromProperty != null;
    }

    @Override
    public boolean isForbiddenByARC(@NotNull PsiElement context) {
        return super.isForbiddenByARC(context) || "dealloc".equals(this.myName) && OCCompilerHelper.isArcEnabled(context.getContainingFile());
    }

    @Override
    public boolean isAccessorWithAliasedName() {
        OCPropertySymbol property = this.getGeneratedFromProperty();
        if (property == null) {
            return false;
        }
        if (this.isGetter()) {
            return property.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER) != null;
        }
        if (this.isSetter()) {
            return property.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER) != null;
        }
        return false;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    @NotNull
    public List<OCMethodSymbol.SelectorPartSymbol> getSelectors() {
        return this.mySubstitution == OCTypeSubstitution.ID ? this.mySelectors : ContainerUtil.map(this.mySelectors, (Function)new Function<OCMethodSymbol.SelectorPartSymbol, OCMethodSymbol.SelectorPartSymbol>(){

            public OCMethodSymbol.SelectorPartSymbol fun(OCMethodSymbol.SelectorPartSymbol symbol) {
                return new SelectorPartSymbolImpl((SelectorPartSymbolImpl)symbol, OCMethodSymbolImpl.this.mySubstitution, new OCResolveContext());
            }
        });
    }

    @Override
    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols() {
        return ContainerUtil.map(this.mySelectors, (Function)new Function<OCMethodSymbol.SelectorPartSymbol, OCDeclaratorSymbol>(){

            @Nullable
            public OCDeclaratorSymbol fun(OCMethodSymbol.SelectorPartSymbol symbol) {
                return OCMethodSymbolImpl.this.mySubstitution.substitute(symbol.getParameter(), new OCResolveContext());
            }
        });
    }

    @Override
    @NotNull
    public String getSignature() {
        return (this.myStatic ? "+" : "-") + this.myName;
    }

    @Override
    @NotNull
    public String getNameWithParent() {
        return (this.myStatic ? "+" : "-") + "[" + this.myParent.getName() + " " + this.getName() + "]";
    }

    @Override
    @Nullable
    public OCMethodSymbol getAssociatedSymbol() {
        return this.getAssociatedSymbol(null);
    }

    @Override
    @Nullable
    public OCMethodSymbol getAssociatedSymbol(@Nullable PsiElement context) {
        OCClassSymbol parentAssociate = (OCClassSymbol)this.getParent().getAssociatedSymbol();
        if (parentAssociate == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol methodSymbol) {
                return methodSymbol.isStatic() == OCMethodSymbolImpl.this.isStatic();
            }
        };
        parentAssociate.processCategories((Processor<? super OCClassSymbol>)new Processor<OCClassSymbol>((CommonProcessors.FindFirstProcessor)processor2){
            final /* synthetic */ CommonProcessors.FindFirstProcessor val$processor;
            {
                this.val$processor = findFirstProcessor;
            }

            public boolean process(OCClassSymbol symbol) {
                return OCMethodSymbolImpl.this.mySubstitution.substitute(symbol, new OCResolveContext()).processMembers(OCMethodSymbolImpl.this.getName(), OCMethodSymbol.class, this.val$processor);
            }
        }, true, context);
        return (OCMethodSymbol)processor2.getFoundValue();
    }

    @Override
    public boolean processSameSymbols(final Processor<OCSymbol> processor2) {
        return this.myParent.processMembersInAllCategories(this.myName, this.getClass(), new Processor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol methodSymbol) {
                return methodSymbol.isStatic() != OCMethodSymbolImpl.this.isStatic() || processor2.process((Object)OCMethodSymbolImpl.this.mySubstitution.substitute(methodSymbol, new OCResolveContext()));
            }
        }, false);
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType() {
        return this.getReturnType().resolve(this.getContainingOCFile());
    }

    @Override
    public OCType getEffectiveType() {
        return this.getReturnType();
    }

    public static class SelectorPartSymbolImpl
    implements OCMethodSymbol.SelectorPartSymbol {
        @Nullable
        private String selectorName;
        @Nullable
        private OCDeclaratorSymbol parameter;
        @NotNull
        private OCTypeSubstitution substitution = OCTypeSubstitution.ID;

        public SelectorPartSymbolImpl() {
        }

        public SelectorPartSymbolImpl(@Nullable OCDeclaratorSymbol parameter, @Nullable String selectorName) {
            this.parameter = parameter;
            this.selectorName = selectorName;
        }

        public SelectorPartSymbolImpl(@NotNull SelectorPartSymbolImpl origin, @NotNull OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
            this(origin.parameter, origin.selectorName);
            this.substitution = OCTypeSubstitution.compose(origin.substitution, substitution, context);
        }

        @Override
        @Nullable
        public OCDeclaratorSymbol getParameter() {
            return this.substitution.substitute(this.parameter, new OCResolveContext());
        }

        @Override
        @Nullable
        public OCDeclaratorSymbol getParameterWithoutSubstitution() {
            return this.parameter;
        }

        @Override
        @NotNull
        public OCTypeSubstitution getSubstitution() {
            return this.substitution;
        }

        @Override
        @Nullable
        public String getSelectorName() {
            return this.selectorName;
        }

        public boolean equals(Object o) {
            return DeepEqual.equalObjects(this, o);
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCMethodSymbol.SelectorPartSymbol first, @NotNull OCMethodSymbol.SelectorPartSymbol second) {
            if (!Comparing.equal((String)first.getSelectorName(), (String)second.getSelectorName())) {
                return false;
            }
            if (!c.equalObjects(first.getSubstitution(), second.getSubstitution())) {
                return false;
            }
            return c.equalObjects(first.getParameter(), second.getParameter());
        }

        public int hashCode() {
            int result = this.selectorName != null ? this.selectorName.hashCode() : 0;
            result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
            return result;
        }
    }
}

