/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCStringsFile;
import com.jetbrains.cidr.lang.resolve.references.OCResourceFilesProvider;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLocalizedStringSymbol
extends OCSymbolImpl<OCLocalizedString> {
    public OCLocalizedStringSymbol(@Nullable Project project2, @Nullable VirtualFile file2, int offset, @Nullable String name, @NotNull List<String> attributes) {
        super(project2, file2, offset, name, attributes);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.LOCALIZED_STRING;
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2) {
        for (PsiFile each : FilenameIndex.getFilesByName(this.myProject, this.myFile.getName(), OCSearchScope.getProjectSourcesScope(this.myProject))) {
            OCLocalizedStringSymbol symbol;
            OCStringsFile stringsFile;
            ProgressManager.checkCanceled();
            if (!(each instanceof OCStringsFile) || !OCResourceFilesProvider.isAccessible((PsiElement)(stringsFile = (OCStringsFile)each), this.myFile)) continue;
            OCLocalizedString pair = stringsFile.findStringPair(this.myName);
            OCLocalizedStringSymbol oCLocalizedStringSymbol = symbol = pair != null ? (OCLocalizedStringSymbol)pair.getSymbol() : null;
            if (symbol == null || processor2.process((Object)symbol)) continue;
            return false;
        }
        return true;
    }
}

