/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceExpressionSymbol
extends OCExpressionSymbol {
    private OCSymbolReference myReference;
    private OCExpressionSymbol myParent;

    public OCReferenceExpressionSymbol() {
    }

    public OCReferenceExpressionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, OCSymbolReference reference) {
        super(project2, file2, offset, name);
        this.myReference = reference;
    }

    public void setParent(OCExpressionSymbol parent) {
        this.myParent = parent;
    }

    public OCSymbolReference getReference() {
        return this.myReference;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCReferenceExpressionSymbol firstSymbol = (OCReferenceExpressionSymbol)first;
        OCReferenceExpressionSymbol secondSymbol = (OCReferenceExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myReference, secondSymbol.myReference)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myParent, secondSymbol.myParent);
    }

    @Nullable
    public OCSymbol resolveToSymbol(@NotNull OCResolveContext context) {
        List<OCSymbol> symbols = context.resolveToSymbols(this.myReference);
        PsiFile file2 = context.getFile();
        if (this.myParent instanceof OCCallExpressionSymbol && file2 != null && ((OCFile)file2).isCpp()) {
            return ((OCCallExpressionSymbol)this.myParent).resolveOverloads(symbols, context);
        }
        return OCReferenceElementImpl.findPredeclaration(symbols);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalReference(this);
    }

    @Override
    @Nullable
    public OCTypeArgument evaluateToTypeArgument(@NotNull OCResolveContext resolver) {
        OCSymbol symbol;
        OCTypeArgument result = super.evaluateToTypeArgument(resolver);
        if (result == null && (symbol = this.resolveToSymbol(resolver)) instanceof OCTypeParameterValueSymbol) {
            return new OCTypeParameterType((OCTypeParameterSymbol)((Object)symbol));
        }
        return result;
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCSymbol symbol = this.resolveToSymbol(context);
        if (symbol instanceof OCTypeParameterSymbol) {
            context.addTypeDependency((OCTypeParameterSymbol)((Object)symbol));
        }
        return symbol != null ? OCReferenceExpressionImpl.getReferenceExpressionType(symbol).resolve(context) : null;
    }
}

