/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.impl.OCCppNewExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewExpressionSymbol
extends OCExpressionSymbol {
    private OCType myType;
    private int myArrayLengths;

    public OCNewExpressionSymbol() {
    }

    public OCNewExpressionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, @NotNull OCType type, int arrayLengths) {
        super(project2, file2, offset, name);
        this.myType = type;
        this.myArrayLengths = arrayLengths;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCNewExpressionSymbol firstSymbol = (OCNewExpressionSymbol)first;
        OCNewExpressionSymbol secondSymbol = (OCNewExpressionSymbol)second;
        if (firstSymbol.myArrayLengths != secondSymbol.myArrayLengths) {
            return false;
        }
        return c.equalObjects(firstSymbol.myType, secondSymbol.myType);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return null;
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        return OCCppNewExpressionImpl.getNewExprType(this.myType, this.myArrayLengths).resolve(context.getFile());
    }
}

