/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLiteralExpressionSymbol
extends OCExpressionSymbol {
    @NotNull
    private Object myValue;
    private IElementType myTokenType;
    private String myText;

    public OCLiteralExpressionSymbol() {
    }

    public OCLiteralExpressionSymbol(@Nullable String name, @NotNull Object value, IElementType tokenType, String text) {
        super(null, null, 0L, name);
        this.myValue = value;
        this.myTokenType = tokenType;
        this.myText = text;
    }

    @NotNull
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCLiteralExpressionSymbol firstSymbol = (OCLiteralExpressionSymbol)first;
        OCLiteralExpressionSymbol secondSymbol = (OCLiteralExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myValue, secondSymbol.myValue)) {
            return false;
        }
        if (!Comparing.equal((String)firstSymbol.myText, (String)secondSymbol.myText)) {
            return false;
        }
        return firstSymbol.myTokenType == secondSymbol.myTokenType;
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (this.myValue instanceof Boolean) {
            return evaluator.evalBool((Boolean)this.myValue);
        }
        if (this.myValue instanceof Number) {
            return evaluator.evalInteger((Number)this.myValue);
        }
        return null;
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        PsiFile file2 = context.getFile();
        return file2 != null ? OCLiteralExpressionImpl.getLiteralType(this.myTokenType, this.myText, file2) : null;
    }

    @Override
    @Nullable
    public OCTypeArgument evaluateToTypeArgument(@NotNull OCResolveContext resolver) {
        return new OCExpressionTypeArgument(this);
    }
}

