/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.impl.OCConditionalExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConditionalExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myCondition;
    private OCExpressionSymbol myLeftOperand;
    private OCExpressionSymbol myRightOperand;

    public OCConditionalExpressionSymbol() {
    }

    public OCConditionalExpressionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, OCExpressionSymbol condition, OCExpressionSymbol leftOperand, OCExpressionSymbol rightOperand) {
        super(project2, file2, offset, name);
        this.myCondition = condition;
        this.myLeftOperand = leftOperand;
        this.myRightOperand = rightOperand;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCConditionalExpressionSymbol firstSymbol = (OCConditionalExpressionSymbol)first;
        OCConditionalExpressionSymbol secondSymbol = (OCConditionalExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myCondition, secondSymbol.myCondition)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLeftOperand, secondSymbol.myLeftOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myRightOperand, secondSymbol.myRightOperand);
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCType leftType = this.myLeftOperand.getResolvedType(context);
        OCType rightType = this.myRightOperand.getResolvedType(context);
        if (leftType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)leftType).getSymbol());
        }
        if (rightType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)rightType).getSymbol());
        }
        return leftType != null && rightType != null ? OCConditionalExpressionImpl.getConditionalExprType(leftType, rightType, false, false, (PsiElement)context.getFile()) : null;
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalConditional(this.myCondition.evaluate(evaluator), this.myLeftOperand.evaluate(evaluator), this.myRightOperand.evaluate(evaluator));
    }
}

