/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.impl.OCCallExpressionImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myCallerSymbol;
    private List<OCExpressionSymbol> myArguments;

    public OCCallExpressionSymbol() {
    }

    public OCCallExpressionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, OCExpressionSymbol callerSymbol, List<OCExpressionSymbol> arguments) {
        super(project2, file2, offset, name);
        this.myCallerSymbol = callerSymbol;
        this.myArguments = arguments;
    }

    public OCExpressionSymbol getCallerSymbol() {
        return this.myCallerSymbol;
    }

    public List<OCExpressionSymbol> getArguments() {
        return this.myArguments;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCallExpressionSymbol firstSymbol = (OCCallExpressionSymbol)first;
        OCCallExpressionSymbol secondSymbol = (OCCallExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myCallerSymbol, secondSymbol.myCallerSymbol)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myArguments, secondSymbol.myArguments);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalCall(this);
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCType callerType;
        OCSymbol callerSymbol = null;
        if (this.myCallerSymbol instanceof OCReferenceExpressionSymbol) {
            callerSymbol = ((OCReferenceExpressionSymbol)this.myCallerSymbol).resolveToSymbol(context);
            OCResolveContext newContext = callerSymbol != null ? context.useFor(callerSymbol) : null;
            OCType oCType = callerType = callerSymbol != null ? OCReferenceExpressionImpl.getReferenceExpressionType(callerSymbol).resolve(newContext) : null;
            if (callerType instanceof OCFunctionType) {
                return OCCallExpressionImpl.getCallExprType(callerType, callerSymbol);
            }
        }
        OCType oCType = callerType = (callerType = this.myCallerSymbol.getResolvedType(context)) != null ? callerType.getTerminalType() : null;
        if (callerType instanceof OCFunctionType) {
            OCFunctionSymbol dummyFunction = new OCFunctionSymbol(null, null, 0L, null, OCQualifiedName.with(null), Collections.emptyList(), null, 0, 0, Collections.emptyList(), (OCFunctionType)callerType, Collections.emptyList(), OCSymbolKind.FUNCTION_DECLARATION, null);
            if (this.resolveOverloads(Collections.singletonList(dummyFunction), context) == null) {
                return null;
            }
        } else if (callerType instanceof OCStructType) {
            OCArgumentsList<OCExpressionSymbol> arguments = this.getArgumentList(context);
            if (arguments == null) {
                return null;
            }
            ArrayList<OCType> types = new ArrayList<OCType>();
            types.add(callerType);
            types.addAll(arguments.getTypes());
            callerSymbol = OCOperatorReference.resolveOperator("()", OCOperatorReference.OperatorPlacement.POSTFIX, types, null, context);
            OCResolveContext newContext = callerSymbol != null ? context.useFor(callerSymbol) : null;
            callerType = callerSymbol != null ? OCReferenceExpressionImpl.getReferenceExpressionType(callerSymbol).resolve(newContext) : null;
        }
        return callerType != null ? OCCallExpressionImpl.getCallExprType(callerType, callerSymbol) : null;
    }

    @Nullable
    private OCArgumentsList<OCExpressionSymbol> getArgumentList(@NotNull OCResolveContext context) {
        OCArgumentsList<OCExpressionSymbol> arguments = OCArgumentsList.expandVariadicExpressions(this.myArguments, context);
        for (OCType type : arguments.getTypes()) {
            if (!(type instanceof OCTypeParameterType)) continue;
            context.addTypeDependency(((OCTypeParameterType)type).getSymbol());
        }
        for (OCType type : arguments.getTypes()) {
            if (type != null) continue;
            return null;
        }
        return arguments;
    }

    @Nullable
    public OCSymbol resolveOverloads(List<OCSymbol> symbols, OCResolveContext context) {
        OCArgumentsList<OCExpressionSymbol> argumentList = this.getArgumentList(context);
        return argumentList != null ? OCResolveOverloadsUtil.resolveOverloads(symbols, argumentList, null, context, null, true, true, true) : null;
    }
}

