/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeParameterTypeSymbol
extends OCSymbolImpl<OCElement>
implements OCTypeParameterSymbol<OCType> {
    @Nullable
    private OCType myDefaultValue;
    private boolean myVariadic;
    private TextRange myScope;

    public OCTypeParameterTypeSymbol() {
        this(null, null, 0L, "<unnamed>", null, Collections.emptyList(), null, false);
    }

    public OCTypeParameterTypeSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, @Nullable OCType defaultValue, @NotNull List<String> attributes, TextRange scope, boolean variadic) {
        super(project2, file2, offset, name, attributes);
        this.myScope = scope;
        this.myDefaultValue = defaultValue;
        this.myVariadic = variadic;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCTypeParameterTypeSymbol f = (OCTypeParameterTypeSymbol)first;
        OCTypeParameterTypeSymbol s = (OCTypeParameterTypeSymbol)second;
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!c.equalObjects(f.myDefaultValue, s.myDefaultValue)) {
            return false;
        }
        return this.myVariadic == f.myVariadic;
    }

    @Override
    @NotNull
    public OCType getType() {
        return new OCTypeParameterType(this);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.TEMPLATE_TYPE_PARAMETER;
    }

    @Override
    @Nullable
    public OCType getDefaultValue() {
        return this.myDefaultValue;
    }

    @Override
    public boolean isVariadic() {
        return this.myVariadic;
    }

    @Override
    public TextRange getScope() {
        return this.myScope;
    }
}

