/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolWithQualifiedName<T extends PsiElement>
extends OCSymbolImpl<T>
implements OCSymbolWithParent<T, OCSymbolWithQualifiedName<T>> {
    @NotNull
    private OCQualifiedName myQualifiedName;
    @Nullable
    protected OCSymbolWithQualifiedName myParent;
    @Nullable
    protected OCVisibility myVisibility;
    public static final Condition<OCSymbol> WITHOUT_QUALIFIER = new Condition<OCSymbol>(){

        public boolean value(OCSymbol symbol) {
            return !(symbol instanceof OCSymbolWithQualifiedName) || ((OCSymbolWithQualifiedName)symbol).getQualifier() == null;
        }
    };

    public OCSymbolWithQualifiedName() {
    }

    public OCSymbolWithQualifiedName(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName qualifiedName, @NotNull List<String> attributes, @Nullable OCVisibility visibility) {
        super(project2, file2, offset, qualifiedName.getName(), attributes);
        this.myParent = parent;
        this.myQualifiedName = qualifiedName;
        this.myVisibility = visibility;
    }

    @Nullable
    public OCQualifiedName getQualifier() {
        return this.myQualifiedName.getQualifier();
    }

    @NotNull
    public OCQualifiedName getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    @NotNull
    public String getNameWithParent() {
        if (this.myQualifiedName.getQualifier() != null) {
            return this.myQualifiedName.getCanonicalName(true);
        }
        if (this.myParent != null) {
            return this.myParent.getName() + "::" + this.myName;
        }
        return this.myName;
    }

    @Nullable
    public OCVisibility getVisibility() {
        return this.myVisibility;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCSymbolWithQualifiedName f = (OCSymbolWithQualifiedName)first;
        OCSymbolWithQualifiedName s = (OCSymbolWithQualifiedName)second;
        if (f.myVisibility != s.myVisibility) {
            return false;
        }
        if (!c.equalObjects(f.myQualifiedName, s.myQualifiedName)) {
            return false;
        }
        return c.equalObjects(f.myParent, s.myParent);
    }

    public boolean resolvedNamesEqual(OCSymbolWithQualifiedName symbol) {
        if (this.equals(symbol)) {
            return true;
        }
        OCQualifiedName qualifiedName = symbol.getQualifiedName();
        if (!Comparing.equal((String)this.myQualifiedName.getName(), (String)qualifiedName.getName())) {
            return false;
        }
        if (this.isPredeclaration() || symbol.isPredeclaration()) {
            return true;
        }
        if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isSpecialization() || this instanceof OCStructSymbol && ((OCStructSymbol)this).isSpecialization()) {
            return Comparing.equal((Object)this.getResolvedQualifiedNameWithoutInlineNamespaces(), (Object)symbol.getResolvedQualifiedNameWithoutInlineNamespaces());
        }
        return Comparing.equal((Object)this.getResolvedQualifiedName(false), (Object)symbol.getResolvedQualifiedName(false));
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedNameWithoutInlineNamespaces() {
        return this.getResolvedQualifiedName(true, new OCResolveContext(this.getContainingOCFile()), true, false, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName() {
        return this.getResolvedQualifiedName(new OCResolveContext(this.getContainingOCFile()));
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean withoutInlineNamespaces, @NotNull Consumer<OCSymbolWithQualifiedName> observer) {
        return this.getResolvedQualifiedName(withoutInlineNamespaces, new OCResolveContext(this.getContainingOCFile()), true, true, true, true, true, observer);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(@NotNull OCResolveContext context) {
        return this.getResolvedQualifiedName(false, context, true, true, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean appendArguments) {
        return this.getResolvedQualifiedName(false, appendArguments);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean withoutInlineNamespaces, boolean appendArguments) {
        return this.getResolvedQualifiedName(withoutInlineNamespaces, new OCResolveContext(this.getContainingOCFile()), true, appendArguments, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(@NotNull OCResolveContext context, boolean appendArguments) {
        return this.getResolvedQualifiedName(false, context, true, appendArguments, true, true, true);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean withoutInlineNamespaces, @NotNull OCResolveContext context, boolean processTypesOnly, boolean appendArguments, boolean resolveArguments, boolean removeDefaultArguments, boolean treatNonMemberOperators) {
        return this.getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, resolveArguments, removeDefaultArguments, treatNonMemberOperators, null);
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(boolean withoutInlineNamespaces, @NotNull OCResolveContext context, boolean processTypesOnly, boolean appendArguments, boolean resolveArguments, boolean removeDefaultArguments, boolean treatNonMemberOperators, @Nullable Consumer<OCSymbolWithQualifiedName> observer) {
        OCQualifiedName result = null;
        OCSymbolWithQualifiedName parent = null;
        if (this.myQualifiedName == OCQualifiedName.GLOBAL) {
            result = this.myQualifiedName;
        } else {
            OCStructSymbol operatorParent = treatNonMemberOperators ? context.getNonMemberOperatorParent(this) : null;
            OCQualifiedName qualifier = this.myQualifiedName.getQualifier();
            if (qualifier != null && operatorParent == null) {
                OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(qualifier, this.getParent(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
                List<OCSymbol> possibleSymbols = context.resolveToSymbols(reference, true, processTypesOnly);
                for (OCSymbol possibleSymbol : possibleSymbols) {
                    if (!(possibleSymbol instanceof OCNamespaceSymbol)) continue;
                    parent = (OCNamespaceSymbol)possibleSymbol;
                    OCQualifiedName resolvedQualifier = parent.getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, true, removeDefaultArguments, treatNonMemberOperators, observer);
                    result = OCQualifiedName.with(resolvedQualifier, this.myName);
                    break;
                }
            } else {
                OCSymbolWithQualifiedName oCSymbolWithQualifiedName = parent = operatorParent != null ? operatorParent : this.myParent;
                while (withoutInlineNamespaces && parent instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)parent).isInlineNamespace() || parent instanceof OCStructSymbol && parent.isTransparentUnion()) {
                    parent = parent.myParent;
                }
                result = parent == null ? OCQualifiedName.with(OCQualifiedName.GLOBAL, this.myQualifiedName.getName()) : OCQualifiedName.with(parent.getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, true, removeDefaultArguments, treatNonMemberOperators, observer), this.myName);
            }
        }
        if (observer != null) {
            observer.consume((Object)this);
        }
        if (this instanceof OCTemplateSymbol && appendArguments) {
            List<OCTypeArgument> arguments = OCTypeNameVisitor.getTypeArguments(OCType.Presentation.BEST, (OCTemplateSymbol)((Object)this), resolveArguments, false, removeDefaultArguments, context);
            if (!(result == null || arguments.isEmpty() && ((OCTemplateSymbol)((Object)this)).getTemplateSpecialization() == null)) {
                return new OCQualifiedNameWithArguments(result, arguments);
            }
        }
        return result;
    }

    public void setQualifier(OCQualifiedName qualifier) {
        this.myQualifiedName = this.myQualifiedName.changeQualifier(qualifier);
    }

    public boolean isLocalInFile() {
        if ((this instanceof OCDeclaratorSymbol || this instanceof OCFunctionSymbol) && this.isStatic() && this.myFile != null && OCFileImpl.isSourceCodeFile(this.myFile.getName())) {
            OCSymbolKind kind = this.getResolvedKind();
            return kind.isGlobalVariable() || kind.isFunction() && this.myParent == null;
        }
        return false;
    }

    public boolean isConst() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return OCIcons.getVisibilityIcon(this.getVisibility(), super.getBaseIcon());
    }

    public static boolean isFriend(OCSymbol symbol) {
        return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isFriendFunction() || symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isFriendClass();
    }

    @Nullable
    public OCSymbolWithQualifiedName getResolvedOwner() {
        return this.getResolvedOwner(new OCResolveContext(this.getContainingOCFile()), true);
    }

    @Nullable
    public OCSymbolWithQualifiedName getResolvedOwner(@NotNull OCResolveContext context, boolean checkNonMemberOperators) {
        OCStructSymbol operatorParent;
        if (checkNonMemberOperators && (operatorParent = context.getNonMemberOperatorParent(this)) != null) {
            return operatorParent;
        }
        OCQualifiedName qualifier = this.myQualifiedName.getQualifier();
        if (qualifier != null) {
            OCFile file2 = this.getContainingOCFile();
            OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(qualifier, this.getParent(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            List<OCSymbol> possibleSymbols = reference.resolveToSymbols(true, true, true, context);
            for (OCSymbol possibleSymbol : possibleSymbols) {
                OCNamespaceSymbol namespace;
                if (!(possibleSymbol instanceof OCNamespaceSymbol) || (namespace = (OCNamespaceSymbol)possibleSymbol).isPredeclaration()) continue;
                CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
                namespace.processMembers(this.myName, (Processor<OCSymbol>)processor2);
                if (!processor2.isFound()) continue;
                return namespace;
            }
            return null;
        }
        return this.myParent;
    }

    @Override
    @Nullable
    public OCSymbolWithQualifiedName getParent() {
        return this.myParent;
    }

    @Override
    @Nullable
    public OCSymbol getDefinitionSymbol() {
        if (this.isPredeclaration()) {
            CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
            this.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(OCSymbol.NON_PREDIFINITION_CONDITION, (Processor)processor2));
            return (OCSymbol)processor2.getFoundValue();
        }
        return this;
    }

    @Override
    public String getKindUppercase() {
        return this.getResolvedKind().getNameUppercase();
    }

    public OCSymbolKind getResolvedKind() {
        OCSymbolKind actualKind = this.getKind();
        if (actualKind.isGlobalVariable() && this.getQualifier() != null) {
            OCFile file2 = this.getContainingOCFile();
            OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(this.getQualifier(), this.getParent(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            List<OCSymbol> possibleSymbols = reference.resolveToSymbols(true, true, file2);
            for (OCSymbol possibleSymbol : possibleSymbols) {
                if (!possibleSymbol.getKind().isStructLike()) continue;
                actualKind = OCSymbolKind.STRUCT_FIELD;
                break;
            }
        }
        return actualKind;
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2) {
        return this.processSameSymbols(processor2, null);
    }

    public boolean processSameSymbols(final Processor<OCSymbol> processor2, @Nullable PsiFile file2) {
        final Class<?> myClass = this.getClass();
        if (!processor2.process((Object)this)) {
            return false;
        }
        if (!this.isGlobal()) {
            return true;
        }
        Processor<OCSymbol> _processor = new Processor<OCSymbol>(){
            private OCQualifiedName myResolvedName;
            private OCType myResolvedType;

            public boolean process(OCSymbol symbol) {
                if (symbol.equals(OCSymbolWithQualifiedName.this)) {
                    return true;
                }
                if (!symbol.getClass().equals(myClass)) {
                    return true;
                }
                if (!(symbol instanceof OCSymbolWithQualifiedName)) {
                    return true;
                }
                if (this.myResolvedName == null) {
                    this.myResolvedName = OCSymbolWithQualifiedName.this.getResolvedQualifiedName(false);
                    if (this.myResolvedName == null) {
                        return false;
                    }
                }
                if (this.myResolvedType == null) {
                    this.myResolvedType = OCSymbolWithQualifiedName.this.getType().resolve(OCSymbolWithQualifiedName.this.getContainingOCFile());
                }
                if (!OCSymbolWithQualifiedName.this.isSameSymbol((OCSymbolWithQualifiedName)symbol, this.myResolvedName, this.myResolvedType, new OCResolveContext(OCSymbolWithQualifiedName.this.getContainingOCFile()))) {
                    return true;
                }
                return processor2.process((Object)symbol);
            }
        };
        if (file2 != null) {
            OCQualifiedName name = this.getResolvedQualifiedName();
            if (name != null) {
                OCSymbolReference.GlobalReference ref = OCSymbolReference.getGlobalReference(name);
                return ref.processPossibleSymbols(new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        return symbol.equals(OCSymbolWithQualifiedName.this) || processor2.process((Object)symbol);
                    }
                }, file2);
            }
            return true;
        }
        if (this.myProject != null) {
            final VirtualFile containingFile = this.getContainingFile();
            OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(_processor, new Condition<OCSymbol>(){

                public boolean value(OCSymbol symbol) {
                    return containingFile != null && containingFile.equals(symbol.getContainingFile());
                }
            }, Conditions.alwaysTrue());
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, orderedProcessor, this.myName);
            return orderedProcessor.finish();
        }
        return true;
    }

    @Override
    public boolean processAssociatedSymbols(final Processor<OCSymbol> processor2) {
        OCSymbol definitionSymbol;
        if (this.isPredeclaration() && (definitionSymbol = this.getDefinitionSymbol()) != null && !processor2.process((Object)definitionSymbol)) {
            return false;
        }
        final VirtualFile containingFile = this.getContainingFile();
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                return symbol == OCSymbolWithQualifiedName.this || processor2.process((Object)symbol);
            }
        }, new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                VirtualFile curContainingFile = symbol.getContainingFile();
                return containingFile != null && curContainingFile != null && containingFile.getNameWithoutExtension().equals(curContainingFile.getNameWithoutExtension());
            }
        }, Conditions.alwaysTrue());
        this.processPredeclarations(orderedProcessor);
        return orderedProcessor.finish();
    }

    @Override
    public boolean isSameSymbol(@Nullable OCSymbol symbol) {
        return this.isSameSymbol(symbol, new OCResolveContext(this.getContainingOCFile()));
    }

    public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        if (symbol instanceof OCSymbolWithQualifiedName) {
            return this.isSameSymbol((OCSymbolWithQualifiedName)symbol, this.getResolvedQualifiedName(false, context, true, false, true, true, true), this.getType().resolve(context), context);
        }
        return false;
    }

    public static boolean isSameSymbol(@Nullable OCSymbolWithQualifiedName symbol1, @Nullable OCSymbolWithQualifiedName symbol2, @NotNull OCResolveContext context) {
        return symbol1 == null && symbol2 == null || symbol1 != null && symbol2 != null && symbol1.isSameSymbol(symbol2, context);
    }

    private boolean isSameSymbol(OCSymbolWithQualifiedName symbol, @Nullable OCQualifiedName resolvedName, OCType resolvedType, @NotNull OCResolveContext context) {
        if (this.isLocalInFile() && symbol.isLocalInFile() && !Comparing.equal((Object)this.getContainingFile(), (Object)symbol.getContainingFile())) {
            return false;
        }
        if (resolvedName == null) {
            return false;
        }
        if (OCSymbolWithQualifiedName.isFriend(this) || OCSymbolWithQualifiedName.isFriend(symbol) ? !this.getName().equals(symbol.getName()) : !resolvedName.equals(symbol.getResolvedQualifiedName(false, new OCResolveContext(symbol.getContainingOCFile()), true, false, true, true, true))) {
            return false;
        }
        if (symbol instanceof OCFunctionSymbol) {
            if (((OCFunctionSymbol)symbol).isFriendFunction() && symbol.isPredeclaration() && ((OCFunctionSymbol)symbol).isCppOperator()) {
                return false;
            }
            if (!(this instanceof OCFunctionSymbol)) {
                return false;
            }
            if (((OCFunctionSymbol)symbol).getParameterSymbols().size() != ((OCFunctionSymbol)this).getParameterSymbols().size()) {
                return ((OCFunctionSymbol)symbol).getType().hasNoParameters() && ((OCFunctionSymbol)this).getType().hasNoParameters();
            }
            OCType symbolType = symbol.getResolvedType();
            OCTypeEqualityAfterResolvingVisitor typeEqualityVisitor = new OCTypeEqualityAfterResolvingVisitor(symbolType, true, context);
            if (resolvedType instanceof OCFunctionType && symbolType instanceof OCFunctionType) {
                return typeEqualityVisitor.isFunctionSignatureEqual(resolvedType);
            }
            return resolvedType.accept(typeEqualityVisitor);
        }
        return true;
    }

    @Override
    @Nullable
    public String getLocationString() {
        OCQualifiedName qualifier;
        OCQualifiedName name;
        if (this.isGlobal() && (name = this.getResolvedQualifiedName(false, new OCResolveContext(this.getContainingOCFile()), true, false, true, true, false)) != null && (qualifier = name.getQualifier()) != null) {
            String result;
            if (qualifier.getSuperQualifier() == OCQualifiedName.GLOBAL.getName()) {
                qualifier = qualifier.dropSuperQualifier();
            }
            if (!(result = qualifier.getCanonicalName(true)).isEmpty()) {
                return result;
            }
        }
        return this.myFile == null ? null : this.myFile.getName();
    }

    @Override
    public OCSymbol getAssociatedSymbol() {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processAssociatedSymbols((Processor<OCSymbol>)finder);
        return (OCSymbol)finder.getFoundValue();
    }
}

